/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table.editors;

import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.EventListenerList;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.TextComponent;

abstract class BaseTextFieldEditor
extends AbstractCellEditor
implements TableCellEditor {
    private int columns = 0;
    private TextComponent editor;
    private EventListenerList listenerList = new EventListenerList();

    BaseTextFieldEditor() {
    }

    @Override
    public abstract Object getCellEditorValue();

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getColumns() {
        return this.columns;
    }

    @Override
    public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
        return this.createEditor(parent, value);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.listenerList.add(DocumentListener.class, listener);
    }

    @Override
    public UiComponent createEditor(UiContainer parent, Object value) {
        this.editor = this.createEditor(parent);
        Object adaptedvalue = this.getEditableValue(value);
        this.setValue(adaptedvalue);
        for (DocumentListener listener : this.getDocumentListener()) {
            this.editor.addDocumentListener(listener);
        }
        return this.editor;
    }

    protected abstract void setValue(Object var1);

    protected abstract TextComponent createEditor(UiContainer var1);

    protected Object getEditableValue(Object value) {
        return value;
    }

    protected TextComponent getEditor() {
        return this.editor;
    }

    private Iterable<DocumentListener> getDocumentListener() {
        return this.listenerList.getListenersByType(DocumentListener.class);
    }
}

