/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.statusbar;

import javax.swing.JComponent;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.statusbar.StatusBarEventListener;

class StatusMessage
extends BorderPanel {
    private int id_d;
    private Image image_d;
    private Label label;
    private String message_d;
    private static final int OFFSET_IMAGE = 4;
    private static final int OFFSET_LEFT = 6;
    private static final int OFFSET_TOP = 6;

    public StatusMessage(UiContainer parent) {
        this(parent, null, -1);
    }

    public StatusMessage(UiContainer parent, StatusBarEventListener callback, int id) {
        super(parent);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setName("status-message");
        this.message_d = null;
        this.image_d = null;
        this.id_d = id;
        this.label = Label.create(this);
        this.label.setName("status-message-label");
        this.add(this.label);
        this.label.addMouseListener(new MyMouseListener(this, callback));
    }

    public void setId(int id) {
        this.id_d = id;
    }

    public int getId() {
        return this.id_d;
    }

    public void setMessage(Msg msg) {
        if (msg != null) {
            this.setMessage(null, msg.getString());
        } else {
            this.setMessage(null, "");
        }
    }

    public void setMessage(String m) {
        this.setMessage(null, m);
    }

    public void setMessage(Image image, String m) {
        this.image_d = image;
        this.message_d = m;
        this.label.setIcon(image);
        if (UiUtilities.isEventDispatchThread()) {
            this.label.setText(this.message_d);
        } else {
            UiUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusMessage.this.label.setText(StatusMessage.this.message_d);
                }
            });
        }
    }

    @Override
    public Dimension getMinimumSize() {
        int h;
        int w;
        String s;
        String string = s = this.message_d == null ? "DEFAULT" : this.message_d;
        if (this.getNative() instanceof JComponent && this.asSwing().isDisplayable()) {
            Graphics g = this.getGraphics();
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            w = 6;
            if (this.image_d != null) {
                w += this.image_d.getWidth() + 4;
            }
            w += fm.stringWidth(s) + 6;
            h = 12 + fm.getHeight();
        } else {
            w = 90;
            h = 18;
        }
        return Dimension.valueOf(w, h);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void reset() {
        this.message_d = null;
        this.image_d = null;
        this.repaint();
    }

    private static class MyMouseListener
    extends MouseAdapter {
        private StatusBarEventListener statusBarEventListener;
        private StatusMessage statusMessage;

        public MyMouseListener(StatusMessage statusMessage, StatusBarEventListener statusBarEventListener) {
            this.statusMessage = statusMessage;
            this.statusBarEventListener = statusBarEventListener;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (this.statusBarEventListener != null && !evt.isPopupTrigger()) {
                if (evt.getClickCount() > 1) {
                    this.statusBarEventListener.statusMessageDoubleClicked();
                } else {
                    this.statusBarEventListener.statusMessageClicked(this.statusMessage);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (this.statusBarEventListener != null) {
                this.statusBarEventListener.statusMessageEntered(this.statusMessage);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (this.statusBarEventListener != null) {
                this.statusBarEventListener.statusMessageExited();
            }
        }
    }
}

