/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.selector;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.selector.EditorListener;
import oracle.bpm.ui.selector.SelectorEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSelectorEditor<K, V>
implements SelectorEditor<K, V> {
    private List<EditorListener> listeners = new ArrayList<EditorListener>();
    private K selectorValue;
    private V value;

    protected AbstractSelectorEditor(K selectorValue, V value) {
        this.selectorValue = selectorValue;
        this.value = value;
    }

    @Override
    @NotNull
    public abstract String getLabel();

    @Override
    @NotNull
    public abstract UiComponent getUiComponent(@NotNull UiContainer var1);

    @Override
    @Nullable
    public Image getIcon() {
        return null;
    }

    @Override
    @NotNull
    public K getSelectorValue() {
        return this.selectorValue;
    }

    @Override
    @NotNull
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public void addEditorListener(@NotNull EditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEditorListener(@NotNull EditorListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEditorChanged() {
        for (EditorListener listener : this.listeners) {
            listener.editorChanged();
        }
    }
}

