/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.draw.Color;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.AbstractEditor;

public class IdentifierPropertyEditor
extends AbstractEditor {
    private IdentifierTextField editor;

    @Override
    public Object getCellEditorValue() {
        return this.editor.getText().trim();
    }

    @Override
    public UiComponent getEditor(UiContainer parent) {
        this.editor = this.createEditor(parent);
        return UiComponent.get(this.editor);
    }

    @Override
    public void statusChanged(AbstractProperty property) {
        if (this.editor != null) {
            if (property.getStatus().isError()) {
                this.editor.setForeground(Color.RED);
            } else {
                this.editor.setForeground(Color.BLACK);
            }
        }
    }

    private IdentifierTextField createEditor(UiContainer parent) {
        final IdentifierTextField editor = new IdentifierTextField(parent);
        editor.setBorder(null);
        editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!editor.isDisposed()) {
                            editor.selectAll();
                        }
                    }
                };
                UiUtilities.invokeLater(runnable);
            }
        });
        Property property = this.getProperty();
        editor.setEditable(property.isEditable());
        editor.setText((String)this.getProperty().getValue());
        editor.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                IdentifierPropertyEditor.this.updateValue();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdentifierPropertyEditor.this.updateValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdentifierPropertyEditor.this.updateValue();
            }
        });
        return editor;
    }

    private void updateValue() {
        Property property = this.getProperty();
        property.updateValue(this.getCellEditorValue());
    }
}

