/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;

public class ColorRect
extends Panel {
    private Color borderColor;
    private Color color;

    public ColorRect(UiContainer parent, Color color) {
        this(parent, color, Color.BLACK);
    }

    public ColorRect(UiContainer parent, Color color, Color borderColor) {
        super(parent);
        this.color = color;
        this.borderColor = borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension parentSize = super.getPreferredSize();
        if (parentSize != null && parentSize.getWidth() > 0) {
            return Dimension.valueOf(18, parentSize.getHeight());
        }
        return parentSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        Color gColor = g.getForeground();
        g.setForeground(this.getBorderColor());
        g.drawRect(0, 0, w, h);
        g.setForeground(this.getColor());
        g.fillRect(1, 1, w - 1, h - 1);
        g.setForeground(gColor);
    }

    private Color getBorderColor() {
        return this.borderColor;
    }

    private Color getColor() {
        return this.color;
    }
}

