/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop;

import java.util.Arrays;
import java.util.Vector;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.BorderStyleProperty;
import oracle.bpm.ui.prop.impl.ColorProperty;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.ComboValueProvider;
import oracle.bpm.ui.prop.impl.FontProperty;
import oracle.bpm.ui.prop.impl.IdentifierTextProperty;
import oracle.bpm.ui.prop.impl.LazyComboProperty;
import oracle.bpm.ui.prop.impl.LongTextProperty;
import oracle.bpm.ui.prop.impl.NumericProperty;
import oracle.bpm.ui.prop.impl.RegexpTextProperty;
import oracle.bpm.ui.prop.impl.ResetPropertyEditor;
import oracle.bpm.ui.prop.impl.TextProperty;

public class Factory {
    public static BooleanProperty createBoolean(Msg key, boolean value) {
        BooleanProperty property = new BooleanProperty(key, value);
        Factory.setDescription(key, property);
        return property;
    }

    public static BorderStyleProperty createBorderStyleCombo(Msg key, BorderStyle borderStyle) {
        BorderStyleProperty property = new BorderStyleProperty(key, borderStyle);
        ResetPropertyEditor resetableEditor = new ResetPropertyEditor(property.getPropertyEditor());
        property.setPropertyEditor(resetableEditor);
        Factory.setDescription(key, property);
        return property;
    }

    public static ColorProperty createColor(Msg key, Color defaultColor) {
        ColorProperty property = new ColorProperty(key, defaultColor);
        Factory.setDescription(key, property);
        return property;
    }

    public static LazyComboProperty createLazyCombo(Msg key, ComboValueProvider provider, Object value) {
        LazyComboProperty property = new LazyComboProperty(key, provider, value);
        Factory.setDescription(key, property);
        return property;
    }

    public static ComboProperty createCombo(Msg key, Vector values, Object value) {
        ComboProperty property = new ComboProperty(key, values, value);
        Factory.setDescription(key, property);
        return property;
    }

    public static ComboProperty createCombo(Msg key, Vector values, int selectedIndex) {
        ComboProperty property = new ComboProperty(key, values, selectedIndex);
        Factory.setDescription(key, property);
        return property;
    }

    public static ComboProperty createCombo(Msg msg, Object[] values, int index) {
        return Factory.createCombo(msg, new Vector<Object>(Arrays.asList(values)), index);
    }

    public static ComboProperty createCombo(Msg msg, Object[] values, Object value) {
        return Factory.createCombo(msg, new Vector<Object>(Arrays.asList(values)), value);
    }

    public static FontProperty createFont(Msg key, Font defaultFont) {
        FontProperty property = new FontProperty(key, defaultFont);
        Factory.setDescription(key, property);
        return property;
    }

    public static LongTextProperty createLongText(Msg key, String value) {
        LongTextProperty property = new LongTextProperty(key, value);
        Factory.setDescription(key, property);
        return property;
    }

    public static RegexpTextProperty createRegexpText(Msg key, String value) {
        return Factory.createRegexpText(key, value, true);
    }

    public static RegexpTextProperty createRegexpText(Msg key, String value, boolean realtime) {
        RegexpTextProperty property = new RegexpTextProperty(key, "[\\w]*", value, realtime);
        Factory.setDescription(key, property);
        return property;
    }

    public static IdentifierTextProperty createIdentifierText(Msg key, String value) {
        IdentifierTextProperty property = new IdentifierTextProperty(key, value);
        Factory.setDescription(key, property);
        return property;
    }

    public static RegexpTextProperty createRegexpText(Msg key, String pattern, String value) {
        RegexpTextProperty property = new RegexpTextProperty(key, pattern, value);
        Factory.setDescription(key, property);
        return property;
    }

    public static NumericProperty createDoubleNumber(Msg key, double value, double min, double max, double step) {
        return Factory.createNumber(key, value, min, max, step, Double.class);
    }

    public static NumericProperty createIntegerNumber(Msg key, int value, int min, int max, int step) {
        return Factory.createNumber(key, value, min, max, step, Integer.class);
    }

    public static TextProperty createText(Msg key, String value) {
        TextProperty property = new TextProperty(key, value);
        Factory.setDescription(key, property);
        return property;
    }

    public static TextProperty createText(Msg key, String value, boolean realTime) {
        TextProperty property = new TextProperty(key, value, realTime);
        Factory.setDescription(key, property);
        return property;
    }

    private static <E extends Number> NumericProperty createNumber(Msg key, E value, E minimum, E maximum, E step, Class<E> clazz) {
        NumericProperty<E> property = new NumericProperty<E>(key, value, minimum, maximum, step, clazz);
        Factory.setDescription(key, property);
        return property;
    }

    private static void setDescription(Msg key, AbstractProperty property) {
        String descrition = key.getDetail();
        if (descrition != null) {
            property.setDescription(descrition);
        }
    }
}

