/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.interval;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.event.CaretListener;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormat;
import oracle.bpm.lang.IntervalFormatException;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.Str;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.peer.IntervalFieldPeer;
import oracle.bpm.ui.peer.TextComponentPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.interval.TimeIntervalField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedListener;

public class SwingIntervalField
extends SwingComponent
implements IntervalFieldPeer,
TextComponentPeer {
    public SwingIntervalField(SwingComponent parent, IntervalUnit from, IntervalUnit to, String pattern, Locale locale) {
        super(parent, null);
        this.setComponent(new ExtendedIntervalField(from, to, locale));
    }

    @Override
    public Interval getInterval() {
        return this.getJIntervalField().getInterval();
    }

    @Override
    public void setInterval(Interval interval) {
        this.getJIntervalField().setInterval(interval);
    }

    @Override
    public void addValueChangedListener(ValueChangedListener listener) {
        this.getJIntervalField().addValueChangedListener(listener);
    }

    @Override
    public void setOnlyPositiveValues(boolean isOnlyPositiveValues) {
        this.getJIntervalField().setOnlyPositiveValues(isOnlyPositiveValues);
    }

    @Override
    public void setAutoscrolls(boolean autoscroll) {
        this.getJIntervalField().setAutoscrolls(autoscroll);
    }

    @Override
    public void setCaretPosition(int position) {
        this.getJIntervalField().setCaretPos(position);
    }

    @Override
    public int getCaretPosition() {
        return this.getJIntervalField().getCaretPos();
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getSelectedText() {
        return this.getJIntervalField().getText();
    }

    @Override
    public void setSelectionEnd(int end) {
    }

    @Override
    public int getSelectionEnd() {
        return 0;
    }

    @Override
    public void setSelectionStart(int start) {
    }

    @Override
    public int getSelectionStart() {
        return 0;
    }

    @Override
    public void clearSelection() {
    }

    @Override
    public void setText(String text) {
        this.getJIntervalField().setText(text);
    }

    @Override
    public String getText() {
        return this.getJIntervalField().getText();
    }

    @Override
    public void addCaretListener(CaretListener listener) {
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
    }

    @Override
    public void copy() {
    }

    @Override
    public void cut() {
    }

    @Override
    public void moveCaretPosition(int position) {
        this.getJIntervalField().setCaretPos(position);
    }

    @Override
    public void paste() {
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
    }

    @Override
    public void replaceSelection(String replacement) {
    }

    @Override
    public void select(int start, int end) {
    }

    @Override
    public void selectAll() {
    }

    private ExtendedIntervalField getJIntervalField() {
        return (ExtendedIntervalField)this.getJComponent();
    }

    public class ExtendedIntervalField
    extends TimeIntervalField
    implements Serializable {
        private IntervalUnit from;
        private Interval interval;
        private boolean isOnlyPositiveValues;
        private IntervalUnit to;
        private static final long serialVersionUID = -2977637472578829785L;

        public ExtendedIntervalField() {
            this(IntervalUnit.MONTHS, IntervalUnit.SECONDS);
        }

        public ExtendedIntervalField(String pattern) {
            this(null, IntervalUnit.YEARS, pattern);
        }

        public ExtendedIntervalField(IntervalUnit from, IntervalUnit to) {
            this(from, to, (String)null);
        }

        public ExtendedIntervalField(String pattern, Locale locale) {
            this(null, IntervalUnit.YEARS, pattern, locale);
        }

        public ExtendedIntervalField(IntervalUnit from, IntervalUnit to, Locale locale) {
            this(from, to, null, locale);
        }

        private ExtendedIntervalField(IntervalUnit from, IntervalUnit to, String pattern) {
            this(from, to, pattern, Locale.getDefault());
        }

        private ExtendedIntervalField(IntervalUnit from, IntervalUnit to, String pattern, Locale locale) {
            super(from == null ? TimeField.Format.CUSTOM : TimeField.Format.LONG, pattern, locale);
            this.from = from;
            this.to = to;
            this.init();
        }

        @Override
        public Object getDefault() {
            return this.default_d == null && this.isRequired() ? Interval.ZERO : this.default_d;
        }

        public void setInterval(Interval interval) {
            if (interval != null && interval.equals(this.interval)) {
                return;
            }
            if (interval != null || !this.isRequired()) {
                if (interval != null && this.isOnlyPositiveValues && (interval.getMonths() < 0 || interval.getDays() < 0 || interval.getMicroSeconds() < 0L)) {
                    return;
                }
                this.text_d = interval == null ? "" : ((IntervalFormat)this.format_d).format(interval);
                this.interval = interval;
                this.findParsePositions();
                this.fireValueChangedEvent();
            }
        }

        public Interval getInterval() {
            return this.interval;
        }

        @Override
        public void setValue(Object value) {
            this.setInterval((Interval)value);
        }

        @Override
        public Object getValue() {
            return this.getInterval();
        }

        public void setOnlyPositiveValues(boolean isOnlyPositiveValues) {
            this.isOnlyPositiveValues = isOnlyPositiveValues;
        }

        @Override
        protected Format buildFormat(String formatString) {
            return new IntervalFormat(formatString, this.locale_d);
        }

        @Override
        protected void init() {
            if (TimeField.Format.CUSTOM.equals((Object)this.format)) {
                this.format_d = new IntervalFormat(this.formatString_d, this.locale_d);
            } else {
                this.format_d = IntervalFormat.getInstance(this.from, this.to, this.locale_d);
                this.formatString_d = ((IntervalFormat)this.format_d).toPattern();
            }
            int len = (this.formatString_d.length() - Str.count(this.formatString_d, '\'')) * 85 / 100;
            if (this.interval == null) {
                this.text_d = "";
            } else {
                this.text_d = ((IntervalFormat)this.format_d).format(this.interval);
                len = Math.max(this.text_d.length(), len);
            }
            this.setColumns(len);
            super.init();
        }

        @Override
        protected Object parse(String text) {
            Interval interval = null;
            try {
                interval = ((IntervalFormat)this.format_d).parse(text);
            }
            catch (ParseException ignore) {
            }
            catch (IntervalFormatException ignore) {
                // empty catch block
            }
            if (interval == null) {
                try {
                    interval = Interval.valueOf(text);
                }
                catch (IntervalFormatException intervalFormatException) {
                    // empty catch block
                }
            }
            return interval;
        }

        @Override
        protected boolean rollField(String fmt, boolean up) {
            boolean only;
            IntervalUnit field = IntervalUnit.valueOf(fmt.charAt(0));
            int count = fmt.length();
            boolean bl = only = count <= 2;
            if (field == IntervalUnit.MICROSECONDS && count <= 6 || field == IntervalUnit.MILLISECONDS && count <= 3) {
                only = true;
            }
            if (field == null) {
                return false;
            }
            if (only) {
                this.setInterval(this.interval.setOnly(field, this.interval.getOnly(field) + (long)(up ? 1 : -1)));
            } else {
                this.setInterval(this.interval.set(field, this.interval.get(field) + (long)(up ? 1 : -1)));
            }
            return true;
        }
    }
}

