/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.FuegoUIException;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardLastStep;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.model.WizardSupport;
import oracle.bpm.ui.wizards.ui.ButtonPanel;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.ui.wizards.ui.WizardTitlePanel;

public final class SwingWizardSupport
extends Dialog
implements WizardSupport {
    protected Wizard wizard;
    private ButtonPanel buttonPanel;
    private CardLayout cardLayout;
    private WizardStepPanel currentPanel;
    private Panel stepPanel;
    private WizardTitlePanel titlePanel;
    private static final Color SOME_GRAY = Color.valueOf(127, 127, 124);

    public SwingWizardSupport(Wizard wizard) {
        super(Ui.getRoot());
        this.wizard = wizard;
        this.refreshTitle();
    }

    public SwingWizardSupport(UiWindow f, Wizard wizard) {
        super(f, wizard.getMsg(), true);
        this.wizard = wizard;
    }

    public SwingWizardSupport(Dialog d, Wizard wizard) {
        super(d);
        this.setMsg(wizard.getMsg());
        this.wizard = wizard;
    }

    @Override
    public void accept() {
        System.out.println("WizardDialog.accept");
        Thread.dumpStack();
    }

    @Override
    public void cancel() {
        if (this.getCurrentPanel().cancel()) {
            this.close();
        }
    }

    public CardLayout getCardLayout() {
        return this.cardLayout;
    }

    @Override
    public UiContainer getExtensionParent() {
        return this.stepPanel;
    }

    @Override
    public void setExtensionParent(UiContainer parent) {
    }

    @Override
    public int run() {
        this.setVisible(true);
        this.setVisible(false);
        this.dispose();
        return 0;
    }

    @Override
    public void showStep(WizardStepPanel panel) {
        this.addPanel(panel);
        this.revalidate();
        this.showStepPanel(panel);
        this.setCurrentPanel(panel);
        this.setDefaultButton(panel.getDefaultButton());
        this.getContentPane().requestFocus();
    }

    @Override
    public Button getNextButton() {
        return this.getButtonPanel().getNextButton();
    }

    @Override
    public Button getBackButton() {
        return this.getButtonPanel().getBackButton();
    }

    @Override
    public Button getFinishButton() {
        return this.getButtonPanel().getFinishButton();
    }

    @Override
    public Button getCancelButton() {
        return this.getButtonPanel().getCancelButton();
    }

    @Override
    public String getDefaultWindowHelpId() {
        return SwingWizardSupport.getHelpIdFromObjectClass(this.wizard);
    }

    @Override
    public String getHelpId() {
        return this.currentPanel.getHelpId();
    }

    @Override
    public void setCurrentPanel(WizardStepPanel currentPanel) {
        this.currentPanel = currentPanel;
    }

    @Override
    public void initialize() {
        try {
            this.getWizard().putProperty("oracle.bpm.wizard.banner", this.getWizard().getBanner());
            UiContainer contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            this.titlePanel = this.createTitlePanel(this);
            this.titlePanel.setBorder(new LineBorder(1));
            this.add(this.titlePanel, "North");
            this.buttonPanel = this.createButtonPanel(this);
            this.add(this.buttonPanel, "South");
            this.cardLayout = new CardLayout();
            this.stepPanel = new Panel(contentPane);
            this.stepPanel.setLayout(this.cardLayout);
            contentPane.add(this.stepPanel, "Center");
            this.stepPanel.setInsets(new Margin(10, 10, 10, 10));
            WizardStepPanel initialPanel = this.getWizard().getFirstStep().getStepPanelFor(this.getExtensionParent(), this);
            this.showStep(initialPanel);
            this.showStepPanel(initialPanel);
            this.setPosition();
            this.setSize(this.wizard.getProperSize());
            this.setLocationRelativeTo(Ui.getRoot());
            this.repaint();
        }
        catch (Exception e) {
            throw new FuegoUIException("Error while creating swing wizard", e);
        }
    }

    @Override
    public void ensureSize() {
    }

    public void back() {
        this.getCurrentPanel().moveBackward();
    }

    public void next() {
        WizardStep wizardStep = this.getWizardStep();
        if (wizardStep.isLastStep() || wizardStep instanceof WizardLastStep) {
            this.getCurrentPanel().doClose();
        } else {
            this.getCurrentPanel().moveForward();
        }
    }

    public void finish() {
        if (this.getWizardStep().isFinishable()) {
            this.getCurrentPanel().doFinish();
        } else {
            this.getCurrentPanel().doClose();
        }
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public WizardTitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    @Override
    public void refreshTitle() {
        Msg msg = this.wizard.getMsg();
        if (msg != null) {
            this.setMsg(msg);
            Image image = Image.create(msg);
            if (image != null) {
                this.setIconImage(image);
            }
        }
    }

    @Override
    public void refreshPageTitle() {
    }

    @Override
    public void refreshPageDescription() {
    }

    protected ButtonPanel createButtonPanel(UiContainer parent) {
        ButtonPanel buttonPanel = new ButtonPanel(parent){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return super.isVisible();
            }
        };
        Button backButton = buttonPanel.getBackButton();
        Button nextButton = buttonPanel.getNextButton();
        Button cancelButton = buttonPanel.getCancelButton();
        Button finishButton = buttonPanel.getFinishButton();
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWizardSupport.this.back();
            }
        });
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWizardSupport.this.next();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWizardSupport.this.cancel();
            }
        });
        finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWizardSupport.this.finish();
            }
        });
        buttonPanel.revalidate();
        return buttonPanel;
    }

    protected WizardStepPanel getCurrentPanel() {
        return this.currentPanel;
    }

    protected Wizard getWizard() {
        return this.wizard;
    }

    protected void setPosition() {
    }

    private WizardTitlePanel createTitlePanel(UiContainer parent) {
        return new WizardTitlePanel(parent, this.wizard.getIcon());
    }

    private WizardStep getWizardStep() {
        return this.getCurrentPanel().getWizardStep();
    }

    private void addPanel(WizardStepPanel aPanel) {
        Panel stepPanel = (Panel)this.getExtensionParent();
        assert (aPanel.getStepName() != null) : "Invalid step panel name";
        if (!this.containsStep(aPanel)) {
            stepPanel.add(aPanel, aPanel.getStepName());
        } else {
            stepPanel.removeAll();
            stepPanel.add(aPanel, aPanel.getStepName());
        }
        if (aPanel.getLayoutData() == null) {
            aPanel.setLayoutData(aPanel.getStepName());
        }
        this.setCurrentPanel(aPanel);
    }

    private boolean containsStep(WizardStepPanel panel) {
        List<UiComponent> children = this.getExtensionParent().getChildren();
        for (UiComponent component : children) {
            WizardStepPanel childPanel = (WizardStepPanel)component;
            if (!panel.getStepName().equals(childPanel.getStepName())) continue;
            return true;
        }
        return false;
    }

    private void showStepPanel(WizardStepPanel initialPanel) {
        this.getTitlePanel().setTitle(Str.null2empty(initialPanel.getPageTitle()));
        this.getTitlePanel().setDescription(Str.null2empty(initialPanel.getPageDescription()));
        this.getCardLayout().show(this.getExtensionParent(), initialPanel.getStepName());
        boolean backEnabled = !this.getWizardStep().isFirstStep() && this.getWizardStep().canMoveBack();
        this.getBackButton().setEnabled(backEnabled);
        if (backEnabled) {
            this.getBackButton().setVisible(true);
        }
        boolean enableFinish = this.getWizardStep().isFinishable() || this.getWizardStep().isLastStep();
        this.getFinishButton().setEnabled(enableFinish);
        this.getNextButton().setEnabled(!this.getWizardStep().isLastStep());
        this.getCancelButton().setEnabled(!this.getWizardStep().isSummaryStep());
    }

    public static class LineBorder
    extends Border {
        private int position;
        private String title;
        protected static final int EDGE_SPACING = 2;
        protected static final int TEXT_SPACING = 2;
        protected static final int TEXT_INSET_H = 5;
        public static final int MIDDLE = 0;
        public static final int BOTTOM = 1;

        public LineBorder() {
            this(null, 0);
        }

        public LineBorder(int position) {
            this(null, position);
        }

        public LineBorder(String title) {
            this(title, 0);
        }

        LineBorder(String title, int position) {
            super(null);
            this.title = title;
            this.position = position;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public Insets getBorderInsets(UiComponent c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(UiComponent c, Insets insets) {
            int descent = 0;
            int ascent = 16;
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            left += 4;
            right += 4;
            top += 4;
            bottom += 4;
            if (c == null || this.getTitle() == null || "".equals(this.getTitle())) {
                return insets;
            }
            Font font = this.getFont(c);
            FontMetrics fm = c.getFontMetrics(font);
            if (fm != null) {
                descent = fm.getDescent();
                ascent = fm.getAscent();
            }
            switch (this.position) {
                case 0: {
                    top += ascent + descent;
                    break;
                }
                case 1: {
                    bottom = ascent + descent;
                }
            }
            return new Insets(top, left, bottom, right);
        }

        public Color getTitleColor() {
            return UiManager.color("TitledBorder.titleColor");
        }

        @Override
        public void paintBorder(UiComponent c, Graphics g, int x, int y, int width, int height) {
            Font font = null;
            Color color = null;
            int textLocY = 0;
            if (this.getTitle() != null && !"".equals(this.getTitle())) {
                Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
                font = g.getFont();
                color = g.getForeground();
                g.setFont(this.getFont(c));
                FontMetrics fm = g.getFontMetrics();
                int fontHeight = fm.getHeight();
                int descent = fm.getDescent();
                int ascent = fm.getAscent();
                int strWidth = fm.stringWidth(this.getTitle()) + 2;
                switch (this.position) {
                    case 0: {
                        int diff = Math.max(0, ascent / 2 + 2 - 2);
                        grooveRect = new Rectangle(grooveRect.getX(), grooveRect.getY() + diff, grooveRect.getWidth(), grooveRect.getHeight() - diff);
                        textLocY = grooveRect.getY() - descent + (ascent + descent) / 2;
                        break;
                    }
                    case 1: {
                        grooveRect = new Rectangle(grooveRect.getX(), grooveRect.getY(), grooveRect.getWidth(), grooveRect.getHeight() - fontHeight / 2);
                        textLocY = grooveRect.getY() + grooveRect.getHeight() - descent + (ascent + descent) / 2;
                    }
                }
                int textLocX = grooveRect.getX();
                g.setForeground(Color.WHITE);
                g.drawString(this.getTitle(), textLocX + 1, textLocY + 1);
                g.setForeground(SOME_GRAY);
                g.drawString(this.getTitle(), textLocX, textLocY);
                x = textLocX + strWidth;
                y = textLocY - (fm.getHeight() - ascent / 2) / 2;
            }
            switch (this.position) {
                case 1: {
                    y = height - 2;
                }
            }
            g.setForeground(SOME_GRAY);
            g.drawLine(x, y, width, y);
            g.setForeground(Color.WHITE);
            g.drawLine(x, ++y, width, y);
            g.setFont(font);
            g.setForeground(color);
        }

        protected Font getFont(UiComponent c) {
            Font font;
            return c != null && (font = c.getFont()) != null ? font : Font.DIALOG;
        }

        private String getTitle() {
            return this.title;
        }
    }
}

