/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.ActionStyle;
import oracle.bpm.ui.ButtonEffect;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.peer.ToolBarItemPeer;
import oracle.bpm.ui.peer.swing.SwingAbstractButton;
import oracle.bpm.ui.peer.swing.SwingButton;
import oracle.bpm.ui.peer.swing.SwingCompositeButton;
import oracle.bpm.ui.peer.swing.SwingToggleButton;
import oracle.bpm.ui.peer.swing.SwingToolBar;

public class SwingToolBarItem
extends SwingAbstractButton
implements ToolBarItemPeer {
    private ToolBarItemPeer delegate;
    static final Dimension DEFAULT_SIZE = Dimension.valueOf(22, 22);

    private SwingToolBarItem(SwingToolBar toolBar, ToolBarItemPeer delegate) {
        super(toolBar, ((SwingAbstractButton)((Object)delegate)).getComponent());
        this.delegate = delegate;
        AbstractButton button = this.getAbstractButton();
        toolBar.getToolBar().add(button);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ButtonEffect.setEffect(button);
        if (delegate instanceof ButtonToolBarItem || delegate instanceof DropDownToolBarItem) {
            button.putClientProperty("oracle.bpm.ui.button.effect.restoreOnPress", Boolean.TRUE);
        }
    }

    public static ToolBarItemPeer create(SwingToolBar toolBar, ActionStyle actionStyle) {
        SwingAbstractButton delegate;
        switch (actionStyle) {
            case CHECK: {
                delegate = new CheckToolBarItem(toolBar);
                break;
            }
            case RADIO: {
                delegate = new RadioToolBarItem(toolBar);
                break;
            }
            case DROP_DOWN: {
                delegate = new DropDownToolBarItem(toolBar);
                break;
            }
            default: {
                delegate = new ButtonToolBarItem(toolBar);
            }
        }
        return new SwingToolBarItem(toolBar, (ToolBarItemPeer)((Object)delegate));
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.checkButtonSize();
    }

    @Override
    public void setAction(BaseAction action) {
        this.getDelegate().setAction(action);
    }

    @Override
    public void setDropDownAction(BaseAction action) {
        this.getDelegate().setDropDownAction(action);
    }

    @Override
    protected AbstractButton getAbstractButton() {
        return (AbstractButton)this.getComponent();
    }

    private static void setAllSizes(SwingAbstractButton button, Dimension size) {
        button.setMinimumSize(size);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
    }

    private ToolBarItemPeer getDelegate() {
        return this.delegate;
    }

    private void checkButtonSize() {
        int width = DEFAULT_SIZE.getWidth();
        String text = this.getText();
        if (text != null && text.length() > 0) {
            width += this.getFontMetrics(this.getFont()).stringWidth(text) + 10;
        }
        SwingToolBarItem.setAllSizes((SwingAbstractButton)((Object)this.getDelegate()), width <= DEFAULT_SIZE.getWidth() ? DEFAULT_SIZE : Dimension.valueOf(width, DEFAULT_SIZE.getHeight()));
    }

    private static class RadioToolBarItem
    extends SwingToggleButton
    implements ToolBarItemPeer {
        RadioToolBarItem(SwingToolBar parent) {
            super(parent);
            SwingToolBarItem.setAllSizes(this, DEFAULT_SIZE);
            this.includeRadioInGroup();
        }

        @Override
        public void setDropDownAction(BaseAction action) {
        }

        private void includeRadioInGroup() {
            this.getSwingToolBar().getCurrentGroup().add(this.getAbstractButton());
        }

        private SwingToolBar getSwingToolBar() {
            return (SwingToolBar)super.getParent();
        }
    }

    private static class DropDownToolBarItem
    extends SwingCompositeButton
    implements ToolBarItemPeer {
        DropDownToolBarItem(SwingToolBar parent) {
            super(parent);
        }
    }

    private static class CheckToolBarItem
    extends SwingToggleButton
    implements ToolBarItemPeer {
        CheckToolBarItem(SwingToolBar parent) {
            super(parent);
            SwingToolBarItem.setAllSizes(this, DEFAULT_SIZE);
        }

        @Override
        public void setDropDownAction(BaseAction action) {
        }
    }

    private static class ButtonToolBarItem
    extends SwingButton
    implements ToolBarItemPeer {
        ButtonToolBarItem(SwingToolBar parent) {
            super(parent);
            SwingToolBarItem.setAllSizes(this, DEFAULT_SIZE);
        }

        @Override
        public void setDropDownAction(BaseAction action) {
        }
    }
}

