/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicScrollBarUI;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.statusbar.StatusBar;
import oracle.bpm.ui.utils.IconUtility;

public class SwingHScroll
extends JPanel
implements SwingConstants {
    private Component component;
    private JButton eastButton;
    private int increment = 10;
    private JScrollPane scrollPane;
    private JButton westButton;
    private static final long serialVersionUID = 0L;

    public SwingHScroll() {
        this.init(4, true);
    }

    public SwingHScroll(Component component) {
        this();
        this.setComponent(component);
    }

    public void setComponent(Component component) {
        this.component = component;
        this.scrollPane.setViewportView(component);
    }

    public Component getComponent() {
        return this.component;
    }

    private JButton createButton(Msg msg) {
        JButton button = new JButton(msg.getString()){
            private static final long serialVersionUID = 0L;

            @Override
            public void setBounds(int x, int y, int width, int height) {
                if (x != y || y != width || width != height || height != 0) {
                    super.setBounds(x, y, width, height);
                }
            }
        };
        ImageIcon icon = new ImageIcon(msg.getImageResource());
        Dimension buttonSize = new Dimension(icon.getIconWidth() + 4, 22);
        button.setText("");
        button.setIcon(icon);
        button.setEnabled(true);
        return button;
    }

    private void init(int buttonPosition, boolean layoutVertical) {
        this.westButton = this.createButton(UIMsg.HTOOLBAR_LEFT_MINI);
        this.eastButton = this.createButton(UIMsg.HTOOLBAR_RIGHT_MINI);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(21, 31);
        final JScrollBar customScrollBar = new JScrollBar(0);
        customScrollBar.setUnitIncrement(this.increment);
        customScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int value = e.getValue();
                    boolean enableWest = value != 0;
                    boolean enableEast = value != customScrollBar.getMaximum() - customScrollBar.getModel().getExtent();
                    SwingHScroll.this.westButton.setEnabled(enableWest);
                    SwingHScroll.this.eastButton.setEnabled(enableEast);
                }
            }
        });
        customScrollBar.setUI(new BasicScrollBarUI(){

            @Override
            protected JButton createIncreaseButton(int i) {
                return SwingHScroll.this.eastButton;
            }

            @Override
            protected JButton createDecreaseButton(int i) {
                return SwingHScroll.this.westButton;
            }
        });
        this.scrollPane.setHorizontalScrollBar(customScrollBar);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
        this.layoutButtons(buttonPosition, layoutVertical);
        this.westButton.setEnabled(false);
        this.eastButton.setEnabled(false);
    }

    private void layoutButtons(int buttonPosition, boolean layoutVertical) {
        if (buttonPosition == 0) {
            this.add((Component)this.eastButton, "East");
            this.add((Component)this.westButton, "West");
        } else {
            final JToolBar panel = new JToolBar(layoutVertical ? 1 : 0);
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        panel.setVisible(SwingHScroll.this.eastButton.isEnabled() || SwingHScroll.this.westButton.isEnabled());
                    }
                }
            };
            this.eastButton.addPropertyChangeListener(listener);
            this.westButton.addPropertyChangeListener(listener);
            panel.setFloatable(false);
            panel.add(this.westButton);
            panel.add(this.eastButton);
            if (buttonPosition == 2) {
                this.add((Component)panel, "West");
            } else {
                this.add((Component)panel, "East");
            }
        }
    }

    private static class SwingButtonEffect {
        public static final String RESTORE_ON_PRESS = "oracle.bpm.ui.button.effect.restoreOnPress";
        private static final java.awt.Color selectedBgColor_sd = AwtConverter.toAwt(UiManager.color("FuegoButton.selectedBackground"));
        private static final java.awt.Color pressedBgColor = AwtConverter.toAwt(UiManager.color("FuegoButton.pressedBackground"));

        private SwingButtonEffect() {
        }

        public static void setEffect(AbstractButton button) {
            if (button.isSwing()) {
                SwingButtonEffect.setEffect((javax.swing.AbstractButton)button.asSwing());
            }
        }

        public static void setEffect(javax.swing.AbstractButton button) {
            boolean isToggleButton;
            boolean bl = isToggleButton = button instanceof JToggleButton && !(button instanceof JCheckBox) && !(button instanceof JRadioButton);
            if (isToggleButton) {
                button.addItemListener(SwingButtonEffect.createItemListener(button));
                if (button.isSelected()) {
                    SwingButtonEffect.selectToggleButton(button);
                }
            }
            EffectManager manager = SwingButtonEffect.createEffectManager(button, isToggleButton);
            button.addMouseListener(SwingButtonEffect.createMouseListener(manager));
            button.addFocusListener(SwingButtonEffect.createFocusListener(manager));
            button.addPropertyChangeListener("oracle.bpm.action.msg", SwingButtonEffect.createPropertyChangeListener(manager));
            button.setRequestFocusEnabled(false);
        }

        private static boolean isInSameToolbar(javax.swing.AbstractButton currentButton, Component c) {
            JToolBar curentToolbar = SwingButtonEffect.getParentToolbar(currentButton);
            return curentToolbar != null && curentToolbar == SwingButtonEffect.getParentToolbar(c);
        }

        private static JToolBar getParentToolbar(Component c) {
            while (c != null) {
                if (c instanceof JToolBar) {
                    return (JToolBar)c;
                }
                c = c.getParent();
            }
            return null;
        }

        private static EffectManager createEffectManager(javax.swing.AbstractButton button, boolean toggleButton) {
            return new EffectManager(button, toggleButton);
        }

        private static FocusListener createFocusListener(EffectManager manager) {
            return new EffectFocusListener(manager);
        }

        private static ItemListener createItemListener(final javax.swing.AbstractButton button) {
            return new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JToggleButton tb = (JToggleButton)e.getSource();
                    if (tb.isSelected()) {
                        SwingButtonEffect.selectToggleButton(button);
                    } else if (!tb.isSelected()) {
                        boolean clickOnIt;
                        Boolean o = (Boolean)tb.getClientProperty("oracle.bpm.clickOnIt");
                        boolean bl = clickOnIt = o != null && o != false;
                        if (!clickOnIt) {
                            tb.setBackground(tb.getParent().getBackground());
                            tb.setBorderPainted(false);
                        }
                    }
                }
            };
        }

        private static MouseListener createMouseListener(EffectManager manager) {
            return new EffectMouseAdapter(manager);
        }

        private static PropertyChangeListener createPropertyChangeListener(EffectManager manager) {
            return new EffectButtonIconChanger(manager);
        }

        private static void selectToggleButton(javax.swing.AbstractButton button) {
            button.setBackground(pressedBgColor);
            button.setBorder(BorderFactory.createLineBorder(Color.FUEGO_BLUE).asSwing());
            button.setBorderPainted(true);
        }

        private static class EffectManager {
            java.awt.Color defaultBgColor = null;
            Icon icon = null;
            String previousMessage = null;
            Icon shadow = null;
            StatusBar statusBar = null;
            boolean toggleButton;
            private javax.swing.AbstractButton button;
            private boolean in = false;

            public EffectManager(javax.swing.AbstractButton button, boolean toggleButton) {
                this.button = button;
                this.toggleButton = toggleButton;
            }

            public javax.swing.AbstractButton getButton() {
                return this.button;
            }

            public void setIcon(Icon icon) {
                this.icon = icon;
            }

            public void setIn(boolean in) {
                this.in = in;
            }

            public boolean isIn() {
                return this.in;
            }

            public void activated() {
                if (this.icon != null) {
                    this.button.setIcon(this.icon);
                }
                this.setBackground(pressedBgColor);
            }

            public void applyEffect() {
                this.button.setIcon(this.shadow == null ? null : this.shadow);
                this.setBackground(selectedBgColor_sd);
            }

            public void focusEntered() {
                this.focusEntered(true);
            }

            public void focusEntered(boolean paintFocus) {
                this.in = true;
                this.icon = this.button.getIcon();
                if (this.toggleButton) {
                    this.button.putClientProperty("oracle.bpm.clickOnIt", Boolean.TRUE);
                }
                if (!(!paintFocus || this.toggleButton && this.button.isSelected())) {
                    this.defaultBgColor = this.button.getParent().getBackground();
                    this.shadow = this.icon != null ? IconUtility.createShadowedImage((ImageIcon)this.button.getIcon(), selectedBgColor_sd) : this.icon;
                    this.applyEffect();
                    this.button.setBorder(BorderFactory.createLineBorder(Color.FUEGO_BLUE).asSwing());
                    this.button.setBorderPainted(true);
                }
                if (this.statusBar != null) {
                    String toolTip = this.button.getToolTipText();
                    if (!Str.isEmpty(toolTip)) {
                        this.statusBar.showNotice(toolTip);
                        this.previousMessage = toolTip;
                    } else {
                        this.statusBar.clearMessage();
                    }
                }
            }

            public void focusExited() {
                if (this.in) {
                    if (!this.toggleButton || !this.button.isSelected()) {
                        this.restoreButton();
                    }
                    this.in = false;
                    if (this.toggleButton) {
                        this.button.putClientProperty("oracle.bpm.clickOnIt", null);
                    }
                }
                if (this.statusBar != null && this.previousMessage != null && this.previousMessage.equals(this.statusBar.getCurrentMessage())) {
                    this.statusBar.clearMessage();
                }
            }

            public void updateShadowIcon() {
                this.shadow = IconUtility.createShadowedImage((ImageIcon)this.icon, selectedBgColor_sd);
                this.applyEffect();
            }

            protected void restoreButton() {
                this.setBackground(this.defaultBgColor);
                this.button.setIcon(this.icon == null ? null : this.icon);
                this.button.setBorderPainted(false);
            }

            private void setBackground(java.awt.Color color) {
                this.button.setBackground(color);
            }
        }

        public static class EffectMouseAdapter
        implements MouseListener {
            EffectManager effectManager;

            public EffectMouseAdapter(EffectManager effectManager) {
                this.effectManager = effectManager;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Component c = FocusManager.getCurrentManager().getFocusOwner();
                if (SwingButtonEffect.isInSameToolbar(this.effectManager.getButton(), c)) {
                    this.effectManager.getButton().requestFocus();
                } else {
                    this.effectManager.focusEntered(this.effectManager.getButton().isEnabled());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!this.effectManager.getButton().hasFocus()) {
                    this.effectManager.focusExited();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.effectManager.getButton().isEnabled()) {
                    boolean restoreOnPress;
                    Object restoreProperty = this.effectManager.getButton().getClientProperty(SwingButtonEffect.RESTORE_ON_PRESS);
                    boolean bl = restoreOnPress = restoreProperty != null && Boolean.TRUE.equals(restoreProperty);
                    if (restoreOnPress) {
                        this.mouseExited(e);
                    } else {
                        this.effectManager.activated();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.effectManager.getButton().isEnabled()) {
                    if (this.effectManager.isIn() && (!this.effectManager.toggleButton || this.effectManager.toggleButton && !this.effectManager.getButton().isSelected())) {
                        this.effectManager.applyEffect();
                    }
                } else {
                    this.effectManager.restoreButton();
                    this.effectManager.setIn(false);
                }
            }
        }

        public static class EffectFocusListener
        implements FocusListener {
            private EffectManager manager;

            public EffectFocusListener(EffectManager manager) {
                this.manager = manager;
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.manager.focusEntered();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.manager.focusExited();
            }
        }

        public static class EffectButtonIconChanger
        implements PropertyChangeListener {
            private EffectManager effectManager;

            public EffectButtonIconChanger(EffectManager manager) {
                this.effectManager = manager;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Msg && this.effectManager.isIn()) {
                    Msg m = (Msg)evt.getNewValue();
                    this.effectManager.setIcon(new ImageIcon(m.getImageResource()));
                    this.effectManager.updateShadowIcon();
                }
            }
        }
    }
}

