/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ExtendedColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.TreeTableFontProvider;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class SwingCellRenderer<T>
implements ListCellRenderer,
TreeCellRenderer,
TableCellRenderer {
    private ColorProvider<T> colorProvider;
    private FontProvider<T> fontProvider;
    private LabelProvider<T> labelProvider;
    private DefaultListCellRenderer listRendererDelegate;
    private DefaultTableCellRenderer tableRendererDelegate;
    private DefaultTreeCellRenderer treeRendererDelegate;
    private static final Color DEFAULT_FORECOLOR = (Color)UIManager.get("Table.foreground");
    private static final Color DEFAULT_BACKCOLOR = (Color)UIManager.get("Table.background");

    public SwingCellRenderer() {
    }

    public SwingCellRenderer(LabelProvider<T> provider) {
        this.setLabelProvider(provider);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DefaultListCellRenderer delegate = this.getListRendererDelegate();
        JLabel label = (JLabel)delegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.renderValue(value, index, label, list.getFont());
        return label;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DefaultTableCellRenderer delegate = this.getTableRendererDelegate();
        JLabel label = (JLabel)delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.renderValue(value, row, label, table.getFont());
        return label;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultTreeCellRenderer delegate = this.getTreeRendererDelegate();
        JLabel label = (JLabel)delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.renderValue(value, row, label, tree.getFont());
        return label;
    }

    protected void renderValue(Object value, int index, JLabel label, Font defaultFont) {
        if (this.labelProvider != null) {
            this.renderLabel(label, value);
        }
        if (this.colorProvider != null) {
            this.renderColor(label, value, index);
        }
        if (this.fontProvider != null) {
            this.renderFont(label, value, defaultFont);
        }
    }

    void setColorProvider(ColorProvider<T> colorProvider) {
        this.colorProvider = colorProvider;
    }

    ColorProvider<T> getColorProvider() {
        return this.colorProvider;
    }

    void setFontProvider(FontProvider<T> fontProvider) {
        this.fontProvider = fontProvider;
    }

    FontProvider<T> getFontProvider() {
        return this.fontProvider;
    }

    void setLabelProvider(LabelProvider<T> provider) {
        this.labelProvider = provider;
    }

    LabelProvider<T> getLabelProvider() {
        return this.labelProvider;
    }

    private DefaultListCellRenderer getListRendererDelegate() {
        if (this.listRendererDelegate == null) {
            this.listRendererDelegate = new DefaultListCellRenderer();
        }
        return this.listRendererDelegate;
    }

    private DefaultTableCellRenderer getTableRendererDelegate() {
        if (this.tableRendererDelegate == null) {
            this.tableRendererDelegate = new DefaultTableCellRenderer();
        }
        return this.tableRendererDelegate;
    }

    private DefaultTreeCellRenderer getTreeRendererDelegate() {
        if (this.treeRendererDelegate == null) {
            this.treeRendererDelegate = new DefaultTreeCellRenderer();
        }
        return this.treeRendererDelegate;
    }

    private void renderColor(JLabel label, T element, int index) {
        ColorProvider<T> cp = this.getColorProvider();
        if (cp instanceof TableColorProvider) {
            ((TableColorProvider)cp).setRow(index);
        }
        Color foreground = AwtConverter.toAwt(cp.getForeground(element));
        Color background = AwtConverter.toAwt(cp.getBackground(element));
        if (foreground == null) {
            foreground = DEFAULT_FORECOLOR;
        }
        label.setForeground(foreground);
        if (background == null) {
            background = DEFAULT_BACKCOLOR;
        }
        label.setBackground(background);
        if (cp instanceof ExtendedColorProvider && label instanceof DefaultTreeCellRenderer) {
            ExtendedColorProvider provider = (ExtendedColorProvider)cp;
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)label;
            renderer.setBackgroundSelectionColor(AwtConverter.toAwt(provider.getBackgroundSelectionColor(element)));
            renderer.setBackgroundNonSelectionColor(AwtConverter.toAwt(provider.getBackgroundNonSelectionColor(element)));
            renderer.setTextSelectionColor(AwtConverter.toAwt(provider.getTextSelectionColor(element)));
            renderer.setTextNonSelectionColor(AwtConverter.toAwt(provider.getTextNonSelectionColor(element)));
        }
    }

    private void renderFont(JLabel label, T element, Font defaultFont) {
        oracle.bpm.draw.Font font;
        oracle.bpm.draw.Font defFont = oracle.bpm.draw.Font.valueOf(defaultFont);
        FontProvider<T> fp = this.getFontProvider();
        if (fp instanceof TreeTableFontProvider) {
            ((TreeTableFontProvider)fp).setObject(element);
        }
        if ((font = fp.getFont(element)) == null) {
            font = defFont;
        }
        label.setFont(AwtConverter.toAwt(font));
    }

    private void renderLabel(JLabel label, T value) {
        LabelProvider<T> labelProvider = this.getLabelProvider();
        try {
            String text = labelProvider.getText(value);
            label.setText(text);
            label.setToolTipText(text);
            Image image = labelProvider.getIcon(value);
            label.setIcon(image != null ? image.asSwingIcon() : null);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

