/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.filechooser;

import java.beans.PropertyChangeListener;
import java.io.File;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.filechooser.AbstractChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.FileChooserPeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.util.FileFilter;

public class FileChooser
extends AbstractChooser {
    public static final int SINGLE_FILE = 0;
    public static final int MULTIPLE_FILES = 1;
    public static final int OPEN = 2;
    public static final int SAVE = 3;
    public static final int FILES_ONLY = 1;
    public static final int DIRECTORIES_ONLY = 4;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    private static final String SELECTED_FILTER_CHANGED_PROPERTY = "SelectedFilterChangedProperty";

    public void setAcceptAllFileFilterUsed(boolean acceptAll) {
        this.getChooserPeer().setAcceptAllFileFilterUsed(acceptAll);
    }

    public void setAccessory(UiComponent accessory) {
        this.getChooserPeer().setAccessory(accessory);
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.getChooserPeer().getChoosableFileFilters();
    }

    public void setDefaultDirectory(File currentDirectory) {
        this.setCurrentDirectory(currentDirectory);
    }

    public void setFileFilter(FileFilter filter) {
        FileChooserPeer peer = this.getChooserPeer();
        FileFilter oldFilter = this.getFileFilter();
        peer.setFileFilter(filter);
        peer.internalFireProperyChange(SELECTED_FILTER_CHANGED_PROPERTY, oldFilter, filter);
    }

    public FileFilter getFileFilter() {
        return this.getChooserPeer().getFileFilter();
    }

    public void setSelectedFile(File file) {
        this.getChooserPeer().setSelectedFile(file);
    }

    public File getSelectedFile() {
        return this.getChooserPeer().getSelectedFile();
    }

    public void setSelectedFiles(File[] files) {
        this.getChooserPeer().setSelectedFiles(files);
    }

    public File[] getSelectedFiles() {
        return this.getChooserPeer().getSelectedFiles();
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.getChooserPeer().addChoosableFileFilter(filter);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getChooserPeer().addPropertyChangeListener(listener);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.getChooserPeer().setFileSelectionMode(fileSelectionMode);
    }

    public int showOpenDialog(UiComponent parent) {
        return this.showOpenDialog(parent, UIMsg.OPEN);
    }

    public int showOpenDialog(UiComponent parent, Msg title) {
        return this.showOpenDialog(parent, title, 0);
    }

    public int showOpenDialog(UiComponent parent, int fileMode) {
        return this.showOpenDialog(parent, UIMsg.OPEN, fileMode);
    }

    public int showOpenDialog(UiComponent parent, Msg title, int fileMode) {
        this.beforeShowing(parent, "open");
        int result = this.getChooserPeer().showOpenDialog(parent, title, fileMode);
        this.afterShowing(parent, result, "open");
        return result;
    }

    public int showSaveDialog(UiComponent parent) {
        return this.showSaveDialog(parent, UIMsg.SAVE_AS);
    }

    public int showSaveDialog(UiComponent parent, Msg title) {
        this.beforeShowing(parent, "save");
        int result = this.getChooserPeer().showSaveDialog(parent, title);
        this.afterShowing(parent, result, "save");
        return result;
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createFileChooser();
    }

    private FileChooserPeer getChooserPeer() {
        return (FileChooserPeer)this.getPeer();
    }
}

