/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.border;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.LineBorder;

public class RoundLineBorder
extends LineBorder {
    private Color bgColor;

    public RoundLineBorder(Color fgColor) {
        super(fgColor);
    }

    public RoundLineBorder(Color fgColor, Color bgColor) {
        this(fgColor);
        this.bgColor = bgColor;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(UiComponent c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getForeground();
        if (this.bgColor != null) {
            g.setForeground(this.bgColor);
            g.drawRect(x, y, width - 1, height - 1);
            g.setForeground(oldColor);
        }
        g.setForeground(this.lineColor);
        g.drawRoundRect(x, y, width - 1, height - 1, 2, 2);
        g.setForeground(oldColor);
    }
}

