/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.util.StringTokenizer;

public class Utilities {
    static int count = 0;
    public static final int INCREMENT = 20;
    public static final int MAX_PIX = 400;

    public static List<UiComponent> getChildrenComponents(UiComponent c) {
        List<UiComponent> children = Collections.emptyList();
        if (c instanceof UiContainer) {
            children = ((UiContainer)c).getChildren();
        }
        return children;
    }

    public static void setDefaultCursor(UiComponent c) {
        Utilities.getMainWindow(c).setCursor(Cursor.get(Cursor.CursorType.DEFAULT_CURSOR));
    }

    public static boolean isHTML(String text) {
        return text != null && !text.equals("") && text.trim().toLowerCase().startsWith("<html");
    }

    public static String getHtmlLines(String text) {
        if (Utilities.isHTML(text)) {
            return text;
        }
        String result = "";
        StringTokenizer st = new StringTokenizer(text, "\n");
        result = result + "<html>";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result = result + token + (st.hasMoreTokens() ? "<br>" : "");
        }
        result = result + "</html>";
        return result;
    }

    public static Frame getMainWindow(UiComponent c) {
        if (c != null) {
            while (c.getParent() != null && !(c instanceof Frame)) {
                c = c.getParent();
            }
            return c instanceof Frame ? (Frame)c : null;
        }
        return null;
    }

    public static void setSharedOwnerFrame(Frame frame) {
        try {
            Field sharedOwnerFrameKey = SwingUtilities.class.getDeclaredField("sharedOwnerFrameKey");
            sharedOwnerFrameKey.setAccessible(true);
            Class[] signature = new Class[]{Object.class, Object.class};
            Method appContextPut = SwingUtilities.class.getDeclaredMethod("appContextPut", signature);
            appContextPut.setAccessible(true);
            Object[] arguments = new Object[]{sharedOwnerFrameKey.get(null), frame.getNative()};
            appContextPut.invoke(null, arguments);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void setWaitCursor(UiComponent c) {
        Utilities.getMainWindow(c).setCursor(Cursor.get(Cursor.CursorType.WAIT_CURSOR));
    }

    public static void addConstrainedComponent(UiContainer container, UiComponent component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + bottom + left + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        container.add(component, c);
    }

    public static Collection<UiComponent> disableChildrenComponentTree(UiComponent c) {
        List<UiComponent> children;
        HashSet<UiComponent> disabledComponents = new HashSet<UiComponent>();
        if (!(c instanceof TabbedPane)) {
            if (c instanceof TextComponent) {
                ((TextComponent)c).setEditable(false);
                disabledComponents.add(c);
            } else if (c.isEnabled()) {
                c.setEnabled(false);
                disabledComponents.add(c);
            }
        }
        if ((children = Utilities.getChildrenComponents(c)) != null) {
            for (UiComponent component : children) {
                disabledComponents.addAll(Utilities.disableChildrenComponentTree(component));
            }
        }
        return disabledComponents;
    }

    public static String strechAndCutText(String text, int lines, int len) {
        String result = "";
        StringTokenizer st = new StringTokenizer(text, "\n");
        int i = 0;
        while (st.hasMoreTokens() && i < lines) {
            String token = st.nextToken();
            result = result + token + (st.hasMoreTokens() && ++i < lines ? " " : "");
        }
        if (result.length() > len) {
            while (result.charAt(len) != ' ') {
                --len;
            }
            result = result.substring(0, len);
        }
        return result;
    }

    public static void translateChildComponentTree(UiComponent c) {
        Utilities.updateComponentTreeLocale(c, false);
    }

    public static void translateChildWindows(UiWindow parent) {
        UiWindow[] windows = parent.getOwnedWindows();
        if (windows != null) {
            for (UiWindow window : windows) {
                if (window == null) continue;
                window.translate();
            }
        }
    }

    private static void updateComponentTreeLocale(UiComponent c, boolean translate) {
        List<UiComponent> children = Utilities.getChildrenComponents(c);
        if (children != null) {
            for (UiComponent component : children) {
                component.translate();
            }
        }
        if (translate) {
            c.translate();
        }
    }
}

