/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ParentProvider;
import oracle.bpm.ui.TitlePanel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.ValidationException;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.border.CustomLineBorder;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.MutableTree;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class TreePanel
extends Panel
implements ParentProvider {
    private BaseAction addActionListener;
    private CardLayout cardLayout;
    private Panel cardPanel;
    private boolean isMutable;
    private boolean isSortable;
    private BaseAction moveDownAction;
    private BaseAction moveUpAction;
    private BaseAction removeActionListener;
    private Sheet root;
    private List<Sheet> sheetList = new ArrayList<Sheet>();
    private TitlePanel titlePanel;
    private MutableTree tree;
    private static final double TREE_PERC = 0.3;

    public TreePanel(UiContainer parent) {
        this(parent, null);
    }

    public TreePanel(UiContainer parent, Msg title) {
        this(parent, title, false, null, null);
    }

    public TreePanel(UiContainer parent, Msg title, boolean isMutable, BaseAction addFuegoAction, BaseAction removeFuegoAction) {
        this(parent, title, isMutable, addFuegoAction, removeFuegoAction, false);
    }

    public TreePanel(UiContainer parent, Msg title, boolean isMutable, BaseAction addFuegoAction, BaseAction removeFuegoAction, boolean isSortable) {
        this(parent, title, isMutable, addFuegoAction, removeFuegoAction, isSortable, null);
    }

    public TreePanel(UiContainer parent, Msg title, boolean isMutable, BaseAction addFuegoAction, BaseAction removeFuegoAction, UiComponent rootEditor) {
        this(parent, title, isMutable, addFuegoAction, removeFuegoAction, false, rootEditor);
    }

    public TreePanel(UiContainer parent, Msg title, boolean isMutable, BaseAction addFuegoAction, BaseAction removeFuegoAction, boolean isSortable, UiComponent rootEditor) {
        super(parent);
        this.isMutable = isMutable;
        this.addActionListener = addFuegoAction;
        this.removeActionListener = removeFuegoAction;
        this.setLayout(new BorderLayout());
        this.isSortable = isSortable;
        this.moveUpAction = new MoveAction(true);
        this.moveDownAction = new MoveAction(false);
        this.cardLayout = new CardLayout();
        this.cardPanel = new Panel(this);
        this.cardPanel.setLayout(this.cardLayout);
        TitlePanel rootPanel = new TitlePanel(this.cardPanel);
        rootPanel.setTitle("root");
        if (rootEditor == null) {
            rootEditor = new EmptyPanel(rootPanel);
            rootPanel.addContent(rootEditor);
        }
        this.root = new Sheet(Msg.QUOTE("root"), rootEditor, null);
        this.root.setParentProvider(this);
        this.titlePanel = this.createTitlePanel(this, title, rootEditor);
        this.add(this.titlePanel, "West");
        this.add(this.cardPanel, "Center");
        this.internalAddSheet(this.root, rootPanel);
    }

    public void build() {
        this.getTree().expandAll();
    }

    @Override
    public UiContainer createParent() {
        return new TitlePanel(this.getEditorParent());
    }

    public Panel getEditorParent() {
        return this.cardPanel;
    }

    public Sheet getRoot() {
        return this.root;
    }

    public Sheet getSelectedSheet() {
        MutableTree tree = this.getTree();
        Sheet sheet = (Sheet)tree.getSelectedTreeNode();
        if (sheet != null) {
            return sheet;
        }
        sheet = (Sheet)tree.getLastSelectedPathComponent();
        if (sheet != null) {
            return sheet;
        }
        return (Sheet)tree.getRoot();
    }

    public List<Sheet> getSheetList() {
        return this.sheetList;
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public MutableTree getTree() {
        return this.tree;
    }

    public boolean isTreeVisible() {
        return this.titlePanel.isVisible();
    }

    public void selectSheet(UiComponent compo) {
        for (Sheet sheet : this.getSheetList()) {
            if (sheet.getEditor() != compo) continue;
            sheet.select();
            break;
        }
    }

    public void setEmptyMsg(Msg msg) {
        if (this.root.getEditor() instanceof EmptyPanel) {
            EmptyPanel panel = (EmptyPanel)this.root.getEditor();
            panel.setMsg(msg);
        }
    }

    public void setTreeVisible(boolean visible) {
        this.getTitlePanel().setVisible(visible);
        this.revalidate();
    }

    protected UiComponent buildListPanel(UiContainer parent) {
        if (this.isMutable || this.isSortable) {
            Panel mainPanel = new Panel(parent);
            mainPanel.setLayout(new BorderLayout());
            ToolBar buttonPanel = new ToolBar(mainPanel);
            buttonPanel.setBorder(new CustomLineBorder(4));
            if (this.isMutable) {
                if (this.addActionListener != null) {
                    Button addButton = this.createButton(buttonPanel, UIMsg.ADD);
                    addButton.setAction(this.addActionListener);
                    addButton.setMsg(UIMsg.ADD);
                    addButton.setOptions(2);
                    buttonPanel.add(addButton);
                }
                if (this.removeActionListener != null) {
                    Button removeButton = this.createButton(buttonPanel, UIMsg.REMOVE);
                    removeButton.setAction(this.removeActionListener);
                    removeButton.setMsg(UIMsg.REMOVE);
                    removeButton.setOptions(2);
                    buttonPanel.add(removeButton);
                }
            }
            if (this.isSortable) {
                Button upButton = this.createButton(buttonPanel, this.moveUpAction);
                Button downButton = this.createButton(buttonPanel, this.moveDownAction);
                buttonPanel.add(Box.createGlue(buttonPanel));
                buttonPanel.add(upButton);
                buttonPanel.add(downButton);
            }
            this.tree = this.createTree(mainPanel);
            this.root.setTree(this.tree);
            mainPanel.add(buttonPanel, "North");
            mainPanel.add(this.tree, "Center");
            return mainPanel;
        }
        this.tree = this.createTree(parent);
        this.root.setTree(this.tree);
        this.tree.setBorder(null);
        return this.tree;
    }

    protected double getTreeWidthPerc() {
        return 0.3;
    }

    private CardLayout getCardLayout() {
        return this.cardLayout;
    }

    private Button createButton(ToolBar parent, BaseAction action) {
        Button button = new Button(parent);
        button.setAction(action);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setOptions(10);
        return button;
    }

    private Button createButton(ToolBar parent, Msg msg) {
        Button button = new Button((UiContainer)parent, msg);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setOptions(10);
        return button;
    }

    private TitlePanel createTitlePanel(UiContainer parent, Msg title, UiComponent rootEditor) {
        TitlePanel titlePanel = new TitlePanel(parent){

            @Override
            public Dimension getPreferredSize() {
                double widthPerc = TreePanel.this.getTreeWidthPerc();
                Dimension parentSize = TreePanel.this.getSize();
                Dimension superSize = super.getPreferredSize();
                if (parentSize.getWidth() != 0 && parentSize.getHeight() != 0) {
                    return Dimension.valueOf((int)Math.round((double)parentSize.getWidth() * widthPerc), superSize.getHeight());
                }
                return superSize;
            }
        };
        titlePanel.setTitle(title == null ? UIMsg.CATEGORY : title);
        UiComponent content = this.buildListPanel(titlePanel);
        titlePanel.addContent(content);
        titlePanel.makeRecyclable();
        return titlePanel;
    }

    private MutableTree createTree(UiContainer parent) {
        MutableTree sheetTree = new MutableTree(parent);
        sheetTree.setRoot(this.root);
        sheetTree.setRootVisible(false);
        sheetTree.setShowsRootHandles(true);
        sheetTree.setLabelProvider(new LabelProvider.Default(){

            @Override
            public String getText(Object element) {
                return String.valueOf(element);
            }
        });
        sheetTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Sheet sheet = (Sheet)TreePanel.this.getTree().getSelectedTreeNode();
                if (sheet == null) {
                    return;
                }
                if (sheet.fireEvents) {
                    Sheet parentNode;
                    if (!sheet.hasCustomEditor()) {
                        Msg name = sheet.getName();
                        TreePanel.this.getCardLayout().show(TreePanel.this.getEditorParent(), name.getString());
                    }
                    if ((parentNode = (Sheet)sheet.getParent()) != null) {
                        TreePanel.this.moveUpAction.setEnabled(sheet.canMoveUp());
                        TreePanel.this.moveDownAction.setEnabled(sheet.canMoveDown());
                    } else {
                        TreePanel.this.moveDownAction.setEnabled(false);
                        TreePanel.this.moveUpAction.setEnabled(false);
                    }
                }
            }
        });
        sheetTree.putClientProperty("Tree.lineStyle", "Angled");
        sheetTree.setMinimumSize(sheetTree.getPreferredSize());
        return sheetTree;
    }

    private void internalAddSheet(Sheet sheet, TitlePanel panel) {
        if (!sheet.hasCustomEditor()) {
            String sheetName = sheet.getName().getString();
            if (this.getCardLayout().contains(sheetName)) {
                return;
            }
            panel.setTitle(sheetName);
            this.cardPanel.add(panel, sheetName);
        }
        this.getSheetList().add(sheet);
        Sheet.Listener listener = sheet.getListener();
        if (listener != null) {
            listener.load();
        }
    }

    private void traverseChilds(Sheet childSheet) {
        for (int i = 0; i < childSheet.getChildCount(); ++i) {
            Sheet sheet = (Sheet)childSheet.getChildAt(i);
            if (sheet.getChildCount() > 0) {
                this.traverseChilds(sheet);
            }
            UiContainer parent = sheet.getEditor().getParent();
            assert (parent != null && parent instanceof TitlePanel) : "Invalid sheet editor parent";
            this.internalAddSheet(sheet, (TitlePanel)parent);
        }
    }

    private class MoveAction
    extends BaseAction {
        private boolean moveUp;

        public MoveAction(boolean up) {
            super(up ? UIMsg.MOVE_UP : UIMsg.MOVE_DOWN);
            this.moveUp = up;
        }

        @Override
        public void run() {
            Object nodeInfo = TreePanel.this.tree.getLastSelectedPathComponent();
            if (nodeInfo == null) {
                return;
            }
            Sheet treeSelectNode = (Sheet)nodeInfo;
            Sheet parentNode = (Sheet)treeSelectNode.getParent();
            if (parentNode != null) {
                int treeSelectIndex = parentNode.getIndex(treeSelectNode);
                treeSelectNode.removeFromParent();
                int newIndex = this.moveUp ? treeSelectIndex - 1 : treeSelectIndex + 1;
                TreePanel.this.getTree().insertNodeInto(treeSelectNode, parentNode, newIndex);
                TreePanel.this.getTree().reload();
                treeSelectNode.select();
            }
        }
    }

    private static class EmptyPanel
    extends Panel {
        private LabelMultiline textArea;

        public EmptyPanel(UiContainer parent) {
            this(parent, UIMsg.TO_MSG("This panel should not be empty. Please get the root node of this model and set the corresponding panel here."));
        }

        public EmptyPanel(UiContainer parent, Msg msg) {
            super(parent);
            this.setLayout(new BorderLayout());
            this.textArea = new LabelMultiline(this, msg);
            this.add(this.textArea, "Center");
        }

        public void setMsg(Msg msg) {
            this.textArea.setMsg(msg);
        }
    }

    public static class Sheet
    extends TreeNode {
        private UiComponent editor;
        private boolean fireEvents;
        private Listener listener;
        private Msg name;
        private ParentProvider provider;

        public Sheet(Sheet parent, Msg name, UiComponent editor) {
            this(name, editor, null);
        }

        Sheet(Msg name, UiComponent editor, Listener listener) {
            this.name = name;
            this.editor = editor;
            this.listener = listener;
            this.fireEvents = true;
        }

        public void validate() throws ValidationException {
        }

        public boolean canMoveDown() {
            Sheet parent = this.getParentSheet();
            return parent.getChildCount() > 1 && !parent.isLastChild(this);
        }

        public boolean canMoveUp() {
            Sheet parent = this.getParentSheet();
            return parent.getChildCount() > 1 && parent.isFirstChild(this);
        }

        public boolean isFirstChild(Sheet aChild) {
            return !this.getFirstChild().equals(aChild);
        }

        public boolean isLastChild(Sheet aChild) {
            return !this.getLastChild().equals(aChild);
        }

        public void addSheet(Sheet childSheet) {
            Tree tree = this.getTree();
            this.fireEvents = false;
            tree.insertNodeInto(childSheet, this, this.getChildCount());
            this.getTreePanel().internalAddSheet(childSheet, (TitlePanel)childSheet.getEditor().getParent());
            this.getTreePanel().traverseChilds(childSheet);
            childSheet.reload();
            this.getTree().reload();
            this.fireEvents = true;
        }

        public UiComponent getEditor() {
            return this.editor;
        }

        @Override
        public Image getIcon() {
            return null;
        }

        public Listener getListener() {
            return this.listener;
        }

        public Msg getName() {
            return this.name;
        }

        public boolean hasCustomEditor() {
            return false;
        }

        @Override
        public void onMouseSelection(MouseEvent e) {
            super.onMouseSelection(e);
        }

        @Override
        public void onSelection(TreeSelectionEvent event) {
            super.onSelection(event);
        }

        @Override
        public void removeFromParent() {
            if (this.isRoot()) {
                return;
            }
            TreeNode parent = this.getParent();
            Sheet prevSheet = (Sheet)parent.getChildBefore(this);
            Sheet postSheet = (Sheet)parent.getChildAfter(this);
            super.removeFromParent();
            if (prevSheet != null) {
                prevSheet.select();
            } else if (postSheet != null) {
                postSheet.select();
            } else {
                Sheet rootSheet = (Sheet)this.getTree().getRoot();
                rootSheet.select();
            }
            UiContainer uiContainer = this.getEditor().getParent();
            this.getTreePanel().getCardLayout().removeLayoutComponent(uiContainer);
            this.getTreePanel().remove(uiContainer);
            this.getTree().reload();
        }

        public void setEditor(UiComponent editor) {
            this.editor = editor;
        }

        public void setListener(Listener listener) {
            this.listener = listener;
        }

        @Override
        public String toString() {
            return this.getName().getString();
        }

        public void setParentProvider(ParentProvider provider) {
            this.provider = provider;
        }

        public ParentProvider getParentProvider() {
            return this.provider;
        }

        public final UiComponent buildError(UiContainer parent, Exception e) {
            return Label.create(parent, Msg.QUOTE(e.getMessage()));
        }

        protected Dialog getParentDialog() {
            UiWindow window = UiUtilities.getWindowAncestor(this.getTreePanel());
            if (window instanceof Dialog) {
                return (Dialog)window;
            }
            return null;
        }

        protected TreePanel getTreePanel() {
            UiContainer current;
            for (current = this.getTree().getParent(); current != null && !(current instanceof TreePanel); current = current.getParent()) {
            }
            return (TreePanel)current;
        }

        private Sheet getParentSheet() {
            return (Sheet)this.getParent();
        }

        public static interface Listener {
            public void load();

            public void save();
        }
    }
}

