/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.ui.Timer;
import oracle.bpm.ui.UiUtilities;

final class TimerQueue
implements Runnable {
    private Timer firstTimer;
    private boolean running;
    private static TimerQueue sharedInstance;
    private static final Object classLock;

    public TimerQueue() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Object object = classLock;
        synchronized (object) {
            TimerQueue sharedInst = sharedInstance;
            if (sharedInst == null) {
                sharedInstance = sharedInst = new TimerQueue();
            }
            return sharedInst;
        }
    }

    @Override
    public synchronized void run() {
        block4: while (true) {
            try {
                while (this.running) {
                    long timeToWait = this.postExpiredTimers();
                    try {
                        this.wait(timeToWait);
                        continue block4;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (ThreadDeath td) {
                this.running = false;
                for (Timer timer = this.firstTimer; timer != null; timer = timer.getNextTimer()) {
                    timer.cancelEvent();
                }
                throw td;
            }
        }
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TimerQueue (");
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            buf.append(nextTimer.toString());
            if ((nextTimer = nextTimer.getNextTimer()) == null) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    static synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized void addTimer(Timer timer, long expirationTime) {
        Timer nextTimer;
        if (timer.running) {
            return;
        }
        Timer previousTimer = null;
        for (nextTimer = this.firstTimer; nextTimer != null && nextTimer.getExpirationTime() <= expirationTime; nextTimer = nextTimer.getNextTimer()) {
            previousTimer = nextTimer;
        }
        if (previousTimer == null) {
            this.firstTimer = timer;
        } else {
            previousTimer.setNextTimer(timer);
        }
        timer.setExpirationTime(expirationTime);
        timer.setNextTimer(nextTimer);
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer previousTimer = null;
        boolean found = false;
        for (Timer nextTimer = this.firstTimer; nextTimer != null; nextTimer = nextTimer.getNextTimer()) {
            if (nextTimer == timer) {
                found = true;
                break;
            }
            previousTimer = nextTimer;
        }
        if (!found) {
            return;
        }
        if (previousTimer == null) {
            this.firstTimer = timer.getNextTimer();
        } else {
            previousTimer.setNextTimer(timer.getNextTimer());
        }
        timer.setExpirationTime(0L);
        timer.setNextTimer(null);
        timer.running = false;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    private synchronized long postExpiredTimers() {
        long timeToWait;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            timeToWait = timer.getExpirationTime() - currentTime;
            if (timeToWait > 0L) continue;
            try {
                timer.post();
            }
            catch (SecurityException e) {
                // empty catch block
            }
            this.removeTimer(timer);
            if (timer.isRepeats()) {
                this.addTimer(timer, currentTime + (long)timer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    private synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        UiUtilities.doPrivileged(new Runnable(){

            @Override
            public void run() {
                Thread timerThread = new Thread((Runnable)TimerQueue.this, "TimerQueue");
                timerThread.setDaemon(true);
                timerThread.setPriority(5);
                timerThread.start();
            }
        });
        this.running = true;
    }

    static {
        classLock = new Object();
    }
}

