/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.ui.UiUtilities;

public abstract class SwingWorker<T> {
    private Throwable exception;
    private ThreadVar threadVar;
    private T value;

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                UiUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct, "SwingWorker");
        this.threadVar = new ThreadVar(t);
    }

    public abstract T construct();

    public Throwable getException() {
        return this.exception;
    }

    public boolean isAlive() {
        return this.threadVar.isAlive();
    }

    public void setException(Throwable t) {
        this.exception = t;
    }

    public void finished() {
    }

    public T get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    public void start(T value) {
        this.setValue(value);
        this.start();
    }

    protected synchronized T getValue() {
        return this.value;
    }

    private synchronized void setValue(T x) {
        this.value = x;
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized boolean isAlive() {
            return this.thread != null;
        }

        synchronized void clear() {
            this.thread = null;
        }

        synchronized Thread get() {
            return this.thread;
        }
    }
}

