/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.SplitPanePeer;

public class SplitPane
extends UiContainer {
    private UiComponent leftComponent;
    private int orientation = 1;
    private UiComponent rightComponent;
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final int HORIZONTAL_SPLIT = 1;
    public static final int VERTICAL_SPLIT = 0;

    public SplitPane(UiContainer parent) {
        this(parent, 1);
    }

    public SplitPane(UiContainer container, int orientation) {
        this(container, orientation, null, null);
    }

    public SplitPane(UiContainer container, int orientation, UiComponent leftComponent, UiComponent rightComponent) {
        super(container);
        this.setOrientation(orientation);
        this.setLeftComponent(leftComponent);
        this.setRightComponent(rightComponent);
        this.setBorder(null);
    }

    public static void main(String[] args) {
        Ui.initialize(UiType.SWT);
        OkCancelDialog d = new OkCancelDialog(null){

            @Override
            public void ok() {
                this.close();
            }
        };
        d.setSize(500, 400);
        d.centerOnScreen();
        UiContainer contentPane = d.getContentPane();
        SplitPane splitPane = new SplitPane(contentPane);
        splitPane.setOneTouchExpandable(true);
        Panel redPanel = new Panel(splitPane);
        redPanel.setBackground(Color.RED);
        splitPane.setLeftComponent(redPanel);
        contentPane.add(splitPane, "Center");
        Object data = splitPane.getLayoutData();
        assert (data != null) : "Invalid layout data";
        System.out.println("SplitPane.main() layout data = " + data);
        splitPane.setResizeWeight(0.25);
        d.setSize(500, 400);
        d.setVisible(true);
    }

    public void setBottomComponent(UiComponent component) {
        this.setRightComponent(component);
    }

    public UiComponent getBottomComponent() {
        return this.getRightComponent();
    }

    @Override
    public List<UiComponent> getChildren() {
        ArrayList<UiComponent> components = new ArrayList<UiComponent>();
        if (this.leftComponent != null) {
            components.add(this.leftComponent);
        }
        if (this.rightComponent != null) {
            components.add(this.rightComponent);
        }
        return components;
    }

    public void setDividerLocation(int location) {
        this.getSplitPanePeer().setDividerLocation(location);
    }

    public int getDividerLocation() {
        return this.getSplitPanePeer().getDividerLocation();
    }

    public int getDividerSize() {
        return this.getSplitPanePeer().getDividerSize();
    }

    public void setDividerVisible(boolean visible) {
        this.getSplitPanePeer().setDividerVisible(visible);
    }

    public void setLeftComponent(UiComponent component) {
        this.leftComponent = component;
        this.getSplitPanePeer().setLeftComponent(component);
    }

    public UiComponent getLeftComponent() {
        return this.leftComponent;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public UiComponent getPaneAt(int index) {
        return null;
    }

    public int getPaneCount() {
        return 0;
    }

    public void setResizeWeight(double weight) {
        this.getSplitPanePeer().setResizeWeight(weight);
    }

    public void setRightComponent(UiComponent component) {
        this.rightComponent = component;
        this.getSplitPanePeer().setRightComponent(component);
    }

    public UiComponent getRightComponent() {
        return this.rightComponent;
    }

    public void setTopComponent(UiComponent component) {
        this.setLeftComponent(component);
    }

    public UiComponent getTopComponent() {
        return this.getLeftComponent();
    }

    public void setOneTouchExpandable(boolean expandable) {
        this.getSplitPanePeer().setOneTouchExpandable(expandable);
    }

    public void addPane(UiComponent component) {
    }

    public void insertPane(UiComponent component, int index) {
    }

    public void removePane(UiComponent component) {
    }

    public void resetToPreferredSizes() {
        this.getSplitPanePeer().resetToPreferredSizes();
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createSplitPane(this.getParentPeer(), this.getOrientation());
    }

    private void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    private SplitPanePeer getSplitPanePeer() {
        return (SplitPanePeer)this.getPeer();
    }
}

