/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.net.URL;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AboutDialog;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.ui.monitor.ProgressMonitorGUI;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.util.ProgressMonitor;

public class Splash
extends Frame {
    private Image image;
    private ProgressMonitorGUI progressBar;
    private Image windowIcon;

    public Splash(Image img) {
        this(img, null);
    }

    public Splash(URL splashImage, URL windowIconImage) {
        super(UIMsg.FUEGO, false);
        assert (splashImage != null) : "splashImageUrl cannot be null";
        assert (windowIconImage != null) : "logo cannot be null";
        this.image = Image.create(splashImage);
        this.windowIcon = Image.create(windowIconImage);
        this.setup();
    }

    public Splash(Msg img, Msg windowIconImage) {
        this(Image.create(img), Image.create(windowIconImage));
    }

    private Splash(Image img, Image windowIconImage) {
        super(UIMsg.FUEGO, false);
        this.image = img;
        this.windowIcon = windowIconImage;
        this.setup();
    }

    public void setDescription(final Msg message) {
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Splash.this.setDescription(message);
                }
            });
            return;
        }
        this.progressBar.info(message);
        this.toFront();
    }

    public ProgressMonitor getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.flush();
        }
        super.dispose();
    }

    public void endSplash() {
        this.setVisible(false);
        this.dispose();
    }

    public void beginSplash() {
        Dimension dimension = Ui.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation((dimension.getWidth() - size.getWidth()) / 2, (dimension.getHeight() - size.getHeight()) / 2);
        this.setVisible(true);
        UiUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Splash.this.toFront();
            }
        });
    }

    protected GridBagConstraints getWarningMessagedConstraints(int gridx, int gridy) {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = gridx;
        constr.gridy = gridy;
        constr.fill = 0;
        constr.anchor = 10;
        constr.insets = new Insets(3, 4, 1, 4);
        return constr;
    }

    private void setup() {
        this.setUndecorated(true);
        if (this.windowIcon != null) {
            this.setIconImage(this.windowIcon);
        }
        Color aliceBlue = Color.valueOf(240, 248, 255);
        Panel panel = new Panel(this);
        BorderLayout layout = new BorderLayout();
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEtchedBorder(0));
        panel.setBackground(Color.LIGHT_GRAY);
        this.progressBar = ProgressMonitorBuilder.createSimpleBuilder(panel).buildProgressMonitor(this.getContentPane());
        this.progressBar.setBackground(aliceBlue);
        panel.add(this.progressBar, "South");
        UiComponent splash = AboutDialog.buildAboutInformation(panel, this.image);
        panel.add(splash, "Center");
        this.getContentPane().add(panel);
        this.pack();
    }
}

