/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.peer.SVGImagePeer;

public class SVGImage
extends Image {
    private static Map<String, SVGImage> imagesByClass = new HashMap<String, SVGImage>();
    private static Map<String, Image> imagesByURL = new HashMap<String, Image>();

    private SVGImage(SVGImagePeer peer) {
        super(peer);
    }

    public static SVGImage create(SVGImagePeer image) {
        return new SVGImage(image);
    }

    public static Image create(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Image result = imagesByURL.get(url.toString());
        if (result == null) {
            try {
                result = new SVGImage(Ui.getUiFactory().createSVGImage(url));
                imagesByURL.put(url.toString(), result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Image create(Msg msg) {
        URL url = msg == null ? null : msg.getImageResource();
        return url != null ? SVGImage.create(url) : null;
    }

    public static SVGImage create(Class cl, String imageName) throws IOException {
        URL url;
        String key = cl.getName() + "/" + imageName;
        SVGImage result = imagesByClass.get(key);
        if (result == null && (url = cl.getResource(imageName)) != null) {
            result = new SVGImage(Ui.getUiFactory().createSVGImage(url));
            imagesByClass.put(key, result);
        }
        return result;
    }
}

