/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.DefaultFormatter;

public class RegexpFormatter
extends DefaultFormatter {
    private Matcher matcher;
    private Pattern pattern;
    static final long serialVersionUID = 4372150791224457126L;
    static final long serialCheck = 360822038866634153L;

    public RegexpFormatter() {
    }

    public RegexpFormatter(Pattern pattern) {
        this();
        this.setPattern(pattern);
    }

    public RegexpFormatter(String pattern) throws PatternSyntaxException {
        this();
        this.setPattern(Pattern.compile(pattern));
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.setPattern(Pattern.compile(pattern));
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            Matcher matcher = pattern.matcher(text);
            if (matcher.matches()) {
                this.setMatcher(matcher);
                return super.stringToValue(text);
            }
            throw new ParseException("Pattern did not match", 0);
        }
        return text;
    }

    protected void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }
}

