/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import javax.swing.MutableComboBoxModel;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.ListModelComboBoxModel;
import oracle.bpm.ui.MutableListModel;

public class MutableListModelComboBoxModel
extends ListModelComboBoxModel
implements MutableComboBoxModel {
    private MutableListModel delegate;
    static final long serialVersionUID = 2516098827933217329L;
    static final long serialCheck = -7868245761742117551L;

    public MutableListModelComboBoxModel(MutableListModel list) {
        super(list);
        assert (list != null);
        this.delegate = list;
    }

    @Override
    public void addElement(Object obj) {
        this.delegate.addElement(obj);
        this.selectIfFirst(obj);
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        this.delegate.insertElementAt(obj, index);
        this.selectIfFirst(obj);
    }

    @Override
    public void removeAllElements() {
        if (this.getSize() > 0) {
            this.delegate.removeAllElements();
        }
    }

    @Override
    public void removeElement(Object obj) {
        int index = ComboBox.indexOf(this, obj);
        if (index != -1) {
            this.adjustSelectedItemOnDeletion(index);
            this.delegate.removeElement(obj);
        }
    }

    @Override
    public void removeElementAt(int index) {
        assert (index >= 0 && index < this.getSize());
        this.adjustSelectedItemOnDeletion(index);
        this.delegate.removeElementAt(index);
    }

    protected void selectIfFirst(Object obj) {
        if (this.getSize() == 1 && obj != null && this.getSelectedItem() == null) {
            this.setSelectedItem(obj);
        }
    }

    private void adjustSelectedItemOnDeletion(int index) {
        Object currentSelection = this.getSelectedItem();
        Object elementToDelete = this.getElementAt(index);
        if (elementToDelete == currentSelection) {
            int last = this.getSize() - 1;
            if (last == 0) {
                this.setSelectedItem(null);
            } else if (index == last) {
                this.setSelectedItem(this.getElementAt(index - 1));
            } else {
                this.setSelectedItem(this.getElementAt(index + 1));
            }
        }
    }
}

