/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreePath;

public class KeyboardNavigationUtils {
    public static void addPopupMenuKeyboardNavigation(JDialog dialog) {
        KeyboardNavigationUtils.addPopupMenuKeyboardNavigation(dialog.getRootPane());
    }

    public static void addPopupMenuKeyboardNavigation(JFrame frame) {
        KeyboardNavigationUtils.addPopupMenuKeyboardNavigation(frame.getRootPane());
    }

    public static void addPopupMenuKeyboardNavigation(JRootPane jRootPane) {
        jRootPane.getInputMap(2).put(KeyStroke.getKeyStroke("shift F10").asSwing(), "popup");
        jRootPane.getActionMap().put("popup", new BaseAction(){

            @Override
            public void run() {
                KeyboardNavigationUtils.showPopupMenu();
            }
        });
    }

    public static void dispatchPopupMouseEvent(UiComponent component, Point location) {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        MouseEvent event = KeyboardNavigationUtils.createTriggerPopupMouseEvent(component, location);
        queue.postEvent(event.asSwing());
    }

    private static MouseEvent createTriggerPopupMouseEvent(UiComponent component, Point location) {
        return MouseEvent.createTriggerEvent(component, location);
    }

    private static void showPopupMenu() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window == null) {
            return;
        }
        UiComponent component = UiComponent.get(window.getFocusOwner());
        if (component == null) {
            return;
        }
        Point location = component.getLocation();
        if (component instanceof Tree) {
            Tree jTree = (Tree)component;
            TreePath treePath = jTree.getSelectionPath();
            if (treePath != null) {
                location = jTree.getPathBounds(treePath).getOrigin();
            }
        } else if (component instanceof Table) {
            Table jTable = (Table)component;
            int row = jTable.getSelectedRow();
            int col = jTable.getSelectedColumn();
            location = row == -1 || col == -1 ? null : jTable.getCellRect(row, col, false).getOrigin();
        }
        if (location != null) {
            KeyboardNavigationUtils.dispatchPopupMouseEvent(component, location);
        }
    }
}

