/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Polygon;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.SVGImage;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.peer.ImagePeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingSVGImage;
import oracle.bpm.ui.utils.IconUtility;
import oracle.bpm.ui.utils.ImageExtension;
import oracle.bpm.util.Base64;

public class Image {
    private Dimension bounds;
    private ImagePeer peer;
    private BitSet visibilitySet;
    private BitSet insidePoints;
    private static final int MIN = -1;
    private static final int MAX = 100000;
    private static boolean isRunningInServer = false;
    private static Map<String, Image> imagesByURL = new HashMap<String, Image>();
    private static Map<String, Image> imagesByBase64 = new HashMap<String, Image>();
    private static Map<String, Image> imagesByClass = new HashMap<String, Image>();
    public static final int SCALE_SMOOTH = 4;
    public static final int SCALE_FAST = 2;
    public static final int SCALE_DEFAULT = 1;

    protected Image(ImagePeer peer) {
        if (peer == null) {
            throw new IllegalArgumentException("Peer cannot be null");
        }
        this.peer = peer;
    }

    public static Image create(Object image) {
        return new Image(Ui.getUiFactory().createImage(image));
    }

    public static Image createFromBase64(String base64) throws IOException {
        Image result = imagesByBase64.get(base64);
        if (result == null) {
            byte[] bytes = Base64.decode(base64);
            result = new Image(Ui.getUiFactory().createImage(new ByteArrayInputStream(bytes)));
            if (!isRunningInServer) {
                imagesByBase64.put(base64, result);
            }
        }
        return result;
    }

    public static Image createFromStream(InputStream stream) {
        try {
            return new Image(Ui.getUiFactory().createImage(stream));
        }
        catch (IOException e) {
            throw new ProgramException("Error while creating image from stream", e);
        }
    }

    public static Image createGrey(Image image) {
        java.awt.Image awtImage = image.asAwtImage();
        java.awt.Image awtGrayImage = IconUtility.createGrayImage(awtImage);
        return Image.create(awtGrayImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image create(Class cl, String imageName) throws IOException {
        String key = cl.getName() + "/" + imageName;
        Image result = imagesByClass.get(key);
        if (result == null) {
            InputStream stream = cl.getResourceAsStream(imageName);
            try {
                if (stream != null) {
                    result = new Image(Ui.getUiFactory().createImage(stream));
                    if (!isRunningInServer) {
                        imagesByClass.put(key, result);
                    }
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return result;
    }

    public static Image create(java.awt.Image source) {
        return new Image(Ui.getUiFactory().createImage(source));
    }

    public static Image create(Icon icon) {
        Image result = null;
        if (icon != null) {
            ImagePeer peer = icon instanceof ImageIcon ? Ui.getUiFactory().createImage(((ImageIcon)icon).getImage()) : Ui.getUiFactory().createImage(icon);
            result = new Image(peer);
        }
        return result;
    }

    public static Image create(File file) throws IOException {
        return Image.create(file.toURI().toURL());
    }

    public static Image create(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Image result = imagesByURL.get(url.toString());
        if (result == null) {
            result = new Image(Ui.getUiFactory().createImage(url));
            if (url.getFile().endsWith(".svg")) {
                try {
                    result = SVGImage.create(Image.class, url.getFile());
                }
                catch (IOException iOException) {}
            } else {
                result = new Image(Ui.getUiFactory().createImage(url));
            }
            if (!isRunningInServer) {
                imagesByURL.put(url.toString(), result);
            }
        }
        return result;
    }

    public static Image create(Msg msg) {
        URL url = msg == null ? null : msg.getImageResource();
        return url != null ? Image.create(url) : null;
    }

    public static Image create(int width, int height) {
        return new Image(Ui.getUiFactory().createImage(width, height));
    }

    public static void setIsRunningInServer(boolean value) {
        isRunningInServer = value;
    }

    public Image getGrayed() {
        return this.getPeer().getGrayed();
    }

    public Image rotate90cc() {
        return this.getPeer().rotate90cc();
    }

    public int getHeight() {
        return this.getDimension().getHeight();
    }

    public int getIconHeight() {
        return this.peer != null ? this.peer.getIconHeight() : 0;
    }

    public int getIconWidth() {
        return this.peer != null ? this.peer.getIconWidth() : 0;
    }

    public ImagePeer getPeer() {
        return this.peer;
    }

    public Image getScaledInstance(double scale) {
        int newWidth = (int)((double)this.getWidth() * scale);
        int newHeigth = (int)((double)this.getHeight() * scale);
        return this.getScaledInstance(newWidth, newHeigth, 4);
    }

    public Image getScaledInstance(int width, int height, int hints) {
        return this.getPeer().getScaledInstance(width == 0 ? 1 : width, height == 0 ? 1 : height, hints);
    }

    public Image getScaledToWidthInstance(int newWidth) {
        double scale = (double)this.getWidth() / (double)newWidth;
        double newHeight = (double)this.getHeight() / scale;
        return this.getScaledInstance(newWidth, (int)newHeight, 4);
    }

    public Image getScaledToFitInstance(int smallWidth, int smallHeight) {
        double scale = (double)this.getWidth() / (double)smallWidth;
        double Hscale = (double)this.getHeight() / (double)smallHeight;
        scale = Math.max(scale, Hscale);
        double newHeight = (double)this.getHeight() / scale;
        double newWidth = (double)this.getWidth() / scale;
        return this.getScaledInstance((int)newWidth, (int)newHeight, 4);
    }

    public Icon asSwingIcon() {
        Object nativeIcon = this.getNative();
        if (nativeIcon instanceof Icon) {
            return (Icon)nativeIcon;
        }
        return null;
    }

    public ImageIcon asSwingImageIcon() {
        Object nativeIcon = this.getNative();
        if (nativeIcon instanceof ImageIcon) {
            return (ImageIcon)nativeIcon;
        }
        return null;
    }

    public Graphics getGraphics() {
        return this.getPeer().getGraphics();
    }

    public Dimension getDimension() {
        if (this.bounds == null) {
            ImagePeer p = this.getPeer();
            this.bounds = p == null ? Dimension.ZERO : Dimension.valueOf(p.getWidth(), p.getHeight());
        }
        return this.bounds;
    }

    public int getWidth() {
        return this.getDimension().getWidth();
    }

    public java.awt.Image asAwtImage() {
        return this.getPeer().asAwtImage();
    }

    public void write(File file, ImageExtension fileExtension) {
        this.getPeer().write(file, fileExtension);
    }

    public void write(OutputStream os, ImageExtension extension) {
        this.getPeer().write(os, extension);
    }

    public void flush() {
        this.getPeer().flush();
    }

    public Object getNative() {
        return this.getPeer().getNative();
    }

    public void paintIcon(UiComponent c, Graphics g, int x, int y) {
        this.asSwingIcon().paintIcon(c.asSwing(), AwtConverter.toAwt(g), x, y);
    }

    public Polygon surroundingPolygon() {
        int x;
        int y;
        int width = this.getWidth();
        int height = this.getHeight();
        int[] xMin = new int[height];
        int[] xMax = new int[height];
        for (int y2 = 0; y2 < height; ++y2) {
            xMax[y2] = -1;
            xMin[y2] = 100000;
            for (int x2 = 0; x2 < width; ++x2) {
                if (!this.isVisible(x2, y2)) continue;
                xMax[y2] = Math.max(xMax[y2], x2);
                xMin[y2] = Math.min(xMin[y2], x2);
            }
        }
        ArrayList<Point> ps = new ArrayList<Point>();
        for (y = 0; y < xMin.length; ++y) {
            x = xMin[y];
            if (x == 100000) continue;
            ps.add(new Point(x, y));
        }
        for (y = xMax.length - 1; y > 0; --y) {
            x = xMax[y];
            if (x == -1) continue;
            ps.add(new Point(x, y));
        }
        return new Polygon(ps);
    }

    public boolean isInside(Point p, Rectangle bounds) {
        if (this.getPeer() instanceof SwingSVGImage) {
            SwingSVGImage peer = (SwingSVGImage)this.getPeer();
            return peer.isInside(p, bounds);
        }
        return this.isInside(p);
    }

    public boolean isVisible(int x, int y, Rectangle bounds) {
        if (this.getPeer() instanceof SwingSVGImage) {
            SwingSVGImage peer = (SwingSVGImage)this.getPeer();
            return peer.isVisible(x, y, bounds);
        }
        return this.isVisible(x, y);
    }

    public boolean isVisible(int x, int y) {
        if (this.visibilitySet == null) {
            int[] pixels = this.getPeer().handlePixels();
            this.visibilitySet = new BitSet(pixels.length);
            for (int i = 0; i < pixels.length; ++i) {
                this.visibilitySet.set(i, Image.isVisible(pixels[i]));
            }
        }
        return x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight() && this.visibilitySet.get(y * this.getWidth() + x);
    }

    public boolean isInside(Point p) {
        int w = this.getWidth();
        int height = this.getHeight();
        if (this.insidePoints == null) {
            this.insidePoints = new BitSet();
            Polygon poly = this.surroundingPolygon();
            for (int i = 0; i < this.getWidth(); ++i) {
                for (int j = 0; j < height; ++j) {
                    if (this.isVisible(i, j) || !poly.inside(i, j)) continue;
                    this.insidePoints.set(j * this.getWidth() + i);
                }
            }
        }
        int x = p.getX();
        int y = p.getY();
        return x >= 0 && y >= 0 && x < w && y < height && (this.visibilitySet.get(y * w + x) || this.insidePoints.get(y * w + x));
    }

    static boolean isVisible(int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        if (alpha == 0) {
            return false;
        }
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return !(red >= 250 && green >= 250 && blue >= 250 || red == 192 && green == 192 && blue == 192);
    }
}

