/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JInternalFrame;
import javax.swing.JTable;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import oracle.bpm.ui.FocusTraversable;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;

public class FormLayoutFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private UiComponent focusCycleRoot;
    private FocusTraversable focusTraversable;
    private UiComponent mostRecentFocusOwner;
    static final long serialVersionUID = 1019782920788178258L;
    static final long serialCheck = 4655287586966903332L;

    public FormLayoutFocusTraversalPolicy(UiComponent focusCycleRoot, FocusTraversable focusTraversable) {
        this.focusCycleRoot = focusCycleRoot;
        this.focusTraversable = focusTraversable;
    }

    public static void log(Object o) {
        System.out.println(o);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Component component = super.getComponentAfter(focusCycleRoot, aComponent);
        return component;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        UiComponent component = this.getMostRecentFocusOwner();
        if (component == null) {
            this.focusTraversable.getDefaultComponent();
        }
        if (!this.isValid(component)) {
            component = UiComponent.get(super.getDefaultComponent(focusCycleRoot));
        }
        return component != null ? component.asSwing() : null;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        UiComponent component = this.focusTraversable.getFirstComponent();
        if (this.isValid(component)) {
            return component.asSwing();
        }
        return super.getFirstComponent(focusCycleRoot);
    }

    @Override
    public Component getInitialComponent(JInternalFrame frame) {
        UiComponent component = this.focusTraversable.getDefaultComponent();
        if (this.isValid(component)) {
            return component.asSwing();
        }
        return super.getInitialComponent(frame);
    }

    public Component getInitialComponent(UiWindow window) {
        UiComponent component = this.focusTraversable.getDefaultComponent();
        if (this.isValid(component)) {
            return component.asSwing();
        }
        return super.getInitialComponent((JInternalFrame)window.getNative());
    }

    public void setMostRecentFocusOwner(UiComponent mostRecentFocusOwner) {
        this.mostRecentFocusOwner = mostRecentFocusOwner;
    }

    @Override
    protected boolean accept(Component aComponent) {
        return !(UiComponent.get(aComponent) == this.focusCycleRoot || aComponent instanceof JTextComponent && !((JTextComponent)aComponent).isEditable() || aComponent instanceof JTable && ((JTable)aComponent).getRowCount() <= 0 || this.focusTraversable != null && !this.focusTraversable.accept(UiComponent.get(aComponent)) || !super.accept(aComponent));
    }

    private UiComponent getMostRecentFocusOwner() {
        if (!(this.mostRecentFocusOwner == null || this.mostRecentFocusOwner.isShowing() && UiComponent.get(this.mostRecentFocusOwner.asSwing().getFocusCycleRootAncestor()) == this.focusCycleRoot)) {
            this.mostRecentFocusOwner = null;
        }
        return this.mostRecentFocusOwner;
    }

    private boolean isValid(UiComponent component) {
        return component != null && component.isVisible() && component.isFocusable();
    }
}

