/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.event.SwingItemListener;
import oracle.bpm.ui.peer.swing.event.SwingMouseListener;
import oracle.bpm.ui.statusbar.StatusBar;
import oracle.bpm.ui.utils.IconUtility;

public class ButtonEffect {
    public static final String RESTORE_ON_PRESS = "oracle.bpm.ui.button.effect.restoreOnPress";
    private static final Color selectedBgColor_sd = UiManager.color("FuegoButton.selectedBackground");
    private static final Color pressedBgColor = UiManager.color("FuegoButton.pressedBackground");

    public static void setEffect(AbstractButton button) {
        if (button.isSwing()) {
            ButtonEffect.setEffect((javax.swing.AbstractButton)button.asSwing());
        }
    }

    public static void setEffect(javax.swing.AbstractButton button) {
        boolean isToggleButton;
        boolean bl = isToggleButton = button instanceof JToggleButton && !(button instanceof JCheckBox) && !(button instanceof JRadioButton);
        if (isToggleButton) {
            button.addItemListener(SwingItemListener.get(ButtonEffect.createItemListener(button)));
            if (button.isSelected()) {
                ButtonEffect.selectToggleButton(button);
            }
        }
        EffectManager manager = ButtonEffect.createEffectManager(button, isToggleButton);
        button.addMouseListener(SwingMouseListener.get(ButtonEffect.createMouseListener(manager)));
        UiComponent.get(button).addFocusListener(ButtonEffect.createFocusListener(manager));
        button.addPropertyChangeListener("oracle.bpm.action.msg", ButtonEffect.createPropertyChangeListener(manager));
        button.setRequestFocusEnabled(false);
    }

    private static boolean isInSameToolbar(javax.swing.AbstractButton currentButton, UiComponent c) {
        ToolBar curentToolbar = ButtonEffect.getParentToolbar(UiComponent.get(currentButton));
        return curentToolbar != null && curentToolbar == ButtonEffect.getParentToolbar(c);
    }

    private static ToolBar getParentToolbar(UiComponent c) {
        while (c != null) {
            if (c instanceof ToolBar) {
                return (ToolBar)c;
            }
            c = c.getParent();
        }
        return null;
    }

    private static EffectManager createEffectManager(javax.swing.AbstractButton button, boolean toggleButton) {
        return new EffectManager(button, toggleButton);
    }

    private static FocusListener createFocusListener(EffectManager manager) {
        return new EffectFocusListener(manager);
    }

    private static ItemListener createItemListener(final javax.swing.AbstractButton button) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JToggleButton tb = (JToggleButton)e.getSource().asSwing();
                if (tb.isSelected()) {
                    ButtonEffect.selectToggleButton(button);
                } else if (!tb.isSelected()) {
                    boolean clickOnIt;
                    Object o = tb.getClientProperty("oracle.bpm.clickOnIt");
                    boolean bl = clickOnIt = o != null && (Boolean)o != false;
                    if (!clickOnIt) {
                        tb.setBackground(tb.getParent().getBackground());
                        tb.setBorderPainted(false);
                    }
                }
            }
        };
    }

    private static MouseListener createMouseListener(EffectManager manager) {
        return new EffectMouseAdapter(manager);
    }

    private static PropertyChangeListener createPropertyChangeListener(EffectManager manager) {
        return new EffectButtonIconChanger(manager);
    }

    private static void selectToggleButton(javax.swing.AbstractButton button) {
        button.setBackground(AwtConverter.toAwt(pressedBgColor));
        button.setBorder(BorderFactory.createLineBorder(Color.FUEGO_BLUE).asSwing());
        button.setBorderPainted(true);
    }

    private static class EffectManager {
        Color defaultBgColor = null;
        Image icon = null;
        String previousMessage = null;
        Image shadow = null;
        StatusBar statusBar = null;
        boolean toggleButton;
        private javax.swing.AbstractButton button;
        private boolean in = false;

        public EffectManager(javax.swing.AbstractButton button, boolean toggleButton) {
            this.button = button;
            this.toggleButton = toggleButton;
        }

        public javax.swing.AbstractButton getButton() {
            return this.button;
        }

        public void setIcon(Image icon) {
            this.icon = icon;
        }

        public void setIn(boolean in) {
            this.in = in;
        }

        public boolean isIn() {
            return this.in;
        }

        public void activated() {
            if (this.icon != null) {
                this.button.setIcon(this.icon.asSwingIcon());
            }
            this.setBackground(pressedBgColor);
        }

        public void applyEffect() {
            Icon icon = this.shadow == null ? null : this.shadow.asSwingIcon();
            this.button.setIcon(icon);
            this.setBackground(selectedBgColor_sd);
        }

        public void focusEntered() {
            this.focusEntered(true);
        }

        public void focusEntered(boolean paintFocus) {
            this.in = true;
            this.icon = Image.create(this.button.getIcon());
            if (this.toggleButton) {
                this.button.putClientProperty("oracle.bpm.clickOnIt", Boolean.TRUE);
            }
            if (!(!paintFocus || this.toggleButton && this.button.isSelected())) {
                if (this.button.getParent() != null) {
                    this.defaultBgColor = AwtConverter.fromAwt(this.button.getParent().getBackground());
                }
                this.shadow = this.icon != null ? Image.create(IconUtility.createShadowedImage((ImageIcon)this.button.getIcon(), AwtConverter.toAwt(selectedBgColor_sd))) : this.icon;
                this.applyEffect();
                this.button.setBorder(BorderFactory.createLineBorder(Color.FUEGO_BLUE).asSwing());
                this.button.setBorderPainted(true);
            }
            if (this.statusBar != null) {
                String toolTip = this.button.getToolTipText();
                if (toolTip != null && !toolTip.equals("")) {
                    this.statusBar.showNotice(toolTip);
                    this.previousMessage = toolTip;
                } else {
                    this.statusBar.clearMessage();
                }
            }
        }

        public void focusExited() {
            if (this.in) {
                if (!this.toggleButton || !this.button.isSelected()) {
                    this.restoreButton();
                }
                this.in = false;
                if (this.toggleButton) {
                    this.button.putClientProperty("oracle.bpm.clickOnIt", null);
                }
            }
            if (this.statusBar != null && this.previousMessage != null && this.previousMessage.equals(this.statusBar.getCurrentMessage())) {
                this.statusBar.clearMessage();
            }
        }

        public void updateShadowIcon() {
            this.shadow = Image.create(IconUtility.createShadowedImage((ImageIcon)this.icon.asSwingIcon(), AwtConverter.toAwt(selectedBgColor_sd)));
            this.applyEffect();
        }

        protected void restoreButton() {
            this.setBackground(this.defaultBgColor);
            this.button.setIcon(this.icon == null ? null : this.icon.asSwingIcon());
            this.button.setBorderPainted(false);
        }

        private void setBackground(Color color) {
            this.button.setBackground(AwtConverter.toAwt(color));
        }
    }

    public static class EffectMouseAdapter
    extends MouseAdapter {
        EffectManager effectManager;

        public EffectMouseAdapter(EffectManager effectManager) {
            this.effectManager = effectManager;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            UiComponent c = UiComponent.get(FocusManager.getCurrentManager().getFocusOwner());
            if (ButtonEffect.isInSameToolbar(this.effectManager.getButton(), c)) {
                this.effectManager.getButton().requestFocus();
            } else {
                this.effectManager.focusEntered(this.effectManager.getButton().isEnabled());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.effectManager.getButton().hasFocus()) {
                this.effectManager.focusExited();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.effectManager.getButton().isEnabled()) {
                boolean restoreOnPress;
                Object restoreProperty = this.effectManager.getButton().getClientProperty(ButtonEffect.RESTORE_ON_PRESS);
                boolean bl = restoreOnPress = restoreProperty != null && Boolean.TRUE.equals(restoreProperty);
                if (restoreOnPress) {
                    this.mouseExited(e);
                } else {
                    this.effectManager.activated();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.effectManager.getButton().isEnabled()) {
                if (this.effectManager.isIn() && (!this.effectManager.toggleButton || this.effectManager.toggleButton && !this.effectManager.getButton().isSelected())) {
                    this.effectManager.applyEffect();
                }
            } else {
                this.effectManager.restoreButton();
                this.effectManager.setIn(false);
            }
        }
    }

    public static class EffectFocusListener
    implements FocusListener {
        private EffectManager manager;

        public EffectFocusListener(EffectManager manager) {
            this.manager = manager;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.manager.focusEntered();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.manager.focusExited();
        }
    }

    public static class EffectButtonIconChanger
    implements PropertyChangeListener {
        private EffectManager effectManager;

        public EffectButtonIconChanger(EffectManager manager) {
            this.effectManager = manager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() != null && evt.getNewValue() instanceof Msg && this.effectManager.isIn()) {
                Msg m = (Msg)evt.getNewValue();
                this.effectManager.setIcon(Image.create(m));
                this.effectManager.updateShadowIcon();
            }
        }
    }
}

