/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.print;

public class PaperModel
implements Cloneable {
    private double mHeight;
    private Rectangle mImageableArea;
    private double mWidth;
    private static final int INCH = 72;
    private static final double LETTER_WIDTH = 612.0;
    private static final double LETTER_HEIGHT = 792.0;

    public PaperModel() {
        this.mHeight = 792.0;
        this.mWidth = 612.0;
        this.mImageableArea = new Rectangle(72.0, 72.0, this.mWidth - 144.0, this.mHeight - 144.0);
    }

    public PaperModel(int width, int height) {
        this.mHeight = height;
        this.mWidth = width;
        this.mImageableArea = new Rectangle(0.0, 0.0, this.mWidth, this.mHeight);
    }

    public Object clone() {
        PaperModel newPaperModel;
        try {
            newPaperModel = (PaperModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            newPaperModel = null;
        }
        return newPaperModel;
    }

    public double getHeight() {
        return this.mHeight;
    }

    public void setSize(double width, double height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public double getWidth() {
        return this.mWidth;
    }

    public void setImageableArea(double x, double y, double width, double height) {
        this.mImageableArea = new Rectangle(x, y, width, height);
    }

    public double getImageableX() {
        return this.mImageableArea.x;
    }

    public double getImageableY() {
        return this.mImageableArea.y;
    }

    public double getImageableWidth() {
        return this.mImageableArea.width;
    }

    public double getImageableHeight() {
        return this.mImageableArea.height;
    }

    private static class Rectangle {
        private double height;
        private double width;
        private double x;
        private double y;

        public Rectangle(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }
    }
}

