/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.validator;

import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.validator.ProjectObjectValidator;
import oracle.bpm.project.compile.validator.ValidationType;
import oracle.bpm.project.model.XSLTransformationsContainer;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.DataTransformationException;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import org.jetbrains.annotations.NotNull;

public class DataTransformationValidator
extends ProjectObjectValidator<DataTransformation> {
    public DataTransformationValidator(@NotNull ProjectMessageListener listener) {
        super(listener);
    }

    @Override
    public void validate(@NotNull DataTransformation dataTransformation, @NotNull ValidationType validationType) {
        XSLTransformation selectedTransformation;
        DataAssociationSet set = dataTransformation.getParentDataAssociationSet();
        DataAssociationEnabled node = set.getParentObject();
        XSLTransformationsContainer xslTransformationsContainer = node.getProject().getResourceFilesContainer().getXSLTransformationsContainer();
        if (xslTransformationsContainer != null && (selectedTransformation = xslTransformationsContainer.findChild(XSLTransformation.class, dataTransformation.getTransformationName())) == null) {
            this.reportError(dataTransformation, DataTransformationException.createTransformationNotExists(node, dataTransformation.getTransformationName()));
        }
        DataDeclarationContainer sourcesContainer = set.getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
        for (String sourceRef : dataTransformation.getSourceRefs()) {
            if (this.isValidTransformationRef(sourcesContainer, sourceRef)) continue;
            this.reportError(dataTransformation, DataTransformationException.createInvalidSource(node, sourceRef));
        }
        DataDeclarationContainer targetContainer = set.getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
        String targetRef = dataTransformation.getTargetRef();
        if (Str.isEmpty((String)targetRef)) {
            this.reportError(dataTransformation, DataTransformationException.createNullTarget(node));
        } else if (!this.isValidTransformationRef(targetContainer, targetRef)) {
            this.reportError(dataTransformation, DataTransformationException.createInvalidTarget(node, targetRef));
        }
    }

    private boolean isValidTransformationRef(@NotNull DataDeclarationContainer container, @NotNull String ref) {
        boolean result = false;
        DataDeclaration dataDeclaration = container.findDeclaration(ref);
        if (dataDeclaration != null) {
            SchemaObject schemaObject = dataDeclaration.getType().getDelegate().asSchemaObject();
            result = this.isComplexElement(schemaObject);
        }
        return result;
    }

    private boolean isComplexElement(@NotNull SchemaObject schemaObject) {
        return !schemaObject.isBasicType() && schemaObject.isElement();
    }
}

