/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.validator;

import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.InvalidXPathExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.exceptions.DataAssociationException;
import oracle.bpm.project.compile.process.DataAssociationHelper;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.validator.ProjectObjectValidator;
import oracle.bpm.project.compile.validator.ValidationType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.InvalidExpressionException;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;

public class DataAssociationItemValidator
extends ProjectObjectValidator<DataAssignmentItem> {
    public DataAssociationItemValidator(@NotNull ProjectMessageListener listener) {
        super(listener);
    }

    @Override
    public void validate(@NotNull DataAssignmentItem dataAssignmentItem, @NotNull ValidationType validationType) {
        DataAssignment dataAssignment = dataAssignmentItem.getParentObject();
        DataAssociationSet dataAssociationSet = dataAssignment.getParentDataAssociationSet();
        DataAssociationEnabled flowNode = dataAssociationSet.getParentObject();
        Expression expression = dataAssignmentItem.getExpression();
        if (expression != null && !Str.isEmpty((String)expression.getExpressionValue())) {
            ExpressionContext expressionContext = DataAssociationHelper.createExpressionContext(dataAssignmentItem);
            try {
                ExpressionHelper.validateExpression(expression, expressionContext);
            }
            catch (InvalidExpressionException e) {
                this.reportError(dataAssignmentItem, DataAssociationException.createInvalidExpression(flowNode, e.getMessage()));
            }
            if (dataAssignmentItem.isTarget()) {
                if (dataAssignmentItem.getRefs().isEmpty()) {
                    this.reportError(dataAssignmentItem, DataAssociationException.createNullTargetRef(flowNode));
                } else {
                    Sequence<DataDeclaration> declarationsPath = ExpressionHelper.getDeclarationsPath(expression, expressionContext);
                    if (declarationsPath.isEmpty()) {
                        this.reportWarning(dataAssignmentItem, DataAssociationException.createUncheckedTargetExpression(flowNode, expression.getExpressionValue()));
                    }
                }
            }
        } else if (expression instanceof InvalidXPathExpression) {
            InvalidXPathExpression invalidExpression = (InvalidXPathExpression)expression;
            this.reportError(dataAssignmentItem, DataAssociationException.createInvalidExpression(flowNode, invalidExpression.getCause().getString()));
        } else {
            DataAssociationException exception = dataAssignmentItem.isSource() ? DataAssociationException.createEmptySourceExpression(flowNode) : DataAssociationException.createEmptyTargetExpression(flowNode);
            this.reportError(dataAssignmentItem, exception);
        }
    }
}

