/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.InvalidProjectObjectExpressionException;
import oracle.bpm.project.compile.exceptions.UpdateTaskException;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.InvalidExpressionException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.update.OutcomeUpdateDefinition;
import oracle.bpm.project.model.processes.update.PriorityUpdateDefinition;
import oracle.bpm.project.model.processes.update.ReassignUpdateDefinition;
import oracle.bpm.project.model.processes.update.TaskIdUpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetType;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UpdateType;
import oracle.bpm.project.model.processes.update.UserTaskUpdateTargetDefinition;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker
extends ProjectObjectChecker {
    private ProcessChecker.CheckContext context;
    private UpdateTask updateTask;

    public UpdateChecker(@NotNull ProcessChecker.CheckContext context, @NotNull UpdateTask updateTask) {
        super(context.getListener());
        this.context = context;
        this.updateTask = updateTask;
    }

    @Override
    public void check() {
        Process process = this.updateTask.getProcess();
        Sequence<UserTask> userTasks = process.getDescendants(UserTask.class);
        if (userTasks.isEmpty()) {
            UpdateTaskException exception = UpdateTaskException.createNonUserTaskInProcess(this.updateTask);
            this.reportErrorWarning(this.updateTask, exception);
        }
        UpdateTargetType updateTargetType = this.updateTask.getUpdateTargetType();
        UpdateTargetDefinition updateTargetDefinition = this.updateTask.getUpdateTargetDefinition();
        if (updateTargetType == UpdateTargetType.USER_TASK) {
            UserTaskUpdateTargetDefinition userTaskUpdateTargetDefinition = updateTargetDefinition.as(UserTaskUpdateTargetDefinition.class);
            UserTask targetUserTask = userTaskUpdateTargetDefinition.getTargetUserTask();
            if (targetUserTask == null) {
                UpdateTaskException exception = UpdateTaskException.createNullTargetTask(this.updateTask);
                if (this.getOptions().isDeploying() && !this.updateTask.isDraft()) {
                    this.reportError(this.updateTask, exception);
                } else {
                    this.reportWarning(this.updateTask, exception);
                }
            }
        } else if (updateTargetType == UpdateTargetType.TASK_ID) {
            TaskIdUpdateTargetDefinition taskIdUpdateTargetDefinition = updateTargetDefinition.as(TaskIdUpdateTargetDefinition.class);
            Expression taskId = taskIdUpdateTargetDefinition.getTaskId();
            this.checkAttributeExpression(taskId, TaskIdUpdateTargetDefinition.ResultType.getTaskId(), ProjectModelMsg.TASK_ID, true);
        }
        UpdateType updateType = this.updateTask.getUpdateType();
        UpdateDefinition updateDefinition = this.updateTask.getUpdateDefinition();
        switch (updateType) {
            case UPDATE_OUTCOME: {
                OutcomeUpdateDefinition outcomeUpdateDefinition = updateDefinition.as(OutcomeUpdateDefinition.class);
                this.checkAttributeExpression(outcomeUpdateDefinition.getOutcome(), OutcomeUpdateDefinition.ResultType.getOutcome(), ProjectModelMsg.OUTCOME, true);
                break;
            }
            case UPDATE_PRIORITY: {
                PriorityUpdateDefinition priorityUpdateDefinition = updateDefinition.as(PriorityUpdateDefinition.class);
                this.checkAttributeExpression(priorityUpdateDefinition.getPriority(), PriorityUpdateDefinition.ResultType.getPriority(), ProjectModelMsg.PRIORITY, true);
                break;
            }
            case REASSIGN: {
                ReassignUpdateDefinition reassignUpdateDefinition = updateDefinition.as(ReassignUpdateDefinition.class);
                this.checkAttributeExpression(reassignUpdateDefinition.getAssignedUser(), ReassignUpdateDefinition.ResultType.getAssignedUser(), ProjectModelMsg.ASSIGNED_USER, true);
            }
        }
    }

    private void checkAttributeExpression(@Nullable Expression expression, @NotNull CatalogType resultType, @NotNull Msg attribute, boolean isMandatory) {
        block8: {
            if (expression != null && !Str.isEmpty((String)expression.getExpressionValue())) {
                try {
                    ExpressionHelper.validateExpression(expression, new ExpressionContext((DataDeclarationContainer)this.updateTask, resultType));
                }
                catch (InvalidExpressionException e) {
                    InvalidProjectObjectExpressionException invalidAttribute = InvalidProjectObjectExpressionException.createInvalidAttribute(this.updateTask, attribute.getString(), e.getMessage());
                    if (this.updateTask.isDraft()) {
                        this.reportWarning(this.updateTask, invalidAttribute);
                        break block8;
                    }
                    this.reportError(this.updateTask, invalidAttribute);
                }
            } else if (isMandatory) {
                InvalidProjectObjectExpressionException emptyAttribute = InvalidProjectObjectExpressionException.createEmptyAttribute(this.updateTask, attribute.getString());
                if (this.updateTask.isDraft()) {
                    this.reportWarning(this.updateTask, emptyAttribute);
                } else {
                    this.reportErrorWarning(this.updateTask, emptyAttribute);
                }
            }
        }
    }

    private void reportErrorWarning(@NotNull ProjectObject object, @NotNull ProjectException exception) {
        if (this.getOptions().isDeploying()) {
            this.reportError(object, exception);
        } else {
            this.reportWarning(object, exception);
        }
    }

    private CheckOptions getOptions() {
        return this.context.getOptions();
    }
}

