/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.validator.ProjectObjectValidator;
import oracle.bpm.project.compile.validator.ValidationType;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectObjectValidatorChecker<T extends ProjectObject>
extends ProjectObjectChecker {
    private T projectObject;
    private ProjectObjectValidator<T> validator;

    public ProjectObjectValidatorChecker(@NotNull T projectObject, @NotNull ProjectMessageListener listener) {
        super(listener);
        this.projectObject = projectObject;
    }

    @Override
    public void check() {
        this.getValidator().validate(this.projectObject, ValidationType.CHECKER);
    }

    protected abstract ProjectObjectValidator<T> createValidator(@NotNull ProjectMessageListener var1);

    private ProjectObjectValidator<T> getValidator() {
        if (this.validator == null) {
            ProjectMessageListener listener = this.getListener();
            this.validator = this.createValidator(listener);
        }
        return this.validator;
    }
}

