/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.Collection;
import oracle.bpm.project.compile.process.ProjectCaseActivityChecker;
import oracle.bpm.project.compile.process.ProjectCaseChecker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.CaseException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class ProjectChecker {
    private ProjectMessageListener listener;
    private Project project;

    public ProjectChecker(@NotNull Project project, @NotNull ProjectMessageListener listener) {
        this.project = project;
        this.listener = listener;
    }

    public void check() {
        ProjectCase projectCase = this.project.getCase();
        if (projectCase != null && projectCase.getCase() != null) {
            this.checkCaseManagement(projectCase);
            this.checkCaseActivity(projectCase.getCaseActivities());
        }
    }

    private void checkCaseManagement(@NotNull ProjectCase projectCase) {
        Collection<Msg> errors = ProjectCaseChecker.check(projectCase);
        for (Msg error : errors) {
            this.reportError(projectCase, new CaseException(projectCase, error));
        }
    }

    private void checkCaseActivity(Collection<ProjectCaseActivity> caseActivities) {
        for (ProjectCaseActivity caseActivity : caseActivities) {
            Collection<Msg> errors = ProjectCaseActivityChecker.check(caseActivity);
            for (Msg error : errors) {
                this.reportError(caseActivity, new CaseException(caseActivity, error));
            }
        }
    }

    private void reportError(ProjectObject projectObject, ProjectException exception) {
        this.listener.reportError(projectObject, exception);
    }

    private void reportWarning(ProjectObject projectObject, ProjectException exception) {
        this.listener.reportWarning(projectObject, exception);
    }
}

