/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.LogHandlerException;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.InvalidExpressionException;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerTrigger;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import org.jetbrains.annotations.NotNull;

public class LogHandlerChecker
extends ProjectObjectChecker {
    private ProcessChecker.CheckContext context;
    private Loggable loggable;

    public LogHandlerChecker(@NotNull ProcessChecker.CheckContext context, @NotNull Loggable loggable) {
        super(context.getListener());
        this.context = context;
        this.loggable = loggable;
    }

    @Override
    public void check() {
        LogHandlerSet logHandlerSet = this.loggable.getLogHandlerSet();
        for (LogHandler logHandler : logHandlerSet.getLogHandlers()) {
            this.checkLogHandler(logHandler);
        }
    }

    private void checkLogHandler(@NotNull LogHandler logHandler) {
        LogHandlerTrigger trigger = logHandler.getTrigger();
        Sequence<LogHandlerTrigger> availableLogHandlerTriggers = this.loggable.getAvailableLogHandlerTriggers();
        if (!availableLogHandlerTriggers.contains((Object)trigger)) {
            this.reportError(this.loggable, LogHandlerException.createInvalidTrigger(this.loggable, trigger));
        } else {
            Expression expression = logHandler.getExpression();
            DataDeclarationContainer logHandlerContext = this.loggable.getLogHandlerContext(trigger);
            ExpressionContext expressionContext = new ExpressionContext(logHandlerContext, LogHandler.ResultType.get());
            try {
                ExpressionHelper.validateExpression(expression, expressionContext);
            }
            catch (InvalidExpressionException e) {
                LogHandlerException exception = LogHandlerException.createInvalidExpression(this.loggable, trigger, e.getMessage());
                this.reportError(this.loggable, exception);
            }
        }
    }

    private CheckOptions getOptions() {
        return this.context.getOptions();
    }
}

