/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.HashMap;
import java.util.HashSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.ActivityHasIncomingTransitionsException;
import oracle.bpm.project.compile.exceptions.ActivityHasNoIncomingTransitionsException;
import oracle.bpm.project.compile.exceptions.ActivityHasNoNameException;
import oracle.bpm.project.compile.exceptions.ActivityHasOutgoingTransitionsException;
import oracle.bpm.project.compile.exceptions.ActivityNameAlreadyExistsException;
import oracle.bpm.project.compile.exceptions.ActivityNameCannotStartWithNumberException;
import oracle.bpm.project.compile.exceptions.ActivityNameHasInvalidCharactersException;
import oracle.bpm.project.compile.exceptions.BoundaryAlreadyHandledException;
import oracle.bpm.project.compile.exceptions.CallActivityHasNoRelatedCallableException;
import oracle.bpm.project.compile.exceptions.CallActivityHasRelatedNonCallableException;
import oracle.bpm.project.compile.exceptions.CannotHaveOutgoingConditionalFlowException;
import oracle.bpm.project.compile.exceptions.ComponentNotFoundInCatalogException;
import oracle.bpm.project.compile.exceptions.ErrorNotDefinedException;
import oracle.bpm.project.compile.exceptions.EventHasNoSignalDefined;
import oracle.bpm.project.compile.exceptions.EventSubprocessWithMoreThanOneStartException;
import oracle.bpm.project.compile.exceptions.EventSubprocessWithNoneStartEventException;
import oracle.bpm.project.compile.exceptions.FlowNodeHasNoImplementationException;
import oracle.bpm.project.compile.exceptions.InclusiveGatewayHasMoreThanOneDefaultSequenceFlowException;
import oracle.bpm.project.compile.exceptions.InitiateTaskHasInvalidPredecessors;
import oracle.bpm.project.compile.exceptions.InteractiveActivityInVirtualRoleException;
import oracle.bpm.project.compile.exceptions.InvalidIncomingSequenceFlow;
import oracle.bpm.project.compile.exceptions.InvalidIntermediateErrorEventException;
import oracle.bpm.project.compile.exceptions.InvalidProjectObjectExpressionException;
import oracle.bpm.project.compile.exceptions.InvalidSequenceFlow;
import oracle.bpm.project.compile.exceptions.LoopInSplitException;
import oracle.bpm.project.compile.exceptions.MissingExpressionException;
import oracle.bpm.project.compile.exceptions.MissingUnconditionalTransitionException;
import oracle.bpm.project.compile.exceptions.MoreThanOneConditionalTransitionException;
import oracle.bpm.project.compile.exceptions.MoreThanOneUnconditionalTransitionException;
import oracle.bpm.project.compile.exceptions.NestedEventSubprocessException;
import oracle.bpm.project.compile.exceptions.NoBlockingNodesAllowedException;
import oracle.bpm.project.compile.exceptions.ParallelGatewayHasConditionalFlowsException;
import oracle.bpm.project.compile.exceptions.ServiceTaskBeforeInitiatorException;
import oracle.bpm.project.compile.exceptions.SplitMustHaveAJoinException;
import oracle.bpm.project.compile.exceptions.UserTaskException;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.compile.process.ConversationContainerChecker;
import oracle.bpm.project.compile.process.ConversationalChecker;
import oracle.bpm.project.compile.process.CorrelationChecker;
import oracle.bpm.project.compile.process.CorrelationKeyChecker;
import oracle.bpm.project.compile.process.DataAssociationChecker;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.process.LogHandlerChecker;
import oracle.bpm.project.compile.process.MessageHeadersChecker;
import oracle.bpm.project.compile.process.NotificationChecker;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.compile.process.ServicePropertiesChecker;
import oracle.bpm.project.compile.process.UpdateChecker;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.InvalidExpressionException;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.exception.MoreThanOneUnconditionalTransitionToTheSameActivityException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.BusinessRuleTaskFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.UserTaskFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerHandler;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FindInPath;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.FlowNodeAdapter;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.NodeFinder;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.TimerEventType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.project.model.processes.messageheaders.MessageHeadersEnabled;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AmbiguousTypeNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowNodeChecker
extends ProjectObjectChecker {
    private ProcessChecker.CheckContext context;

    public FlowNodeChecker(ProcessChecker.CheckContext context) {
        super(context.getListener());
        this.context = context;
    }

    public ProcessChecker.CheckContext getContext() {
        return this.context;
    }

    public CheckOptions getOptions() {
        return this.getContext().getOptions();
    }

    @Override
    public void check() throws ProjectException {
        BasicFlowNodeHandler basicHandler = this.getOptions().checkBasicActivityProperties() ? new BasicFlowNodeHandler() : null;
        AdvancedFlowNodeHandler advancedHandler = this.getOptions().checkAdvancedActivityProperties() ? new AdvancedFlowNodeHandler() : null;
        this.checkContainer(this.getContext().getProcess(), basicHandler, advancedHandler);
    }

    private void checkHandlingEvents(FlowElement flowNode, Sequence<? extends CatchEvent> boundaryEventsFor) {
        HashSet<ErrorObject> errors = new HashSet<ErrorObject>();
        HashSet<String> messages = new HashSet<String>();
        int interruptingTimerEvents = 0;
        for (CatchEvent boundaryEvent : boundaryEventsFor) {
            EventTriggerType triggerType = boundaryEvent.getEventTriggerType();
            EventDefinition definition = boundaryEvent.getEventDefinition();
            if (triggerType == EventTriggerType.ERROR && definition != null) {
                ErrorEventDefinition errorEventDefinition = definition.as(ErrorEventDefinition.class);
                ErrorObject errorObject = errorEventDefinition.getError();
                if (errors.contains(errorObject)) {
                    this.reportError(boundaryEvent, new BoundaryAlreadyHandledException(boundaryEvent, EventTriggerType.ERROR.getLabel()));
                } else {
                    errors.add(errorObject);
                }
            }
            if (triggerType == EventTriggerType.TIMER && boundaryEvent.isBoundaryEvent() && ((BoundaryEvent)boundaryEvent).cancelActivity() && ++interruptingTimerEvents == 2) {
                this.reportWarning(flowNode, new ProjectException(flowNode, ProjectCompileMsg.MORE_THAN_ONE_INTERRUPTING_TIMER(flowNode.getDefaultLabel())));
            }
            if (triggerType != EventTriggerType.MESSAGE) continue;
            CatalogObject catalogObject = boundaryEvent.getParticipant();
            CatalogMember member = boundaryEvent.getOperation();
            if (catalogObject == null || member == null) continue;
            String operationName = catalogObject.getText() + member.getText();
            if (messages.contains(operationName)) {
                this.reportError(flowNode, new ProjectException(flowNode, ProjectCompileMsg.MESSAGE_ALREADY_HANDLED(catalogObject.getText(), member.getText(), boundaryEvent.getDefaultLabel())));
            }
            messages.add(operationName);
        }
    }

    private void checkContainer(NodeContainer container, BasicFlowNodeHandler basicHandler, AdvancedFlowNodeHandler advancedHandler) throws ProjectException {
        Sequence nodeSequence = CollectionUtils.concat(container.getFlowNodes(), container.getBoundaryEvents());
        this.checkEventSubprocesses(container);
        for (FlowNode flowNode : nodeSequence) {
            if (basicHandler != null) {
                ModelUtils.handleFlowNode(flowNode, basicHandler);
            }
            if (advancedHandler != null) {
                ModelUtils.handleFlowNode(flowNode, advancedHandler);
            }
            if (!ModelUtils.isSubprocess(flowNode)) continue;
            Subprocess subprocess = flowNode.asAnyNode(Subprocess.class);
            this.checkContainer(subprocess, basicHandler, advancedHandler);
        }
    }

    private void checkEventSubprocesses(NodeContainer container) {
        Sequence<Subprocess> subprocessSequence = container.getActivities(Subprocess.class);
        HashSet<StartEvent> startEvents = new HashSet<StartEvent>();
        for (Subprocess subprocess : subprocessSequence) {
            if (!subprocess.isTriggeredByEvent()) continue;
            startEvents.add(ModelUtils.getStartEvent(subprocess));
        }
        this.checkHandlingEvents(container, (Sequence<? extends CatchEvent>)CollectionUtils.asSequence(startEvents));
    }

    private class UserTaskBasicChecker
    extends ActivityBasicChecker<UserTask> {
        public UserTaskBasicChecker(UserTask node) {
            super(FlowNodeChecker.this, (Activity)node);
        }

        @Override
        public void check() {
            UserTask userTask;
            super.check();
            if (((UserTask)this.getNode()).getLane() != null && ((UserTask)this.getNode()).getLane().isAutomatic()) {
                this.reportError((ProjectObject)this.getNode(), new InteractiveActivityInVirtualRoleException((FlowNode)this.getNode()));
            }
            if ((userTask = (UserTask)this.getNode()).isManualStart()) {
                Sequence<FlowNode> startNodes = ModelUtils.getStartNodes(((UserTask)this.getNode()).getProcess());
                for (FlowNode startNode : startNodes) {
                    FindInPath fip;
                    boolean found;
                    if (startNode == this.getNode() || !(found = (fip = new FindInPath(startNode, (FlowNode)this.getNode())).exists())) continue;
                    if (!ModelUtils.isNoneEvent(startNode)) {
                        this.reportError((ProjectObject)this.getNode(), new InitiateTaskHasInvalidPredecessors((FlowNode)this.getNode(), startNode.getDefaultLabel()));
                    }
                    Sequence<FlowNode> path = fip.getPath();
                    for (FlowNode flowNode : path) {
                        if (ModelUtils.isBlockingNode(flowNode)) {
                            this.reportError((ProjectObject)this.getNode(), new NoBlockingNodesAllowedException((FlowNode)this.getNode(), flowNode));
                        }
                        if (!flowNode.getBpmnType().equals((Object)BpmnType.SERVICE_TASK)) continue;
                        this.reportWarning((ProjectObject)this.getNode(), new ServiceTaskBeforeInitiatorException((FlowNode)this.getNode(), flowNode));
                    }
                }
                if (((UserTask)this.getNode()).getProcess().isCallableSubprocess()) {
                    this.reportError((ProjectObject)this.getNode(), new ModelException((ProjectObject)this.getNode(), ProjectCompileMsg.NO_INITIATOR_TASK_ALLOWED_IN_CALLABLE_SUBPROCESS));
                }
            }
        }
    }

    private class UserTaskAdvancedChecker
    extends FlowNodeAdvancedChecker<UserTask> {
        public UserTaskAdvancedChecker(UserTask node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            HumanTaskType humanTaskType;
            super.check();
            UserTaskFeature taskFeature = ((UserTask)this.node).getFeature(UserTaskFeature.class);
            if (ModelUtils.isInTemplate(this.node) && !FlowNodeChecker.this.getOptions().isDeploying()) {
                return;
            }
            HumanTask humanTask = taskFeature.getHumanTask();
            if (humanTask == null) {
                FlowNodeHasNoImplementationException hasNoImplementationException = new FlowNodeHasNoImplementationException(this.node);
                if (FlowNodeChecker.this.getOptions().isDeploying() && !((UserTask)this.getNode()).isDraft()) {
                    FlowNodeChecker.this.reportError(this.node, hasNoImplementationException);
                } else {
                    FlowNodeChecker.this.reportWarning(this.node, hasNoImplementationException);
                }
            }
            if ((humanTaskType = ((UserTask)this.getNode()).getHumanTaskType()) == HumanTaskType.INITIATOR && ((UserTask)this.getNode()).isDraft()) {
                UserTaskException invalidDraftInitiator = UserTaskException.createInvalidDraftInitiator((UserTask)this.getNode());
                if (FlowNodeChecker.this.getOptions().isDeploying()) {
                    FlowNodeChecker.this.reportError(this.node, invalidDraftInitiator);
                } else {
                    FlowNodeChecker.this.reportWarning(this.node, invalidDraftInitiator);
                }
            }
            this.checkAttributeExpression(((UserTask)this.node).getSubject(), CatalogType.Default.getString(), ProjectModelMsg.TITLE);
            this.checkAttributeExpression(((UserTask)this.node).getInitiator(), CatalogType.Default.getString(), ProjectModelMsg.INITIATOR);
            this.checkAttributeExpression(((UserTask)this.node).getOwner(), CatalogType.Default.getString(), ProjectModelMsg.OWNER);
            this.checkAttributeExpression(((UserTask)this.node).getIdentificationKey(), CatalogType.Default.getString(), ProjectModelMsg.ID_KEY);
            this.checkAttributeExpression(((UserTask)this.node).getIdentificationContext(), CatalogType.Default.getString(), ProjectModelMsg.ID_CONTEXT);
            this.checkAttributeExpression(((UserTask)this.node).getApplicationContext(), CatalogType.Default.getString(), ProjectModelMsg.APP_CONTEXT);
            if (((UserTask)this.node).isReinitiate()) {
                this.checkReinitiate((UserTask)this.node);
            }
            if (((UserTask)this.node).hasCorrelations() && ((UserTask)this.node).getHumanTaskType() != HumanTaskType.INITIATOR) {
                FlowNodeChecker.this.reportError(this.node, UserTaskException.createNonInitiatorCorrelation((UserTask)this.node));
            }
        }

        private void checkAttributeExpression(@Nullable Expression expression, @NotNull CatalogType resultType, @NotNull Msg attribute) {
            if (expression != null) {
                try {
                    ExpressionHelper.validateExpression(expression, new ExpressionContext((DataDeclarationContainer)this.node, resultType));
                }
                catch (InvalidExpressionException e) {
                    FlowNodeChecker.this.reportError(this.getNode(), InvalidProjectObjectExpressionException.createInvalidAttribute(this.getNode(), attribute.getString(), e.getMessage()));
                }
            }
        }

        private void checkReinitiate(@NotNull UserTask userTask) {
            UserTask source = userTask.getReinitiateSource();
            if (source == null) {
                FlowNodeChecker.this.reportError(userTask, UserTaskException.createInvalidReinitiateSource(userTask));
            } else {
                HumanTaskType type = userTask.getHumanTaskType();
                if (type != null && type == HumanTaskType.INITIATOR) {
                    FlowNodeChecker.this.reportError(userTask, UserTaskException.createInvalidInitiatorReinitiate(userTask));
                }
            }
        }
    }

    private class UpdateTaskAdvancedChecker
    extends ActivityBasicChecker<UpdateTask> {
        public UpdateTaskAdvancedChecker(UpdateTask node) {
            super(FlowNodeChecker.this, (Activity)node);
        }

        @Override
        public void check() {
            super.check();
            new UpdateChecker(FlowNodeChecker.this.getContext(), (UpdateTask)this.getNode()).check();
        }
    }

    private class TimerEventAdvancedChecker
    extends CatchEventAdvancedChecker {
        public TimerEventAdvancedChecker(CatchEvent event) {
            super(event);
        }

        @Override
        public void check() {
            TimerEventDefinition timerDef;
            super.check();
            EventDefinition definition = ((CatchEvent)this.getNode()).getEventDefinition();
            if (definition != null && (timerDef = definition.as(TimerEventDefinition.class)).isExpresion()) {
                CatalogType resultType;
                Expression expression = timerDef.getType() == TimerEventType.TIME_DATE ? timerDef.getTimeDateExpression() : timerDef.getTimeCycleExpression();
                CatalogType catalogType = resultType = timerDef.getType() == TimerEventType.TIME_DATE ? CatalogType.Default.getTime() : CatalogType.Default.getInterval();
                if (expression == null) {
                    FlowNodeChecker.this.reportError(this.getNode(), new MissingExpressionException(CoreMsg.TIMER, (FlowNode)this.getNode()));
                } else {
                    try {
                        ExpressionHelper.validateExpression(expression, new ExpressionContext((DataDeclarationContainer)this.getNode(), resultType));
                    }
                    catch (InvalidExpressionException e) {
                        FlowNodeChecker.this.reportError(this.getNode(), InvalidProjectObjectExpressionException.create(this.getNode(), e.getMessage()));
                    }
                }
            }
        }
    }

    private class ThrowEventBasicChecker
    extends FlowNodeBasicChecker<ThrowEvent> {
        public ThrowEventBasicChecker(ThrowEvent node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
        }
    }

    private class SubprocessBasicChecker
    extends ActivityBasicChecker<Subprocess> {
        public SubprocessBasicChecker(Subprocess node) {
            super(FlowNodeChecker.this, (Activity)node);
        }

        @Override
        public void check() {
            super.check();
            if (((Subprocess)this.node).isTriggeredByEvent()) {
                this.handleTriggeredByEvent((Subprocess)this.node);
            } else {
                this.handleLoopCharacteristics((Subprocess)this.node);
            }
            if (((Subprocess)this.node).getEvents(StartEvent.class).isEmpty() || ((Subprocess)this.node).getEvents(EndEvent.class).isEmpty()) {
                this.reportError(this.node, new ModelException((ProjectObject)this.node, ProjectCompileMsg.SUBPROCESS_HAS_NO_START_OR_END_EVENT));
            }
            new CorrelationKeyChecker((CorrelationKeyContainer)((Object)this.node), FlowNodeChecker.this.getContext()).check();
            new ConversationContainerChecker((ConversationContainer)((Object)this.node), FlowNodeChecker.this.getContext()).check();
        }

        private void handleLoopCharacteristics(Subprocess subprocess) {
            LoopCharacteristicsType characteristics = subprocess.getLoopCharacteristicsType();
            switch (characteristics) {
                case LOOP: {
                    Loop loop = subprocess.getLoopCharacteristics().as(Loop.class);
                    Expression loopExpression = loop.getLoopExpression();
                    if (loopExpression == null || Str.isEmpty((String)loopExpression.getExpressionValue())) {
                        this.missingExpression(CoreMsg.LOOP, subprocess);
                        break;
                    }
                    try {
                        DataDeclarationContainer context = loop.getLoopCharacteristicsContainer();
                        ExpressionHelper.validateExpression(loopExpression, new ExpressionContext(context, CatalogType.Default.getBool()));
                    }
                    catch (InvalidExpressionException e) {
                        this.reportError((ProjectObject)this.getNode(), InvalidProjectObjectExpressionException.create(this.getNode(), e.getMessage()));
                    }
                    break;
                }
                case MULTIINSTANCE: {
                    Expression completionConditionExpr;
                    MultiInstance multi = subprocess.getLoopCharacteristics().as(MultiInstance.class);
                    Expression loopCardinalityExpr = multi.getLoopCardinality();
                    if (loopCardinalityExpr == null || Str.isEmpty((String)loopCardinalityExpr.getExpressionValue())) {
                        if (multi.getLoopDataInput() == null) {
                            this.missingExpression(CoreMsg.MULTIINSTANCE, subprocess);
                        }
                    } else {
                        try {
                            DataDeclarationContainer context = multi.getLoopCharacteristicsContainer();
                            ExpressionHelper.validateExpression(loopCardinalityExpr, new ExpressionContext(context, CatalogType.Default.getInt()));
                        }
                        catch (InvalidExpressionException e) {
                            this.reportError((ProjectObject)this.getNode(), InvalidProjectObjectExpressionException.create(this.getNode(), e.getMessage()));
                        }
                    }
                    if ((completionConditionExpr = multi.getCompletionCondition()) == null) break;
                    try {
                        DataDeclarationContainer context = multi.getLoopCharacteristicsContainer();
                        ExpressionHelper.validateExpression(completionConditionExpr, new ExpressionContext(context, CatalogType.Default.getBool()));
                    }
                    catch (InvalidExpressionException e) {
                        this.reportError((ProjectObject)this.getNode(), InvalidProjectObjectExpressionException.create(this.getNode(), e.getMessage()));
                    }
                    break;
                }
            }
        }

        private void handleTriggeredByEvent(Subprocess subprocess) {
            int size;
            Sequence<StartEvent> startEventSequence = subprocess.getEvents(StartEvent.class);
            Subprocess nodeContainer = subprocess.getSubprocess();
            if (nodeContainer != null && ModelUtils.isEventSubprocess(nodeContainer)) {
                this.reportError(subprocess, new NestedEventSubprocessException(subprocess));
            }
            if ((size = CollectionUtils.size(startEventSequence)) == 0 || size > 1) {
                this.reportError(subprocess, new EventSubprocessWithMoreThanOneStartException(subprocess));
            } else {
                for (StartEvent event : startEventSequence) {
                    if (event.getEventTriggerType() != EventTriggerType.NONE) continue;
                    this.reportError(subprocess, new EventSubprocessWithNoneStartEventException(subprocess));
                }
            }
            if (!subprocess.getActivityBoundaryEvents().isEmpty()) {
                this.reportError(subprocess, new ProjectException(subprocess, ProjectCompileMsg.INVALID_BOUNDARY));
            }
        }
    }

    private class SignalThrowEventAdvancedChecker
    extends ThrowEventAdvancedChecker<ThrowEvent> {
        public SignalThrowEventAdvancedChecker(ThrowEvent node) {
            super(FlowNodeChecker.this, node);
        }

        @Override
        public void check() {
            super.check();
            this.checkSignalEvent((Event)this.getNode());
        }
    }

    private class SignalCatchEventAdvancedChecker
    extends CatchEventAdvancedChecker {
        public SignalCatchEventAdvancedChecker(CatchEvent node) {
            super(node);
        }

        @Override
        public void check() {
            super.check();
            this.checkSignalEvent((Event)this.getNode());
        }
    }

    private class ServiceTaskAdvancedChecker
    extends FlowNodeAdvancedChecker<ServiceTask> {
        public ServiceTaskAdvancedChecker(ServiceTask node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
            super.handleCorrelationEnabled((CorrelationsEnabled)this.getNode());
            super.handleServiceProperties((ServicePropertiesEnabled)this.getNode());
            super.handleMessageHeaders((MessageHeadersEnabled)this.getNode());
        }
    }

    private class SendTaskAdvancedChecker
    extends FlowNodeAdvancedChecker<SendTask> {
        public SendTaskAdvancedChecker(SendTask node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
            super.handleCorrelationEnabled((CorrelationsEnabled)this.getNode());
            super.handleServiceProperties((ServicePropertiesEnabled)this.getNode());
            super.handleMessageHeaders((MessageHeadersEnabled)this.getNode());
        }
    }

    private class ScriptTaskAdvancedChecker
    extends FlowNodeAdvancedChecker<ScriptTask> {
        public ScriptTaskAdvancedChecker(ScriptTask node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
        }
    }

    private class ReceiveTaskBasicChecker
    extends ActivityBasicChecker<ReceiveTask> {
        public ReceiveTaskBasicChecker(ReceiveTask node) {
            super(FlowNodeChecker.this, (Activity)node);
        }

        @Override
        public void check() {
            super.check();
            ReceiveTask receiveTask = (ReceiveTask)this.getNode();
            if (receiveTask.isInstantiate() && receiveTask.getProcess().isCallableSubprocess()) {
                this.reportError(receiveTask, new ModelException((ProjectObject)receiveTask, ProjectCompileMsg.CALLABLE_SUBPROCESS_NODE_CANNOT_CREATE_INSTANCE(receiveTask.getDefaultLabel())));
            }
        }
    }

    private class ReceiveTaskAdvancedChecker
    extends FlowNodeAdvancedChecker<ReceiveTask> {
        public ReceiveTaskAdvancedChecker(ReceiveTask node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
            if (((ReceiveTask)this.node).isInstantiate()) {
                Conversation conversation;
                Sequence<StartEvent> startNodes = ((ReceiveTask)this.node).getProcess().getFlowNodes(StartEvent.class);
                boolean foundNone = false;
                for (StartEvent startNode : startNodes) {
                    FindInPath fip;
                    if (startNode.getEventTriggerType() == EventTriggerType.MESSAGE && (fip = new FindInPath(startNode, this.node)).exists()) {
                        FlowNodeChecker.this.reportError(this.node, new ProjectException(this.node, ProjectCompileMsg.ROUTE_BETWEEN_MESSAGE_START_AND_INITIATE_RECEIVE(startNode.getDefaultLabel(), ((ReceiveTask)this.node).getDefaultLabel())));
                    }
                    if (startNode.getEventTriggerType() != EventTriggerType.NONE || ModelUtils.findSequenceFlow(startNode, this.node) == null) continue;
                    foundNone = true;
                }
                if (!foundNone) {
                    FlowNodeChecker.this.reportError(this.node, new ProjectException(this.node, ProjectCompileMsg.INITIATE_RECEIVE_MUST_BE_THE_FIRST(((ReceiveTask)this.node).getDefaultLabel())));
                }
                if ((conversation = ((ReceiveTask)this.node).getConversation()) != null && !conversation.getConversationType().isInbound()) {
                    FlowNodeChecker.this.reportError(this.node, new ProjectException(this.node, ProjectCompileMsg.INITIATE_RECEIVE_MUST_USE_INBOUND_CONVERSATION(((ReceiveTask)this.node).getDefaultLabel())));
                }
            }
            super.handleCorrelationEnabled((CorrelationsEnabled)this.getNode());
            super.handleServiceProperties((ServicePropertiesEnabled)this.getNode());
            super.handleMessageHeaders((MessageHeadersEnabled)this.getNode());
        }
    }

    private class ParallelGatewayBasicChecker
    extends GatewayBasicChecker<ParallelGateway> {
        public ParallelGatewayBasicChecker(ParallelGateway node) {
            super(FlowNodeChecker.this, (Gateway)node);
        }

        @Override
        public void check() {
            super.check();
            if (ModelUtils.isAnySplit(this.node)) {
                // empty if block
            }
            Sequence<SequenceFlow> flowSequence = ((ParallelGateway)this.node).getOutgoingSequenceFlows();
            for (SequenceFlow sequenceFlow : flowSequence) {
                if (!sequenceFlow.isConditionalFlow()) continue;
                this.reportError(this.node, new ParallelGatewayHasConditionalFlowsException((ParallelGateway)this.node));
            }
        }
    }

    private class NotificationTaskAdvancedChecker
    extends ActivityBasicChecker<NotificationTask> {
        public NotificationTaskAdvancedChecker(NotificationTask node) {
            super(FlowNodeChecker.this, (Activity)node);
        }

        @Override
        public void check() {
            super.check();
            new NotificationChecker(FlowNodeChecker.this.getContext(), (NotificationTask)this.node).check();
        }
    }

    private class MessageThrowEventAdvancedChecker
    extends ThrowEventAdvancedChecker<ThrowEvent> {
        public MessageThrowEventAdvancedChecker(ThrowEvent node) {
            super(FlowNodeChecker.this, node);
        }

        @Override
        public void check() {
            super.check();
            super.handleCorrelationEnabled((CorrelationsEnabled)this.getNode());
            super.handleServiceProperties((ServicePropertiesEnabled)this.getNode());
            super.handleMessageHeaders((MessageHeadersEnabled)this.getNode());
        }
    }

    private class MessageCatchEventAdvancedChecker
    extends CatchEventAdvancedChecker {
        public MessageCatchEventAdvancedChecker(CatchEvent node) {
            super(node);
        }

        @Override
        public void check() {
            super.check();
            super.handleCorrelationEnabled((CorrelationsEnabled)this.getNode());
            super.handleServiceProperties((ServicePropertiesEnabled)this.getNode());
            super.handleMessageHeaders((MessageHeadersEnabled)this.getNode());
        }
    }

    private class InclusiveGatewayBasicChecker
    extends GatewayBasicChecker<InclusiveGateway> {
        public InclusiveGatewayBasicChecker(InclusiveGateway node) {
            super(FlowNodeChecker.this, (Gateway)node);
        }

        @Override
        public void check() {
            super.check();
            if (ModelUtils.isAnySplit(this.getNode())) {
                // empty if block
            }
            this.checkOutgoingSequenceFlows();
        }
    }

    private static class GatewayBasicChecker<T extends Gateway>
    extends FlowNodeBasicChecker<T> {
        final /* synthetic */ FlowNodeChecker this$0;

        public GatewayBasicChecker(T node) {
            this.this$0 = var1_1;
            super((FlowNodeChecker)var1_1, node);
        }

        @Override
        public void check() {
            super.check();
        }

        protected void checkSplitProperties() {
            FindInPath path = new FindInPath(this.node, this.node, new NodeFinder(){

                @Override
                public boolean matches(FlowNode node) {
                    boolean result = false;
                    if (node.isGateway()) {
                        Gateway gateway = node.asAnyNode(Gateway.class);
                        result = gateway.getDirection() == GatewayDirection.CONVERGING;
                    }
                    return result;
                }
            });
            if (!path.exists()) {
                super.reportError(this.node, new LoopInSplitException(this.node));
            }
            NodeAssociationFeature joinFeature = ((Gateway)this.node).getFeature(NodeAssociationFeature.class);
            FlowNode join = null;
            Event activity = null;
            if (joinFeature != null && joinFeature.getValue() != null) {
                join = ((Gateway)this.node).getParentObject().findNode(joinFeature.getValue());
            }
            if (joinFeature != null) {
                activity = ((Gateway)this.node).getParentObject().findEvent(joinFeature.getValue());
            }
            if (join == null || joinFeature.getValue() == null || activity != null && activity.isEnd()) {
                super.reportError(this.node, new SplitMustHaveAJoinException(this.node));
            } else if (((Gateway)this.node).getSubprocess() != join.getSubprocess()) {
                super.reportError(this.node, new ModelException((ProjectObject)this.node, ProjectCompileMsg.MTM_02121(((Gateway)this.node).getId(), join.getId())));
            }
        }

        @Override
        protected void checkIncomingTransitions(FlowNode node) {
            super.checkIncomingTransitions(node);
        }

        protected void checkOutgoingSequenceFlows() {
            Sequence<SequenceFlow> flowSequence = ((Gateway)this.getNode()).getOutgoingSequenceFlows();
            int amountOfDefaultPaths = 0;
            for (SequenceFlow sequenceFlow : flowSequence) {
                if (sequenceFlow.isConditionalFlow()) continue;
                ++amountOfDefaultPaths;
            }
            if (amountOfDefaultPaths > 1) {
                this.reportError((ProjectObject)this.getNode(), new InclusiveGatewayHasMoreThanOneDefaultSequenceFlowException(((Gateway)this.getNode()).getBpmnType().getString(), (FlowNode)this.getNode()));
            }
            if (amountOfDefaultPaths == 0) {
                this.reportError((ProjectObject)this.getNode(), new MissingUnconditionalTransitionException((FlowNode)this.getNode()));
            }
        }
    }

    private static class FlowNodeAdvancedChecker<T extends FlowNode>
    extends FlowNodeGenericChecker<T> {
        final /* synthetic */ FlowNodeChecker this$0;

        public FlowNodeAdvancedChecker(T node) {
            this.this$0 = var1_1;
            super((FlowNodeChecker)var1_1, node);
        }

        @Override
        public void check() {
            super.check();
            this.checkCounters();
            if (this.node.isLoggable()) {
                Loggable loggable = this.node.asAnyNode(Loggable.class);
                this.checkLogHandlers(loggable);
            }
            if (this.node.isConversational()) {
                Conversational conversational = this.node.asAnyNode(Conversational.class);
                this.checkConversational(conversational);
            }
            if (this.node.isDataAssociationsEnabled()) {
                DataAssociationEnabled dataAssociationEnabled = this.node.asAnyNode(DataAssociationEnabled.class);
                this.checkDataAssociationEnabled(dataAssociationEnabled);
            }
        }

        protected void checkLogHandlers(Loggable loggable) {
            new LogHandlerChecker(this.this$0.getContext(), loggable).check();
        }

        protected void checkConversational(Conversational conversational) {
            new ConversationalChecker(this.this$0.getContext(), conversational).check();
        }

        protected void checkDataAssociationEnabled(DataAssociationEnabled dataAssociationEnabled) {
            new DataAssociationChecker(this.this$0.getContext(), dataAssociationEnabled).check();
        }

        protected void checkSignalEvent(Event e) {
            EventDefinition eventDefinition = e.getEventDefinition();
            if (eventDefinition == null) {
                EventHasNoSignalDefined signalDefined = new EventHasNoSignalDefined(e);
                if (this.this$0.getOptions().isDeploying() && !e.isDraft()) {
                    this.this$0.reportError(e, signalDefined);
                } else {
                    this.this$0.reportWarning(e, signalDefined);
                }
            } else {
                SignalEventDefinition definition = eventDefinition.as(SignalEventDefinition.class);
                SignalObject signalObject = definition.getSignal();
                if (signalObject == null) {
                    EventHasNoSignalDefined signalDefined = new EventHasNoSignalDefined(e);
                    if (this.this$0.getOptions().isDeploying() && !e.isDraft()) {
                        this.this$0.reportError(e, signalDefined);
                    } else {
                        this.this$0.reportWarning(e, signalDefined);
                    }
                }
            }
        }

        protected void handleCorrelationEnabled(CorrelationsEnabled e) {
            new CorrelationChecker(e, this.this$0.getContext()).check();
        }

        protected void handleServiceProperties(ServicePropertiesEnabled e) {
            new ServicePropertiesChecker(this.this$0.getListener(), e).check();
        }

        protected void handleMessageHeaders(MessageHeadersEnabled e) {
            new MessageHeadersChecker(this.this$0.getListener(), e).check();
        }

        private void checkCounters() {
            Counter aFor = ModelUtils.getCounterFor(this.node);
            if (aFor != null) {
                Sequence<ProjectDataObject> businessIndicators = aFor.getBusinessIndicators();
                for (ProjectDataObject businessIndicator : businessIndicators) {
                    if (businessIndicator.getBusinessVariableType() == BusinessVariableType.COUNTER) continue;
                    this.this$0.reportWarning(this.node, new ProjectException(this.node, ProjectCompileMsg.BUSINESS_INDICATOR_NOT_A_COUNTER(this.node.getDefaultLabel(), businessIndicator.getDefaultLabel())));
                }
            }
        }
    }

    private class ExclusiveGatewayBasicChecker
    extends GatewayBasicChecker<ExclusiveGateway> {
        public ExclusiveGatewayBasicChecker(ExclusiveGateway node) {
            super(FlowNodeChecker.this, (Gateway)node);
        }

        @Override
        public void check() {
            super.check();
            if (ModelUtils.isAnySplit(this.getNode())) {
                // empty if block
            }
            this.checkOutgoingSequenceFlows();
        }
    }

    private class EventBasedGatewayBasicChecker
    extends GatewayBasicChecker<EventBasedGateway> {
        public EventBasedGatewayBasicChecker(EventBasedGateway node) {
            super(FlowNodeChecker.this, (Gateway)node);
        }

        @Override
        public void check() {
            super.check();
        }

        @Override
        protected void checkOutgoingTransitions(FlowNode flowNode) {
            super.checkOutgoingTransitions(flowNode);
            Sequence<SequenceFlow> flowSequence = ((EventBasedGateway)this.node).getOutgoingSequenceFlows();
            boolean hasMessageEvents = false;
            boolean hasReceiveTasks = false;
            if (flowSequence.toArray().length < 2) {
                this.reportError(flowNode, new ModelException((ProjectObject)flowNode, ProjectCompileMsg.EBG_SHOULD_HAVE_AT_LEAST_2_OUTFLOWS));
            }
            for (SequenceFlow sequenceFlow : flowSequence) {
                FlowNode target = sequenceFlow.getTarget();
                if (target.isEvent()) {
                    Event event = target.asAnyNode(Event.class);
                    if (event.isThrowEvent()) {
                        this.reportError(event, new ModelException((ProjectObject)event, ProjectCompileMsg.THROW_EVENTS_NOT_ALLOWED_IN_EBG));
                    }
                    if (event.getEventTriggerType() == EventTriggerType.MESSAGE) {
                        hasMessageEvents = true;
                    }
                    if (event.getEventTriggerType() == EventTriggerType.MESSAGE || event.getEventTriggerType() == EventTriggerType.TIMER) continue;
                    this.reportError(flowNode, new ModelException((ProjectObject)flowNode, ProjectCompileMsg.INVALID_EVENT_TYPE_FOR_EBG));
                    continue;
                }
                if (target.getBpmnType() == BpmnType.RECEIVE_TASK) {
                    hasReceiveTasks = true;
                    ReceiveTask receiveTask = target.asAnyNode(ReceiveTask.class);
                    if (ModelUtils.getBoundaryEventsFor(receiveTask).isEmpty()) continue;
                    this.reportError(target, new ModelException((ProjectObject)receiveTask, ProjectCompileMsg.BOUNDARY_EVENT_NOT_ALLOWED_IN_EBG_PATHS));
                    continue;
                }
                this.reportError(target, new ModelException((ProjectObject)target, ProjectCompileMsg.EVENT_BASED_SHOULD_CONNECT_TO_EVENTS_OR_RECEIVE));
            }
            if (hasReceiveTasks && hasMessageEvents) {
                this.reportError(flowNode, new ModelException((ProjectObject)flowNode, ProjectCompileMsg.EVENT_BASED_SHOULD_CONNECT_TO_EVENTS));
            }
        }
    }

    private class ErrorThrowEventAdvancedChecker
    extends ThrowEventAdvancedChecker<ThrowEvent> {
        public ErrorThrowEventAdvancedChecker(ThrowEvent node) {
            super(FlowNodeChecker.this, node);
        }

        @Override
        public void check() {
            super.check();
            ErrorEventDefinition definition = ((ThrowEvent)this.getNode()).getEventDefinition().as(ErrorEventDefinition.class);
            if (Str.isEmpty((String)definition.getErrorCode())) {
                ErrorNotDefinedException exception = new ErrorNotDefinedException((ThrowEvent)this.node);
                if (FlowNodeChecker.this.getOptions().isDeploying() && !((ThrowEvent)this.node).isDraft()) {
                    FlowNodeChecker.this.reportError(this.node, exception);
                } else {
                    FlowNodeChecker.this.reportWarning(this.node, exception);
                }
            }
        }
    }

    private class ErrorCatchEventBasicChecker
    extends CatchEventBasicChecker {
        public ErrorCatchEventBasicChecker(CatchEvent node) {
            super(node);
        }

        @Override
        public void check() {
            super.check();
            if (!((CatchEvent)this.node).isBoundaryEvent() && !ModelUtils.isStartEvent(this.node)) {
                this.reportError(this.node, new InvalidIntermediateErrorEventException((Event)this.node));
            }
        }
    }

    private class ErrorCatchEventAdvancedChecker
    extends CatchEventAdvancedChecker {
        public ErrorCatchEventAdvancedChecker(CatchEvent node) {
            super(node);
        }

        @Override
        public void check() {
            super.check();
            ErrorEventDefinition definition = ((CatchEvent)this.node).getEventDefinition().as(ErrorEventDefinition.class);
            if (definition.getError() == null && !definition.isCatchAll() && !definition.isCatchAllSystemExceptions()) {
                ProjectException exception = new ProjectException(this.node, ProjectCompileMsg.ERROR_NOT_DEFINED(((CatchEvent)this.node).getDefaultLabel()));
                if (FlowNodeChecker.this.getOptions().isDeploying() && !((CatchEvent)this.node).isDraft()) {
                    FlowNodeChecker.this.reportError(this.node, exception);
                } else {
                    FlowNodeChecker.this.reportWarning(this.node, exception);
                }
            }
        }
    }

    private class ComplexGatewayBasicChecker
    extends GatewayBasicChecker<ComplexGateway> {
        public ComplexGatewayBasicChecker(ComplexGateway node) {
            super(FlowNodeChecker.this, (Gateway)node);
        }

        @Override
        public void check() {
            super.check();
            if (ModelUtils.isAnySplit(this.getNode())) {
                // empty if block
            }
            this.checkOutgoingSequenceFlows();
            Expression condition = ((ComplexGateway)this.node).getActivationCondition();
            if (condition == null || condition instanceof InvalidExpression) {
                this.missingExpression(CoreMsg.GATEWAY_COMPLEX, this.node);
            }
        }
    }

    private class CatchEventBasicChecker
    extends FlowNodeBasicChecker<CatchEvent> {
        public CatchEventBasicChecker(CatchEvent node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
            boolean eventBasedGateway = ModelUtils.isInEventBasedGateway((Event)this.node);
            if (eventBasedGateway) {
                Sequence<SequenceFlow> sequenceFlowSequence = ((CatchEvent)this.node).getIncomingSequenceFlows();
                for (SequenceFlow sequenceFlow : sequenceFlowSequence) {
                    if (ModelUtils.isEventBasedGateway(sequenceFlow.getSource())) continue;
                    this.reportError(this.node, new InvalidIncomingSequenceFlow(sequenceFlow));
                }
            }
            if (((CatchEvent)this.node).isBoundaryEvent() && !ModelUtils.isValidTriggerTypeForBoundaryEvent((CatchEvent)this.node)) {
                this.reportError(this.node, new ProjectException(this.node, ProjectCompileMsg.INVALID_TRIGGER_TYPE_FOR_BOUNDARY));
            }
            if (((CatchEvent)this.node).isStart() && ((CatchEvent)this.node).getEventTriggerType() != EventTriggerType.NONE && ((CatchEvent)this.node).getSubprocess() == null && ((CatchEvent)this.node).getProcess().isCallableSubprocess()) {
                this.reportError(this.node, new ProjectException(this.node, ProjectCompileMsg.CALLABLE_SUBPROCESS_ALLOWS_NONE_ONLY));
            }
        }
    }

    private class CatchEventAdvancedChecker
    extends FlowNodeAdvancedChecker<CatchEvent> {
        public CatchEventAdvancedChecker(CatchEvent node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
        }
    }

    private class CallActivityAdvancedChecker
    extends FlowNodeAdvancedChecker<CallActivity> {
        public CallActivityAdvancedChecker(CallActivity node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
            Process process = ((CallActivity)this.getNode()).getCalledElement();
            if (process == null && ModelUtils.shouldHaveImplementation(this.node)) {
                CallActivityHasNoRelatedCallableException relatedCallableException = new CallActivityHasNoRelatedCallableException((CallActivity)this.node);
                if (FlowNodeChecker.this.getOptions().isDeploying() && !((CallActivity)this.node).isDraft()) {
                    FlowNodeChecker.this.reportError(this.node, relatedCallableException);
                } else {
                    FlowNodeChecker.this.reportWarning(this.node, relatedCallableException);
                }
            } else if (process != null && !process.isCallableSubprocess()) {
                CallActivityHasRelatedNonCallableException relatedCallableException = new CallActivityHasRelatedNonCallableException((CallActivity)this.node);
                if (FlowNodeChecker.this.getOptions().isDeploying()) {
                    FlowNodeChecker.this.reportError(this.node, relatedCallableException);
                } else {
                    FlowNodeChecker.this.reportWarning(this.node, relatedCallableException);
                }
            }
        }
    }

    private class BusinessRuleTaskBasicChecker
    extends ActivityBasicChecker<BusinessRuleTask> {
        public BusinessRuleTaskBasicChecker(BusinessRuleTask node) {
            super(FlowNodeChecker.this, (Activity)node);
        }

        @Override
        public void check() {
            super.check();
        }
    }

    private class BusinessRuleAdvancedChecker
    extends FlowNodeAdvancedChecker<BusinessRuleTask> {
        public BusinessRuleAdvancedChecker(BusinessRuleTask node) {
            super(FlowNodeChecker.this, (FlowNode)node);
        }

        @Override
        public void check() {
            super.check();
            if (ModelUtils.isInTemplate(this.node) && !FlowNodeChecker.this.getOptions().isDeploying()) {
                return;
            }
            BusinessRuleTaskFeature taskFeature = ((BusinessRuleTask)this.node).getFeature(BusinessRuleTaskFeature.class);
            BusinessRule businessRule = taskFeature.getBusinessRule();
            if (businessRule == null) {
                FlowNodeHasNoImplementationException hasNoImplementationException = new FlowNodeHasNoImplementationException(this.node);
                if (FlowNodeChecker.this.getOptions().isDeploying() && !((BusinessRuleTask)this.getNode()).isDraft()) {
                    FlowNodeChecker.this.reportError(this.node, hasNoImplementationException);
                } else {
                    FlowNodeChecker.this.reportWarning(this.node, hasNoImplementationException);
                }
            } else {
                try {
                    CatalogObject catalogObject = ((BusinessRuleTask)this.node).getProject().findCatalogObject(businessRule.getText());
                    if (catalogObject == null) {
                        FlowNodeChecker.this.reportError(this.node, new ComponentNotFoundInCatalogException((ProjectObject)this.node, businessRule.getText()));
                    }
                }
                catch (AmbiguousTypeNameException e) {
                    FlowNodeChecker.this.reportError(this.node, ProjectException.wrap((ProjectObject)this.node, e));
                }
            }
        }
    }

    private class BasicFlowNodeHandler
    extends FlowNodeAdapter {
        private BasicFlowNodeHandler() {
        }

        @Override
        public void handleInclusiveGateway(InclusiveGateway node) {
            new InclusiveGatewayBasicChecker(node).check();
        }

        @Override
        public void handleBusinessRuleTask(BusinessRuleTask node) {
            new BusinessRuleTaskBasicChecker(node).check();
        }

        @Override
        public void handleEndEvent(EndEvent node) {
            ModelUtils.handleEventTrigger(node, new ThrowEventTriggerBasicHandler());
        }

        @Override
        public void handleParallelGateway(ParallelGateway node) {
            new ParallelGatewayBasicChecker(node).check();
        }

        @Override
        public void handleUserTask(UserTask node) {
            new UserTaskBasicChecker(node).check();
        }

        @Override
        public void handleComplexGateway(ComplexGateway node) {
            new ComplexGatewayBasicChecker(node).check();
        }

        @Override
        public void handleExclusiveGateway(ExclusiveGateway node) {
            new ExclusiveGatewayBasicChecker(node).check();
        }

        @Override
        public void handleCatchIntermediateEvent(CatchEvent event) {
            ModelUtils.handleEventTrigger(event, new CatchEventTriggerBasicHandler());
        }

        @Override
        public void handleIntermediateThrowEvent(ThrowEvent event) {
            ModelUtils.handleEventTrigger(event, new ThrowEventTriggerBasicHandler());
        }

        @Override
        public void handleStartEvent(StartEvent event) {
            ModelUtils.handleEventTrigger(event, new CatchEventTriggerBasicHandler());
        }

        @Override
        public void handleAbstractActivity(Activity node) {
            new ActivityBasicChecker(FlowNodeChecker.this, node).check();
        }

        @Override
        public void handleBoundaryEvent(BoundaryEvent node) {
            ModelUtils.handleEventTrigger(node, new CatchEventTriggerBasicHandler());
        }

        @Override
        public void handleCallActivity(CallActivity node) {
            new ActivityBasicChecker(FlowNodeChecker.this, (Activity)node).check();
        }

        @Override
        public void handleEventBasedGateway(EventBasedGateway node) {
            new EventBasedGatewayBasicChecker(node).check();
        }

        @Override
        public void handleReceiveTask(ReceiveTask node) {
            new ReceiveTaskBasicChecker(node).check();
        }

        @Override
        public void handleScriptTask(ScriptTask node) {
            new ActivityBasicChecker(FlowNodeChecker.this, (Activity)node).check();
        }

        @Override
        public void handleSendTask(SendTask node) {
            new ActivityBasicChecker(FlowNodeChecker.this, (Activity)node).check();
        }

        @Override
        public void handleServiceTask(ServiceTask node) {
            new ActivityBasicChecker(FlowNodeChecker.this, (Activity)node).check();
        }

        @Override
        public void handleManualTask(ManualTask task) {
            new ActivityBasicChecker(FlowNodeChecker.this, (Activity)task).check();
        }

        @Override
        public void handleSubprocess(Subprocess subprocess) {
            new SubprocessBasicChecker(subprocess).check();
        }
    }

    private class AdvancedFlowNodeHandler
    extends FlowNodeAdapter {
        private AdvancedFlowNodeHandler() {
        }

        @Override
        public void handleBusinessRuleTask(BusinessRuleTask node) {
            new BusinessRuleAdvancedChecker(node).check();
        }

        @Override
        public void handleAbstractActivity(Activity node) {
            new AbstractActivityAdvancedChecker(node).check();
        }

        @Override
        public void handleCallActivity(CallActivity node) {
            new CallActivityAdvancedChecker(node).check();
        }

        @Override
        public void handleReceiveTask(ReceiveTask node) {
            new ReceiveTaskAdvancedChecker(node).check();
        }

        @Override
        public void handleScriptTask(ScriptTask node) {
            new ScriptTaskAdvancedChecker(node).check();
        }

        @Override
        public void handleSendTask(SendTask node) {
            new SendTaskAdvancedChecker(node).check();
        }

        @Override
        public void handleServiceTask(ServiceTask node) {
            new ServiceTaskAdvancedChecker(node).check();
        }

        @Override
        public void handleUserTask(UserTask node) {
            new UserTaskAdvancedChecker(node).check();
        }

        @Override
        public void handleCatchIntermediateEvent(CatchEvent event) {
            ModelUtils.handleEventTrigger(event, new CatchEventTriggerAdvancedHandler());
        }

        @Override
        public void handleStartEvent(StartEvent event) {
            ModelUtils.handleEventTrigger(event, new CatchEventTriggerAdvancedHandler());
        }

        @Override
        public void handleIntermediateThrowEvent(ThrowEvent event) {
            ModelUtils.handleEventTrigger(event, new ThrowEventTriggerAdvancedHandler());
        }

        @Override
        public void handleBoundaryEvent(BoundaryEvent node) {
            ModelUtils.handleEventTrigger(node, new CatchEventTriggerAdvancedHandler());
        }

        @Override
        public void handleEndEvent(EndEvent node) {
            ModelUtils.handleEventTrigger(node, new ThrowEventTriggerAdvancedHandler());
        }

        @Override
        public void handleNotificationTask(NotificationTask node) {
            new NotificationTaskAdvancedChecker(node).check();
        }

        @Override
        public void handleUpdateTask(UpdateTask task) {
            new UpdateTaskAdvancedChecker(task).check();
        }
    }

    private static class ActivityBasicChecker<T extends Activity>
    extends FlowNodeBasicChecker<T> {
        final /* synthetic */ FlowNodeChecker this$0;

        public ActivityBasicChecker(T node) {
            this.this$0 = var1_1;
            super((FlowNodeChecker)var1_1, node);
        }

        @Override
        public void check() {
            super.check();
            this.checkBoundaryEvents((Activity)this.node);
        }

        protected void checkBoundaryEvents(Activity activity) {
            Sequence<BoundaryEvent> boundaryEventsFor = activity.getActivityBoundaryEvents();
            this.this$0.checkHandlingEvents(activity, (Sequence<? extends CatchEvent>)boundaryEventsFor);
        }
    }

    private class AbstractActivityAdvancedChecker
    extends FlowNodeAdvancedChecker<Activity> {
        public AbstractActivityAdvancedChecker(Activity activity) {
            super(FlowNodeChecker.this, (FlowNode)activity);
        }

        @Override
        public void check() {
            super.check();
            if (FlowNodeChecker.this.getOptions().isDeploying() && !((Activity)this.getNode()).isDraft()) {
                FlowNodeChecker.this.reportError(this.node, new FlowNodeHasNoImplementationException(this.node));
            }
        }
    }

    private static abstract class ThrowEventAdvancedChecker<T extends ThrowEvent>
    extends FlowNodeAdvancedChecker<T> {
        final /* synthetic */ FlowNodeChecker this$0;

        public ThrowEventAdvancedChecker(T node) {
            this.this$0 = var1_1;
            super((FlowNodeChecker)var1_1, node);
        }

        @Override
        public void check() {
            super.check();
        }
    }

    private static abstract class FlowNodeGenericChecker<T extends FlowNode> {
        protected T node;
        final /* synthetic */ FlowNodeChecker this$0;

        public FlowNodeGenericChecker(T node) {
            this.this$0 = var1_1;
            this.node = node;
        }

        public void check() {
        }

        protected T getNode() {
            return this.node;
        }
    }

    private static abstract class FlowNodeBasicChecker<T extends FlowNode>
    extends FlowNodeGenericChecker<T> {
        final /* synthetic */ FlowNodeChecker this$0;

        public FlowNodeBasicChecker(T node) {
            this.this$0 = var1_1;
            super((FlowNodeChecker)var1_1, node);
        }

        @Override
        public void check() {
            super.check();
            this.checkDefaultProperties(this.node);
            if (this.this$0.getOptions().checkActivityLocations()) {
                this.checkLocation(this.node);
            }
            if (this.this$0.getOptions().checkFlow()) {
                this.checkIncomingTransitions(this.node);
                this.checkOutgoingTransitions(this.node);
            }
        }

        protected void checkDefaultProperties(FlowNode flowNode) {
            this.checkName(flowNode, flowNode.getId());
            if (Str.isEmpty((String)flowNode.getId())) {
                this.reportError(flowNode, new ActivityHasNoNameException(flowNode));
            }
            Features features = flowNode.getFeatures();
            for (Feature feature : features) {
                feature.check(this.this$0.getListener());
            }
        }

        protected void checkOutgoingTransitions(FlowNode flowNode) {
            Sequence<SequenceFlow> outgoings = flowNode.getOutgoingSequenceFlows();
            if (!outgoings.isEmpty() && !ModelUtils.shouldHaveOutgoingSequenceFlow(flowNode)) {
                this.reportError(flowNode, new ActivityHasOutgoingTransitionsException(flowNode));
            }
            this.checkUnconditionalTransitions(flowNode);
            this.checkConditionalTransitions(flowNode);
        }

        protected boolean isInBoundaryFlow() {
            boolean result = false;
            HashMap<FlowNode, Sequence<BoundaryEvent>> sourceBoundaryByFlowNode = this.this$0.getContext().getSourceBoundaryByFlowNode();
            if (sourceBoundaryByFlowNode != null) {
                Sequence<BoundaryEvent> eventSequence = sourceBoundaryByFlowNode.get(this.node);
                result = eventSequence != null && !eventSequence.isEmpty();
            }
            return result;
        }

        protected void checkIncomingTransitions(FlowNode node) {
            Sequence<SequenceFlow> incomings = node.getIncomingSequenceFlows();
            if (!incomings.isEmpty()) {
                if (!ModelUtils.shouldHaveIncomingSequenceFlow(node)) {
                    this.reportError(node, new ActivityHasIncomingTransitionsException(node));
                }
                this.checkBoundaryFlowsConnections(node, incomings);
            }
            if (incomings.isEmpty() && ModelUtils.shouldHaveIncomingSequenceFlow(node)) {
                this.reportError(node, new ActivityHasNoIncomingTransitionsException(node));
            }
        }

        protected void reportWarning(ProjectObject projectObject, ProjectException e) {
            this.this$0.getListener().reportWarning(projectObject, e);
        }

        protected void reportError(ProjectObject object, ProjectException exception) {
            ProjectMessageListener messageListener = this.this$0.getListener();
            messageListener.reportError(object, exception);
        }

        protected void missingExpression(Msg msg, FlowNode node) {
            MissingExpressionException exception = new MissingExpressionException(msg, node);
            if (this.this$0.getOptions().isDeploying()) {
                this.reportError(node, exception);
            } else {
                this.reportWarning(node, exception);
            }
        }

        private void checkBoundaryFlowsConnections(FlowNode node, Sequence<SequenceFlow> incomings) {
            for (SequenceFlow incoming : incomings) {
                FlowNode sourceNode = incoming.getSource();
                Sequence<BoundaryEvent> sourceBoundaryEventSequence = this.this$0.getContext().getSourceBoundaryByFlowNode().get(sourceNode);
                boolean isInMainFlow = (sourceBoundaryEventSequence == null || sourceBoundaryEventSequence.isEmpty()) && !ModelUtils.isBoundaryEvent(sourceNode);
                Sequence<BoundaryEvent> eventSequence = this.this$0.getContext().getSourceBoundaryByFlowNode().get(node);
                boolean isInterrupt = true;
                if (eventSequence != null) {
                    for (BoundaryEvent event : eventSequence) {
                        if (event.cancelActivity() || event.getEventTriggerType() == EventTriggerType.ERROR) continue;
                        isInterrupt = false;
                        break;
                    }
                }
                if (this.isInBoundaryFlow() && isInMainFlow && !isInterrupt) {
                    this.reportError(incoming, new InvalidSequenceFlow(incoming, ProjectCompileMsg.MAIN_TO_BOUNDARY_SEQUENCE_FLOW(sourceNode.getDefaultLabel(), node.getDefaultLabel())));
                }
                if (this.isInBoundaryFlow() || isInMainFlow || isInterrupt) continue;
                this.reportError(incoming, new InvalidSequenceFlow(incoming, ProjectCompileMsg.BOUNDARY_TO_MAIN_SEQUENCE_FLOW(sourceNode.getDefaultLabel(), node.getDefaultLabel())));
            }
        }

        private void checkName(FlowNode node, String name) {
            try {
                ActivityHasNoNameException.validateName(name, node);
            }
            catch (ActivityHasNoNameException e) {
                this.reportError(node, e);
            }
            Sequence<FlowNode> nodes = node.getProcess().getFlowNodes();
            for (FlowNode other : nodes) {
                if (!other.getId().toLowerCase().equals(name.toLowerCase()) || other == node) continue;
                this.reportError(node, new ActivityNameAlreadyExistsException(node, name));
            }
            for (int i = 0; i < name.length(); ++i) {
                if (Character.isDigit(name.charAt(i)) && i == 0) {
                    this.reportError(node, new ActivityNameCannotStartWithNumberException(node, name));
                    break;
                }
                if (Character.isDigit(name.charAt(i)) || Character.isLetter(name.charAt(i)) || name.charAt(i) == '_' || name.charAt(i) == '$') continue;
                this.reportError(node, new ActivityNameHasInvalidCharactersException(node, name));
                break;
            }
        }

        private void checkConditionalTransitions(FlowNode node) {
            Sequence<ConditionalFlow> conditionals = node.getOutgoingConditionalFlows();
            block0: for (ConditionalFlow trans : conditionals) {
                if (!ModelUtils.canHaveOutgoingConditionalFlow(node)) {
                    this.reportError(node, new CannotHaveOutgoingConditionalFlowException(node, trans));
                    break;
                }
                for (ConditionalFlow transition : conditionals) {
                    if (transition == trans || !transition.getTarget().getId().equals(trans.getTarget().getId())) continue;
                    this.reportError(node, new MoreThanOneConditionalTransitionException(node));
                    continue block0;
                }
            }
        }

        private void checkUnconditionalTransitions(FlowNode flowNode) {
            Sequence<SequenceFlow> outgoings = flowNode.getOutgoingSequenceFlows();
            HashSet<FlowNode> set = new HashSet<FlowNode>();
            int amountOfUncond = 0;
            for (SequenceFlow t : outgoings) {
                if (set.contains(t.getTarget())) {
                    this.reportError(flowNode, new MoreThanOneUnconditionalTransitionToTheSameActivityException(flowNode, t.getTarget()));
                }
                if (t.isNormalFlow()) {
                    ++amountOfUncond;
                }
                set.add(t.getTarget());
            }
            if (set.isEmpty() && ModelUtils.shouldHaveOutgoingSequenceFlow(flowNode)) {
                this.reportError(flowNode, new MissingUnconditionalTransitionException(flowNode));
            }
            if (amountOfUncond > 1 && !ModelUtils.canHaveMoreThanOneOutgoingFlow(flowNode)) {
                this.reportError(flowNode, new MoreThanOneUnconditionalTransitionException(flowNode));
            }
        }

        private void checkLocation(FlowNode node) {
            if (node.getLane() == null) {
                this.reportError(node, new ModelException((ProjectObject)node, ProjectModelMsg.ASSIGN_FIRST_ROLE(node.getId())));
                Lane lane = (Lane)node.getProcess().getLanes().iterator().next();
                node.setLane(lane);
            }
        }
    }

    class ThrowEventTriggerBasicHandler
    implements EventTriggerHandler<ThrowEvent> {
        ThrowEventTriggerBasicHandler() {
        }

        @Override
        public void handleCancelEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleCompensateEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleConditionalEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleMessageEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleErrorEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleLinkEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleEscalationEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleMultipleEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleNoneEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleSignalEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleTimerEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }

        @Override
        public void handleTerminateEvent(ThrowEvent e) {
            new ThrowEventBasicChecker(e).check();
        }
    }

    class ThrowEventTriggerAdvancedHandler
    implements EventTriggerHandler<ThrowEvent> {
        ThrowEventTriggerAdvancedHandler() {
        }

        @Override
        public void handleCancelEvent(ThrowEvent e) {
        }

        @Override
        public void handleCompensateEvent(ThrowEvent e) {
        }

        @Override
        public void handleConditionalEvent(ThrowEvent e) {
        }

        @Override
        public void handleMessageEvent(ThrowEvent e) {
            new MessageThrowEventAdvancedChecker(e).check();
        }

        @Override
        public void handleErrorEvent(ThrowEvent e) {
            new ErrorThrowEventAdvancedChecker(e).check();
        }

        @Override
        public void handleLinkEvent(ThrowEvent e) {
        }

        @Override
        public void handleEscalationEvent(ThrowEvent e) {
        }

        @Override
        public void handleMultipleEvent(ThrowEvent e) {
        }

        @Override
        public void handleNoneEvent(ThrowEvent e) {
        }

        @Override
        public void handleSignalEvent(ThrowEvent e) {
            new SignalThrowEventAdvancedChecker(e).check();
        }

        @Override
        public void handleTimerEvent(ThrowEvent e) {
        }

        @Override
        public void handleTerminateEvent(ThrowEvent e) {
        }
    }

    class CatchEventTriggerBasicHandler
    implements EventTriggerHandler<CatchEvent> {
        CatchEventTriggerBasicHandler() {
        }

        @Override
        public void handleCancelEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleCompensateEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleConditionalEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleMessageEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleErrorEvent(CatchEvent e) {
            new ErrorCatchEventBasicChecker(e).check();
        }

        @Override
        public void handleLinkEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleEscalationEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleMultipleEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleNoneEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleSignalEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleTimerEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }

        @Override
        public void handleTerminateEvent(CatchEvent e) {
            new CatchEventBasicChecker(e).check();
        }
    }

    class CatchEventTriggerAdvancedHandler
    implements EventTriggerHandler<CatchEvent> {
        CatchEventTriggerAdvancedHandler() {
        }

        @Override
        public void handleCancelEvent(CatchEvent e) {
        }

        @Override
        public void handleCompensateEvent(CatchEvent e) {
        }

        @Override
        public void handleConditionalEvent(CatchEvent e) {
        }

        @Override
        public void handleMessageEvent(CatchEvent e) {
            new MessageCatchEventAdvancedChecker(e).check();
        }

        @Override
        public void handleErrorEvent(CatchEvent e) {
            new ErrorCatchEventAdvancedChecker(e).check();
        }

        @Override
        public void handleLinkEvent(CatchEvent e) {
        }

        @Override
        public void handleEscalationEvent(CatchEvent e) {
        }

        @Override
        public void handleMultipleEvent(CatchEvent e) {
        }

        @Override
        public void handleNoneEvent(CatchEvent e) {
        }

        @Override
        public void handleSignalEvent(CatchEvent e) {
            new SignalCatchEventAdvancedChecker(e).check();
        }

        @Override
        public void handleTimerEvent(CatchEvent event) {
            new TimerEventAdvancedChecker(event).check();
        }

        @Override
        public void handleTerminateEvent(CatchEvent e) {
        }
    }
}

