/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.UnknownCorrelationPropertyInKeyException;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import org.jetbrains.annotations.NotNull;

public class CorrelationKeyChecker
extends ProjectObjectChecker {
    private CorrelationKeyContainer container;
    private ProcessChecker.CheckContext context;

    public CorrelationKeyChecker(@NotNull CorrelationKeyContainer container, @NotNull ProcessChecker.CheckContext context) {
        super(context.getListener());
        this.container = container;
        this.context = context;
    }

    @Override
    public void check() {
        for (CorrelationKey key : this.container.getCorrelationKeys()) {
            this.checkKey(key);
        }
    }

    private ProcessChecker.CheckContext getContext() {
        return this.context;
    }

    private CheckOptions getOptions() {
        return this.getContext().getOptions();
    }

    private void checkKey(@NotNull CorrelationKey key) {
        for (CorrelationProperty property : key.getProperties()) {
            if (!property.isUnknownProperty()) continue;
            this.reportError(key, new UnknownCorrelationPropertyInKeyException(key, property));
        }
    }
}

