/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.Resource;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.model.cm.Events;
import oracle.bpm.casemgmt.model.cm.Milestone;
import oracle.bpm.casemgmt.model.cm.Milestones;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

class CaseChecker {
    private CaseChecker() {
    }

    public static Collection<Msg> check(@NotNull Case casemgmt) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        result.addAll(CaseChecker.checkPermissions(casemgmt));
        result.addAll(CaseChecker.checkCaseData(casemgmt));
        result.addAll(CaseChecker.checkStakeholders(casemgmt));
        result.addAll(CaseChecker.checkEvents(casemgmt));
        result.addAll(CaseChecker.checkMilestones(casemgmt));
        return result;
    }

    private static Collection<Msg> checkStakeholders(@NotNull Case casemgmt) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        StakeHolders stakeHolders = casemgmt.getStakeHolders();
        HashSet<String> checkedEvents = new HashSet<String>();
        for (StakeHolder stakeHolder : stakeHolders) {
            String fullName = CaseManagementUtils.getDisplayName(bundle, stakeHolder.getName());
            if (checkedEvents.contains(stakeHolder.getName())) {
                result.add(ProjectCompileMsg.DUPLICATED_STAKEHOLDER(fullName));
            } else {
                checkedEvents.add(stakeHolder.getName());
            }
            for (Resource resource : stakeHolder) {
                Value value = resource.getValue();
                if (!Str.isEmpty((String)value.getValue())) continue;
                result.add(ProjectCompileMsg.STAKEHOLDER_VALUE_IS_EMPTY(fullName));
            }
        }
        return result;
    }

    private static Collection<Msg> checkEvents(@NotNull Case casemgmt) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        Events events = casemgmt.getEvents();
        HashSet<String> checkedEvents = new HashSet<String>();
        for (String event : events) {
            if (checkedEvents.contains(event)) {
                String fullName = CaseManagementUtils.getDisplayName(bundle, event);
                result.add(ProjectCompileMsg.DUPLICATED_CASE_EVENT(fullName));
                continue;
            }
            checkedEvents.add(event);
        }
        return result;
    }

    private static Collection<Msg> checkMilestones(@NotNull Case casemgmt) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        Milestones milestones = casemgmt.getMilestones();
        HashSet<String> checkedEvents = new HashSet<String>();
        for (Milestone milestone : milestones) {
            if (checkedEvents.contains(milestone.getName())) {
                String fullName = CaseManagementUtils.getDisplayName(bundle, milestone.getName());
                result.add(ProjectCompileMsg.DUPLICATED_CASE_MILESTONE(fullName));
                continue;
            }
            checkedEvents.add(milestone.getName());
        }
        return result;
    }

    private static Collection<Msg> checkCaseData(@NotNull Case casemgmt) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        List caseDataList = casemgmt.getCaseData();
        for (CaseData caseData : caseDataList) {
            HashSet<String> set = new HashSet<String>();
            for (Data data : caseData) {
                String name = data.getName();
                String fullName = CaseManagementUtils.getDisplayName(bundle, name);
                if (Str.isEmpty((String)name)) {
                    result.add(ProjectCompileMsg.INVALID_NAME_FOR_CASE_DATA(data.getType()));
                } else if (set.contains(name)) {
                    result.add(ProjectCompileMsg.DUPLICATED_CASE_DATA(fullName));
                } else {
                    set.add(name);
                }
                if (!Str.isEmpty((String)data.getType())) continue;
                result.add(ProjectCompileMsg.INVALID_TYPE_FOR_CASE_DATA(fullName));
            }
        }
        return result;
    }

    private static Collection<Msg> checkPermissions(@NotNull Case casemgmt) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        Permissions permissions = casemgmt.getPermissions();
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String permission : permissions) {
            if (set.contains(permission)) {
                String fullName = CaseManagementUtils.getDisplayName(bundle, permission);
                result.add(ProjectCompileMsg.DUPLICATED_PERMISSION(fullName));
                continue;
            }
            set.add(permission);
        }
        return result;
    }
}

