/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameterType;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

class CaseActivityChecker {
    private CaseActivityChecker() {
    }

    public static Collection<Msg> check(@NotNull Case casemgmt, @NotNull CaseActivity caseActivity) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        result.addAll(CaseActivityChecker.checkInputParameters(casemgmt, caseActivity));
        result.addAll(CaseActivityChecker.checkOutputParameters(casemgmt, caseActivity));
        return result;
    }

    private static Collection<Msg> checkInputParameters(@NotNull Case casemgmt, CaseActivity caseActivity) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        String activityFullName = CaseManagementUtils.getDisplayName(bundle, caseActivity.getName());
        InputParameters inputParameters = caseActivity.getActivity().getInputParameters();
        HashSet<String> set = new HashSet<String>();
        boolean hasPayloadParameters = false;
        for (InputParameter inputParameter : inputParameters) {
            String dataName;
            String name = inputParameter.getParamName();
            if (set.contains(name)) {
                result.add(ProjectCompileMsg.DUPLICATED_INPUT_DATA(name, activityFullName));
            }
            set.add(name);
            hasPayloadParameters = inputParameter.getType().isPayload() || hasPayloadParameters;
            InputParameterType type = inputParameter.getType();
            if (!type.isCaseData() && (!type.isPayload() || !inputParameter.toPayload().isStoreData()) || !Str.isEmpty((String)(dataName = inputParameter.getDataName()))) continue;
            result.add(ProjectCompileMsg.CASE_ACTIVITY_INPUT_DATA_EMPTY_CASE_DATA(name, activityFullName));
        }
        if (hasPayloadParameters && !caseActivity.isManual()) {
            result.add(ProjectCompileMsg.CASE_ACTIVITY_AUTOMATIC_WITH_PAYLOAD(activityFullName));
        }
        return result;
    }

    private static Collection<Msg> checkOutputParameters(@NotNull Case casemgmt, CaseActivity caseActivity) {
        ArrayList<Msg> result = new ArrayList<Msg>();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        String activityFullName = CaseManagementUtils.getDisplayName(bundle, caseActivity.getName());
        OutputParameters outputParameters = caseActivity.getActivity().getOutputParameters();
        for (Output output : outputParameters) {
            HashSet<String> set = new HashSet<String>();
            for (OutputParameter outputParameter : output) {
                String dataName;
                String name = outputParameter.getParamName();
                if (set.contains(name)) {
                    result.add(ProjectCompileMsg.DUPLICATED_OUTPUT_DATA(name, activityFullName));
                }
                set.add(name);
                if (!outputParameter.isStoreData() || !Str.isEmpty((String)(dataName = outputParameter.getDataName()))) continue;
                result.add(ProjectCompileMsg.CASE_ACTIVITY_OUTPUT_DATA_EMPTY_CASE_DATA(name, activityFullName));
            }
        }
        return result;
    }
}

