/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectObjectChecker {
    private ProjectMessageListener listener;

    public ProjectObjectChecker(@NotNull ProjectMessageListener listener) {
        this.listener = listener;
    }

    public abstract void check() throws ProjectException;

    public ProjectMessageListener getListener() {
        return this.listener;
    }

    protected void reportWarning(ProjectObject projectObject, ProjectException e) {
        this.getListener().reportWarning(projectObject, e);
    }

    protected void reportError(ProjectObject object, ProjectException exception) {
        ProjectMessageListener messageListener = this.getListener();
        messageListener.reportError(object, exception);
    }
}

