/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import java.net.URI;
import java.util.Map;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionContext {
    private DataDeclarationContainer declarationsContainer;
    private boolean isIgnoreReadOnly = false;
    private boolean isLValue;
    private CatalogType resultType;
    private Map<String, URI> usedNameSpaces;

    public ExpressionContext(@NotNull DataDeclarationContainer declarationsContainer) {
        this(declarationsContainer, null);
    }

    public ExpressionContext(@NotNull DataDeclarationContainer declarationsContainer, @Nullable CatalogType resultType) {
        this(declarationsContainer, resultType, false);
    }

    public ExpressionContext(@NotNull DataDeclarationContainer declarationsContainer, boolean isLValue) {
        this(declarationsContainer, null, isLValue);
    }

    public ExpressionContext(@NotNull DataDeclarationContainer declarationsContainer, @Nullable CatalogType resultType, boolean isLValue) {
        this.declarationsContainer = declarationsContainer;
        this.resultType = resultType;
        this.isLValue = isLValue;
    }

    public DataDeclarationContainer getDeclarationsContainer() {
        return this.declarationsContainer;
    }

    public CatalogType getResultType() {
        return this.resultType;
    }

    public void setResultType(@Nullable CatalogType resultType) {
        this.resultType = resultType;
    }

    public boolean isLValue() {
        return this.isLValue;
    }

    public void setLValue(boolean isLValue) {
        this.isLValue = isLValue;
    }

    public Map<String, URI> getUsedNameSpaces() {
        return this.usedNameSpaces;
    }

    public void setUsedNameSpaces(Map<String, URI> usedNameSpaces) {
        this.usedNameSpaces = usedNameSpaces;
    }

    public boolean isIgnoreReadOnly() {
        return this.isIgnoreReadOnly;
    }

    public void setIgnoreReadOnly(boolean isIgnoreReadOnly) {
        this.isIgnoreReadOnly = isIgnoreReadOnly;
    }

    public ExpressionContext copy() {
        ExpressionContext result = new ExpressionContext(this.declarationsContainer, this.resultType, this.isLValue);
        result.setUsedNameSpaces(this.usedNameSpaces);
        result.setIgnoreReadOnly(this.isIgnoreReadOnly);
        return result;
    }
}

