/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.compiler.xpath.XPathUsageType;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalogUtils {
    private CatalogUtils() {
    }

    public static XPathVariable asXPathVariable(final @NotNull DataDeclaration declaration, final @NotNull DataDeclarationContainer context) {
        return new XPathVariable(){
            private QName[] dataContextPath;

            public String getName() {
                return declaration.getName();
            }

            public String toString() {
                return String.format("%s(%s): %s", this.getName(), this.getUsageType(), this.getType());
            }

            public String getNativeName() {
                return declaration.getNativeName();
            }

            public String getContainerName() {
                return declaration.getDeclarationContainer().getName();
            }

            public TypeRef getType() {
                return declaration.getType().getDelegate().getRef();
            }

            public XPathUsageType getUsageType() {
                return CatalogUtils.asXPathUsageType(declaration.getDeclarationType());
            }

            public QName[] getDataContextPath() {
                QName[] result = this.dataContextPath;
                if (result == null) {
                    if (this.getUsageType() != XPathUsageType.DATA_CONTEXT) {
                        throw new UnsupportedOperationException(String.format("\"%s\" is not a Data-Context variable", this.getName()));
                    }
                    this.dataContextPath = result = CatalogUtils.resolveArgumentPath(declaration, context);
                }
                return (QName[])result.clone();
            }

            public boolean isReadOnly() {
                return declaration.isReadOnly();
            }
        };
    }

    public static DataDeclarationType asDataDeclarationType(@Nullable XPathUsageType type) {
        DataDeclarationType result = (DataDeclarationType)((Object)TypeMapHolder.TYPE_MAP.inverse().get((Object)type));
        if (result == null && type != null) {
            throw new IllegalArgumentException(type.toString());
        }
        return result;
    }

    private static XPathUsageType asXPathUsageType(@Nullable DataDeclarationType type) {
        XPathUsageType result = (XPathUsageType)TypeMapHolder.TYPE_MAP.get((Object)type);
        if (result == null && type != null) {
            throw new IllegalArgumentException(type.toString());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static QName[] resolveArgumentPath(@NotNull DataDeclaration argument, @NotNull DataDeclarationContainer context) {
        List<QName> qNameList;
        FlowNode flowNode;
        DataDeclarationContainer declarationContainer = argument.getDeclarationContainer();
        ProjectObject parentObject = declarationContainer.getParentObject();
        FlowNode flowNode2 = flowNode = parentObject instanceof FlowNode ? (FlowNode)parentObject : null;
        if (flowNode == null) {
            if (!(declarationContainer instanceof CatalogMember)) return new QName[]{new QName(argument.getName())};
            CatalogMember catalogMember = (CatalogMember)declarationContainer;
            qNameList = CatalogUtils.resolveArgumentPath(catalogMember, argument, context);
            return qNameList.toArray(new QName[qNameList.size()]);
        } else {
            qNameList = CatalogUtils.resolveArgumentPath(flowNode, argument);
        }
        return qNameList.toArray(new QName[qNameList.size()]);
    }

    @NotNull
    private static List<QName> resolveArgumentPath(@NotNull CatalogMember catalogMember, @NotNull DataDeclaration argument, @NotNull DataDeclarationContainer context) {
        MethodTypeDescription mtd = CatalogUtils.getMethodTypeDescriptionFrom(catalogMember);
        String argName = argument.getName();
        if (!CatalogUtils.isHumanTask(mtd)) {
            return CatalogUtils.resolveArgumentNoHumanTask(mtd, argName);
        }
        List<QName> qNameList = CatalogUtils.resolveArgumentNoHumanTask(mtd, "execData");
        if (!CatalogUtils.isHumanTaskOut(context)) {
            String message = "initiateTask";
            qNameList.add(0, new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "initiateTask"));
        }
        if (!argName.equals("execData")) {
            ObjectTypeDescription objectType;
            QName execDataQN = qNameList.get(qNameList.size() - 1);
            String htNamespace = execDataQN.getNamespaceURI();
            qNameList.add(new QName(htNamespace, "payload"));
            ObjectTypeDescription objectTypeDescription = objectType = argument.getType().isObject() ? argument.getType().asObject().getObjectType() : null;
            if (objectType != null && objectType.isSchemaObject() && objectType.asSchemaObject().isElement()) {
                qNameList.add(objectType.asSchemaObject().getQName());
            } else {
                qNameList.add(new QName(htNamespace, argument.getNativeName()));
            }
        }
        return qNameList;
    }

    private static boolean isHumanTaskOut(DataDeclarationContainer context) {
        DataDeclaration outcome = context.findDeclaration("outcome");
        return outcome != null && outcome.isOut();
    }

    @NotNull
    private static List<QName> resolveArgumentNoHumanTask(MethodTypeDescription mtd, String argument) {
        int argIndex = mtd.getArgument(argument);
        Argument argTd = mtd.getArgument(argIndex);
        SchemaObject schemaObject = argTd.getType().asSchemaObject();
        ArrayList<QName> qNameList = new ArrayList<QName>();
        if (!schemaObject.isType() && !schemaObject.isBasicType()) {
            qNameList.add(schemaObject.getQName());
        }
        return qNameList;
    }

    private static boolean isHumanTask(MethodTypeDescription mtd) {
        return ComponentType.HUMAN_TASK.getText().equals(mtd.getParent().getComponentType());
    }

    @NotNull
    private static MethodTypeDescription getMethodTypeDescriptionFrom(@NotNull CatalogMember catalogMember) {
        MethodTypeDescription delegate = (MethodTypeDescription)catalogMember.getDelegate();
        if (delegate.isDelegated()) {
            TypeRef delegatedServiceRef = ((DelegatedMethodTypeDescription)delegate).getDelegatedServiceRef();
            TypeDescription typeDescription = delegatedServiceRef.get();
            int memberIndex = typeDescription.getMemberIndex(catalogMember.getName());
            return typeDescription.getMemberType(memberIndex);
        }
        return delegate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static List<QName> resolveArgumentPath(@NotNull FlowNode flowNode, @NotNull DataDeclaration argument) {
        ArrayList<QName> qNameList = new ArrayList<QName>();
        CatalogType type = argument.getType();
        TypeDescription typeDescription = type.getDelegate();
        if (typeDescription.hasErrors()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is not a valid data type. The type has errors", argument.getName()));
        }
        SchemaObject schemaObject = typeDescription.asSchemaObject();
        if (schemaObject.isFromWsdl()) {
            if (!schemaObject.isElement()) throw new UnsupportedOperationException(String.format("\"%s\" is not a valid data type. The type has errors", argument.getName()));
            String typeName = schemaObject.getName();
            qNameList.add(new QName(schemaObject.getNamespace(), typeName));
            return qNameList;
        } else {
            if (flowNode.isConversational()) {
                OperationReferenceImpl processOperationWrapper = new OperationReferenceImpl(flowNode.asAnyNode(Conversational.class));
                QName wrappedType = processOperationWrapper.getInputType();
                if (wrappedType == null) {
                    wrappedType = processOperationWrapper.getOutputType();
                }
                qNameList.add(wrappedType);
            }
            QName innerTypeQName = schemaObject.isElement() ? new QName(schemaObject.getNamespace(), schemaObject.getName()) : new QName(argument.getName());
            qNameList.add(innerTypeQName);
        }
        return qNameList;
    }

    private static class TypeMapHolder {
        static final BiMap<DataDeclarationType, XPathUsageType> TYPE_MAP;

        private TypeMapHolder() {
        }

        static {
            HashBiMap typeMap = new HashBiMap(XPathUsageType.values().length);
            typeMap.put((Object)DataDeclarationType.DATA_INPUT, (Object)XPathUsageType.DATA_INPUT);
            typeMap.put((Object)DataDeclarationType.DATA_OUTPUT, (Object)XPathUsageType.DATA_OUTPUT);
            typeMap.put((Object)DataDeclarationType.DATA_OBJECT, (Object)XPathUsageType.DATA_OBJECT);
            typeMap.put((Object)DataDeclarationType.DATA_DECLARATION, (Object)XPathUsageType.DATA_CONTEXT);
            typeMap.put((Object)DataDeclarationType.ACTIVITY_PREDEFINED_VARIABLE, (Object)XPathUsageType.ACTIVITY_INSTANCE_ATTRIBUTE);
            typeMap.put((Object)DataDeclarationType.PROCESS_PREDEFINED_VARIABLE, (Object)XPathUsageType.PROCESS_INSTANCE_ATTRIBUTE);
            typeMap.put((Object)DataDeclarationType.GATEWAY_PREDEFINED_VARIABLE, (Object)XPathUsageType.GATEWAY_INSTANCE_ATTRIBUTE);
            TYPE_MAP = CollectionUtils.unmodifiableBiMap((BiMap)typeMap);
        }
    }
}

