/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bam.chartviewer.MatrixEvaluatorImpl;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.resources.Msg;

class SingleIndicatorMatrixEvaluator
extends MatrixEvaluatorImpl {
    private Object[] columnNames;
    private RunningInfo[][] data;
    private boolean rotate;
    private Object[] rowNames;
    private Indicator selectedIndicator;
    private List selectedIndicators = new ArrayList();
    private Msg title;

    public SingleIndicatorMatrixEvaluator(RunningInfo[][] shown, Msg title, Object[] rowNames, Object[] columnNames, Indicator selectedIndicator, boolean rotate) {
        this.data = shown;
        this.title = title;
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        this.selectedIndicator = selectedIndicator;
        this.rotate = rotate;
        this.selectedIndicators.add(selectedIndicator);
    }

    @Override
    public int getColumnCount() {
        if (this.rotate) {
            return this.rowNames.length + 1;
        }
        return this.columnNames.length + 1;
    }

    @Override
    public int getRowCount() {
        if (this.rotate) {
            return this.columnNames.length + 1;
        }
        return this.rowNames.length + 1;
    }

    @Override
    public Object getValueAt(int row, int colum) {
        if (row == 0 && colum == 0) {
            return this.title;
        }
        if (row == 0) {
            if (this.rotate) {
                return this.rowNames[colum - 1];
            }
            return this.columnNames[colum - 1];
        }
        if (colum == 0) {
            if (this.rotate) {
                return this.columnNames[row - 1];
            }
            return this.rowNames[row - 1];
        }
        if (this.rotate) {
            return this.selectedIndicator.get((BAMRunningInfo)this.data[colum - 1][row - 1]);
        }
        return this.selectedIndicator.get((BAMRunningInfo)this.data[row - 1][colum - 1]);
    }

    @Override
    public List getSelectedIndicators() {
        return this.selectedIndicators;
    }

    @Override
    public void sort(String categoryLabel) {
        if (categoryLabel != null) {
            int index = 0;
            for (int i = 0; i < this.columnNames.length; ++i) {
                String candidate = (String)this.columnNames[i];
                if (!candidate.equals(categoryLabel)) continue;
                index = i;
                break;
            }
            this.sort(index);
        }
    }

    private void sort(int categoryIndex) {
        int i = this.data.length;
        while (--i >= 0) {
            boolean flipped = false;
            for (int j = 0; j < i; ++j) {
                if (this.compare(this.selectedIndicator, this.data[j][categoryIndex], this.data[j + 1][categoryIndex]) >= 0) continue;
                RunningInfo[] a = this.data[j];
                String aName = (String)this.rowNames[j];
                this.data[j] = this.data[j + 1];
                this.rowNames[j] = this.rowNames[j + 1];
                this.data[j + 1] = a;
                this.rowNames[j + 1] = aName;
                flipped = true;
            }
            if (flipped) continue;
            return;
        }
    }
}

