/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.bam.chartviewer.ResourceCheckTreeNode;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.TreeNode;

public class ResourceCheckTree
extends CheckTree {
    private Collection<SimulationResource> allResources;
    private List<SimulationResource> selectedResources;

    private ResourceCheckTree(UiContainer parent, ResourceCheckTreeNode root, Collection<SimulationResource> resources) {
        super(parent);
        this.setRoot((TreeNode)root);
        this.setShowsRootHandles(true);
        this.allResources = resources;
    }

    public static ResourceCheckTree createResourceCheckTree(UiContainer parent, Collection<SimulationResource> resources) {
        ResourceCheckTree tree = null;
        ResourceCheckTreeNode resourcesRoot = ResourceCheckTreeNode.createRootNode(BamMsg.ALL, null, tree);
        tree = ResourceCheckTree.createResourcesCheckTree(parent, resourcesRoot, resources);
        CheckTreeNode rootNode = tree.getRoot();
        ArrayList<SimulationResource> resourcesList = new ArrayList<SimulationResource>();
        ArrayList<ResourceCheckTreeNode> resourcesCheckTreeNodes = new ArrayList<ResourceCheckTreeNode>();
        for (SimulationResource resource : resources) {
            resourcesList.add(resource);
            resourcesCheckTreeNodes.add(new ResourceCheckTreeNode(resource, null, tree));
        }
        rootNode.addAll(resourcesCheckTreeNodes);
        rootNode.expand();
        tree.setSelectedResources(resourcesList);
        return tree;
    }

    public List<SimulationResource> getSelectedResources() {
        if (this.selectedResources == null) {
            this.selectedResources = new ArrayList<SimulationResource>();
        }
        return this.selectedResources;
    }

    public void setSelectedResources(List<SimulationResource> resources) {
        for (TreeNode node : this.getRoot()) {
            if (resources.contains(node.getUserObject())) {
                node.setSelected(TreeNode.Selection.ALL);
                continue;
            }
            node.setSelected(TreeNode.Selection.NONE);
        }
        this.getRoot().expand();
        this.selectedResources = resources;
    }

    public void selectAllResources() {
        List<SimulationResource> selectedResources = this.getSelectedResources();
        selectedResources.clear();
        for (SimulationResource entry : this.allResources) {
            selectedResources.add(entry);
        }
    }

    private static ResourceCheckTree createResourcesCheckTree(UiContainer parent, ResourceCheckTreeNode node, Collection<SimulationResource> resources) {
        return new ResourceCheckTree(parent, node, resources);
    }
}

