/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.Collection;
import java.util.Map;
import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.bam.chartviewer.ActivityInfo;
import oracle.bpm.bam.chartviewer.CategoryCheckTree;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.IndicatorsCheckTree;
import oracle.bpm.bam.chartviewer.ResourceCheckTree;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.CheckTree;

public class CheckTreePanel
extends ScrollPane {
    private CheckTree tree = null;

    private CheckTreePanel(UiContainer parent) {
        super(parent);
    }

    public static CheckTreePanel createLocalizedActivityCheckTreePanel(UiContainer parent, Map<String, Map<String, ActivityInfo>> activities) {
        CheckTreePanel checkTreePanel = new CheckTreePanel(parent);
        checkTreePanel.setTree(ActivityCheckTree.LocalizedActivityCheckTree.createLocalizedActivityCheckTree((UiContainer)checkTreePanel, activities));
        return checkTreePanel;
    }

    public static CheckTreePanel createCategoryCheckTreePanel(UiContainer parent) {
        CheckTreePanel checkTreePanel = new CheckTreePanel(parent);
        checkTreePanel.setTree(CategoryCheckTree.createCategoryCheckTree((UiContainer)checkTreePanel));
        return checkTreePanel;
    }

    public static CheckTreePanel createIndicatorsCheckTree(UiContainer parent, IndicatorSelections indicatorSelections, boolean resourceIndicators) {
        CheckTreePanel checkTreePanel = new CheckTreePanel(parent);
        checkTreePanel.setTree(IndicatorsCheckTree.createIndicatorsCheckTree((UiContainer)checkTreePanel, indicatorSelections, resourceIndicators));
        return checkTreePanel;
    }

    public static CheckTreePanel createResourceCheckTreePanel(UiContainer parent, Collection<SimulationResource> resources) {
        CheckTreePanel checkTreePanel = new CheckTreePanel(parent);
        checkTreePanel.setTree(ResourceCheckTree.createResourceCheckTree((UiContainer)checkTreePanel, resources));
        return checkTreePanel;
    }

    public CheckTree getTree() {
        return this.tree;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void setTree(CheckTree tree) {
        this.tree = tree;
        this.setView((UiComponent)tree);
        this.updateUI();
    }

    public void setParent(UiContainer parent) {
        super.setParent(parent);
        if (this.tree != null) {
            this.tree.setParent(parent);
        }
    }
}

