/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.chartviewer.CheckTreePanel;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.IndicatorsCheckTree;
import oracle.bpm.bam.chartviewer.ResourceCheckTree;
import oracle.bpm.bam.chartviewer.ResourceIndicatorSelections;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.CheckSelectionChangedEvent;
import oracle.bpm.ui.event.CheckSelectionListener;
import org.jetbrains.annotations.NotNull;

public class ChartViewerUtils {
    public static boolean areResourcesDefined(@NotNull ChartManager chartManager) {
        return chartManager.getResources() != null && !chartManager.getResources().isEmpty();
    }

    public static ActivityCheckTree createActivityCheckTree(@NotNull UiContainer parent, final @NotNull ChartManager chartManager, final @NotNull CheckSelectionListener treeListener) {
        final ActivityCheckTree tree = ActivityCheckTree.LocalizedActivityCheckTree.createLocalizedActivityCheckTree(parent, chartManager.getLocalizedActivitiesByProcess());
        if (chartManager.getSelectedActivities() != null) {
            tree.setSelectedActivities(chartManager.getSelectedActivities());
        }
        tree.addCheckSelectionListener(new CheckSelectionListener(){

            public void checkedSelectionChanged(CheckSelectionChangedEvent event) {
                chartManager.setSelection(tree.getSelectedActivitiesByProcess());
                treeListener.checkedSelectionChanged(event);
            }
        });
        tree.repaint();
        return tree;
    }

    public static CheckTreePanel createActivityCheckTreePanel(@NotNull UiContainer parent, final @NotNull ChartManager chartManager, final @NotNull CheckSelectionListener treeListener) {
        CheckTreePanel activitiesCheckTreePanel = CheckTreePanel.createLocalizedActivityCheckTreePanel(parent, chartManager.getLocalizedActivitiesByProcess());
        final ActivityCheckTree tree = (ActivityCheckTree)activitiesCheckTreePanel.getTree();
        if (chartManager.getSelectedActivities() != null) {
            tree.setSelectedActivities(chartManager.getSelectedActivities());
        }
        tree.addCheckSelectionListener(new CheckSelectionListener(){

            public void checkedSelectionChanged(CheckSelectionChangedEvent event) {
                chartManager.setSelection(tree.getSelectedActivitiesByProcess());
                treeListener.checkedSelectionChanged(event);
            }
        });
        tree.repaint();
        return activitiesCheckTreePanel;
    }

    public static CheckTreePanel createResourcesCheckTreePanel(@NotNull UiContainer parent, final @NotNull ChartManager chartManager, final @NotNull CheckSelectionListener treeListener) {
        CheckTreePanel resourcesCheckTreePanel = CheckTreePanel.createResourceCheckTreePanel(parent, chartManager.getResources());
        final ResourceCheckTree tree = (ResourceCheckTree)resourcesCheckTreePanel.getTree();
        if (chartManager.getSelectedResources() != null) {
            tree.setSelectedResources(chartManager.getSelectedResources());
        }
        tree.addCheckSelectionListener(new CheckSelectionListener(){

            public void checkedSelectionChanged(CheckSelectionChangedEvent event) {
                chartManager.setSelectedResources(tree.getSelectedResources());
                treeListener.checkedSelectionChanged(event);
            }
        });
        return resourcesCheckTreePanel;
    }

    public static CheckTreePanel createIndicatorsCheckTreePanel(@NotNull UiContainer parent, @NotNull IndicatorSelections indicatorSelection, @NotNull boolean isResourceView, final @NotNull CheckSelectionListener treeListener) {
        CheckTreePanel indicatorsCheckTreePanel = CheckTreePanel.createIndicatorsCheckTree(parent, indicatorSelection, isResourceView);
        IndicatorsCheckTree indicatorsCheckTree = (IndicatorsCheckTree)indicatorsCheckTreePanel.getTree();
        indicatorsCheckTree.addCheckSelectionListener(new CheckSelectionListener(){

            public void checkedSelectionChanged(CheckSelectionChangedEvent event) {
                treeListener.checkedSelectionChanged(event);
            }
        });
        return indicatorsCheckTreePanel;
    }

    public static IndicatorSelections createDefaultIndicatorSelections() {
        return new IndicatorSelections(UnitType.UNITS);
    }

    public static ResourceIndicatorSelections createResourceIndicatorSelections() {
        return new ResourceIndicatorSelections(UnitType.UNITS);
    }
}

