/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import fuego.simulation.SimulationPhotoModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.bam.chartviewer.Chart;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.chartviewer.ChartViewerUtils;
import oracle.bpm.bam.chartviewer.CheckTreePanel;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.ReportPrinter;
import oracle.bpm.bam.chartviewer.ResourceIndicatorSelections;
import oracle.bpm.bam.chartviewer.SimulationDataChooserPanel;
import oracle.bpm.bam.model.SimulationDataModel;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.chart.ChartTypeLabelProvider;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.chart.resources.appearance.TooltipAppearance;
import oracle.bpm.chart.resources.appearance.View3DAppearance;
import oracle.bpm.chart.shared.events.UltraChartEvent;
import oracle.bpm.chart.shared.events.UltraChartEventListener;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.print.PageFormat;
import oracle.bpm.print.Printable;
import oracle.bpm.print.PrinterException;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.CloseableDialog;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.ComponentBuilder;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollablePanel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionAdapter;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.wizards.ui.WizardTitlePanel;
import org.jetbrains.annotations.NotNull;

public class ChartViewer
extends Panel
implements Printable {
    private ActivityDrillButton activityDrillButton;
    private CardLayout cardVisualizationPanelLayout;
    private ChartManager chartManager;
    private Panel chartVisualizationPanel;
    private BaseAction configAction;
    private IndicatorSelections currentIndicatorProvider;
    private IndicatorSelections defaultIndicatorProvider;
    private ComboBox drawingTypeCombo;
    private boolean isControlDown;
    private int previousX = -1;
    private ReportPrinter reportPrinter;
    private ResourceIndicatorSelections resourceIndicatorProvider;
    private UnitType selectedIndicatorType = UnitType.UNITS;
    private Table table;
    private static int popUpSeparation = 18;
    private static Dimension popupDimension = Dimension.valueOf((int)50, (int)100);
    private static final double ZOOM_IN = 1.1;
    private static final double ZOOM_OUT = 0.9;
    private static final String CARD_CHART = "chart";
    private static final String CARD_TABLE = "table";
    public static final Set<ChartType> CHART_TYPES = EnumSet.of(ChartType.COLUMN_CHART, ChartType.COLUMN_CHART_3D, ChartType.BAR_CHART, ChartType.BAR_CHART_3D);

    public ChartViewer(UiContainer parent) {
        super(parent);
        this.init();
    }

    public ChartManager getChartManager() {
        return this.chartManager;
    }

    public IndicatorSelections getCurrentIndicatorProvider() {
        return this.currentIndicatorProvider;
    }

    public IndicatorSelections getDefaultIndicatorProvider() {
        return this.defaultIndicatorProvider;
    }

    public ResourceIndicatorSelections getResourceIndicatorProvider() {
        return this.resourceIndicatorProvider;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.getReportPrinter().print(graphics, pageFormat, pageIndex);
    }

    public void refresh() {
        this.draw();
    }

    public void setPhotoModel(SimulationPhotoModel simulationPhotoModel) {
        if (simulationPhotoModel == null) {
            return;
        }
        SimulationDataModel simulationDataModel = SimulationDataModel.createSimulationDataModel(simulationPhotoModel);
        this.chartManager.initSelections(simulationDataModel);
        this.chartManager.drill(false);
        this.updateDrillButtons();
    }

    public void setResources(Collection<SimulationResource> resources) {
        this.chartManager.setResources(resources);
    }

    public void simulationStarted() {
        this.setEnabled(true);
        if (!ChartViewerUtils.areResourcesDefined(this.chartManager) && this.chartManager.isResourceView()) {
            this.chartManager.setAxis(2, 0);
            this.chartManager.setAxis(4, 2);
            this.setCurrentIndicatorProvider();
        }
    }

    public void setEnabled(boolean enabled) {
        this.drawingTypeCombo.setEnabled(enabled);
        this.configAction.setEnabled(enabled);
        this.activityDrillButton.setEnabled(enabled);
        Chart chart = (Chart)this.chartManager.getChart();
        chart.setEnabled(enabled);
        chart.setVisible(enabled);
    }

    protected int getShowingAxis() {
        int indicatorsAxis = this.chartManager.getAxisForView(4);
        return indicatorsAxis == 0 ? 2 : 0;
    }

    protected void setShowOnAxis(int axis, boolean showActivities) {
        boolean isZ;
        int view = !showActivities ? 1 : (this.getChartManager().getChartLevel() == 0 ? 3 : 2);
        boolean isX = axis == 0;
        boolean bl = isZ = axis == 2;
        if (isZ || isX) {
            this.chartManager.setAxis(view, isZ ? 2 : 0);
            this.chartManager.setAxis(4, isZ ? 0 : 2);
            this.setCurrentIndicatorProvider();
            this.refresh();
            this.updateDrillButtons();
        }
    }

    protected void setSelectedIndicatorType(UnitType selectedIndicatorType) {
        this.selectedIndicatorType = selectedIndicatorType;
    }

    UnitType getVisualizationOption() {
        return this.selectedIndicatorType != null ? this.selectedIndicatorType : UnitType.UNITS;
    }

    private ReportPrinter getReportPrinter() {
        if (this.reportPrinter == null) {
            this.reportPrinter = new ReportPrinter(this.chartManager);
        }
        return this.reportPrinter;
    }

    private void init() {
        this.defaultIndicatorProvider = ChartViewerUtils.createDefaultIndicatorSelections();
        this.resourceIndicatorProvider = ChartViewerUtils.createResourceIndicatorSelections();
        this.currentIndicatorProvider = this.defaultIndicatorProvider;
        this.setLayout((Layout)new BorderLayout());
        Panel mainPanel = new Panel((UiContainer)this);
        mainPanel.setLayout((Layout)new BorderLayout());
        this.chartVisualizationPanel = new Panel((UiContainer)mainPanel);
        this.cardVisualizationPanelLayout = new CardLayout();
        this.chartVisualizationPanel.setLayout((Layout)this.cardVisualizationPanelLayout);
        ScrollPane scrollPane = new ScrollPane((UiContainer)this.chartVisualizationPanel);
        Chart chart = new Chart((UiContainer)scrollPane);
        chart.setColorAppearance(new DefaultColorAppearance());
        chart.setTooltips(new DefaultTooltipAppearance());
        chart.setVisible(false);
        this.chartManager = ChartManager.createForSimulation(chart);
        this.initChartManager();
        chart.setSize(DefaultConstants.D_CHART_SIZE.getWidth(), DefaultConstants.D_CHART_SIZE.getHeight());
        scrollPane.setView((UiComponent)chart);
        this.chartManager.setIndicatorProvider(this.currentIndicatorProvider);
        this.chartManager.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                ((Chart)ChartViewer.this.chartManager.getChart()).revalidate();
            }
        });
        this.chartManager.initAxes();
        ScrollablePanel scrollableToolBar = new ScrollablePanel((UiContainer)mainPanel);
        UiComponent toolBar = this.buildToolBar((UiContainer)scrollableToolBar);
        scrollableToolBar.setView(toolBar);
        this.table = new Table((UiContainer)this.chartVisualizationPanel, (TableModel)this.chartManager.getRawTableModel());
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(AutoResizeMode.OFF);
        this.table.setDefaultLabelProvider(Long.class, (LabelProvider)new ValueRenderer());
        this.table.setDefaultLabelProvider(Double.class, (LabelProvider)new ValueRenderer());
        this.table.setDefaultLabelProvider(Interval.class, (LabelProvider)new ValueRenderer());
        this.table.setDefaultColorProvider(Object.class, (ColorProvider)new FlatColorProvider());
        this.chartVisualizationPanel.add((UiComponent)scrollPane, (Object)CARD_CHART);
        this.chartVisualizationPanel.add((UiComponent)this.table, (Object)CARD_TABLE);
        this.cardVisualizationPanelLayout.show((UiContainer)this.chartVisualizationPanel, CARD_CHART);
        mainPanel.add((UiComponent)scrollableToolBar, (Object)"North");
        mainPanel.add((UiComponent)this.chartVisualizationPanel, (Object)"Center");
        this.add((UiComponent)mainPanel, "Center");
    }

    private UiComponent buildToolBar(UiContainer parent) {
        Panel toolBar = new Panel(parent);
        FormLayout layout = new FormLayout("pref,2px,pref:grow", "pref");
        CellConstraints cc = layout.createCellConstraints();
        toolBar.setLayout((Layout)layout);
        toolBar.add((UiComponent)this.buildDrawingTypeCombo((UiContainer)toolBar), (Object)cc.xy(1, 1));
        this.configAction = new BaseAction(BamMsg.CONFIGURE){
            ComponentBuilder builder;

            public void actionPerformed(ActionEvent e) {
                SimulationDataChooserPanel simulationDataChooserPanel = new SimulationDataChooserPanel(null, ChartViewer.this);
                WizardTitlePanel titlePanel = new WizardTitlePanel(null, Image.create((Msg)BamMsg.SIMULATION_CONFIG_DESC), false){

                    public Dimension getPreferredSize() {
                        return Dimension.valueOf((int)360, (int)50);
                    }
                };
                titlePanel.setDescription(BamMsg.SIMULATION_CONFIG_DESC.getDetail());
                CloseableDialog.showComponent((UiWindow)Ui.getRoot(), (UiComponent)simulationDataChooserPanel, (Msg)BamMsg.CONFIGURE_CHART, (UiComponent)titlePanel, (Dimension)Dimension.valueOf((int)400, (int)450));
            }
        };
        this.configAction.setEnabled(false);
        ToolBar buttonBar = new ToolBar((UiContainer)toolBar);
        toolBar.add((UiComponent)buttonBar, (Object)cc.xy(3, 1));
        buttonBar.addSeparator();
        ActivityDrillButton activityDrill = this.initActivityDrillButton((UiContainer)toolBar);
        buttonBar.add(activityDrill.getUp());
        activityDrill.setDownButton(buttonBar.add(activityDrill.getDown()));
        buttonBar.add(new BaseAction(BamMsg.DECREASE_FONT){

            public void run() {
                ChartViewer.this.chartManager.updateFont(-1);
                ChartViewer.this.refresh();
            }
        });
        buttonBar.add(new BaseAction(BamMsg.INCREASE_FONT){

            public void run() {
                ChartViewer.this.chartManager.updateFont(1);
                ChartViewer.this.refresh();
            }
        });
        buttonBar.add(Box.createHorizontalGlue((UiContainer)toolBar));
        buttonBar.add(this.configAction);
        return toolBar;
    }

    private void locatePopUpWindow(ToolBarItem source, PopUpWindow popup, CheckTreePanel checkTreePanel) {
        popup.setSize(popupDimension);
        popup.add((UiComponent)checkTreePanel);
        popup.show(source.getLocationOnScreen().getX(), source.getLocationOnScreen().getY() + popUpSeparation);
    }

    private synchronized void draw() {
        Object object = this.drawingTypeCombo.getSelectedItem();
        boolean isChart = object instanceof ChartType;
        if (isChart) {
            ChartType type = (ChartType)object;
            ChartType oldChartType = this.chartManager.getChartType();
            if (oldChartType != type && type.is3D()) {
                this.chartManager.getChart().getTransform3D().setXRotation(62);
                this.chartManager.getChart().getTransform3D().setYRotation(146);
                this.chartManager.getChart().getTransform3D().setZRotation(314);
            }
            ((Chart)this.chartManager.getChart()).setVisible(true);
            this.chartManager.setChartType(type);
            this.cardVisualizationPanelLayout.show((UiContainer)this.chartVisualizationPanel, CARD_CHART);
            this.chartManager.draw();
            this.repaint();
        } else {
            this.chartManager.draw();
            this.repaintTable();
        }
    }

    private void generalUpdate() {
        this.refresh();
        this.updateDrillButtons();
    }

    private void initChartManager() {
        ((Chart)this.chartManager.getChart()).addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int lastX = e.getX();
                if (ChartViewer.this.previousX != -1 && e.isControlDown()) {
                    UiComponent chart = UiComponent.get((Object)ChartViewer.this.chartManager.getChart());
                    Dimension chartSize = chart.getSize();
                    Dimension dim = lastX > ChartViewer.this.previousX ? Dimension.valueOf((int)((int)((double)chartSize.getWidth() * 1.01)), (int)((int)((double)chartSize.getHeight() * 1.01))) : Dimension.valueOf((int)((int)((double)chartSize.getWidth() * 0.99)), (int)((int)((double)chartSize.getHeight() * 0.99)));
                    chart.setSize(dim);
                }
                ChartViewer.this.previousX = lastX;
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ChartViewer.this.isControlDown = e.isControlDown();
                if (ChartViewer.this.isControlDown) {
                    ChartViewer.this.chartManager.drill(false);
                    ChartViewer.this.generalUpdate();
                }
            }
        };
        ((Chart)this.chartManager.getChart()).addMouseListener((MouseListener)mouseAdapter);
        ((Chart)this.chartManager.getChart()).addChartEventListener(new UltraChartEventListener(){

            public void chartDataClicked(UltraChartEvent event) {
                int chartRow = event.getDataPoint().getDataRow();
                int chartColumn = event.getDataPoint().getDataColumn();
                if (ChartViewer.this.isControlDown) {
                    ChartViewer.this.chartManager.drill(false);
                } else if (chartRow == -1) {
                    ChartViewer.this.chartManager.setSort((String)event.getDataPoint().getDataValue());
                } else {
                    if (ChartViewer.this.chartManager.getChartLevel() == 0) {
                        String processId = null;
                        if (ChartViewer.this.chartManager.getAxisForView(3) == 0) {
                            processId = ChartViewer.this.chartManager.getSelectedProcesses().get(chartRow);
                        } else if (ChartViewer.this.chartManager.getAxisForView(3) == 2) {
                            processId = ChartViewer.this.chartManager.getSelectedProcesses().get(chartColumn - 1);
                        }
                        if (processId != null) {
                            ChartViewer.this.chartManager.setCurrentProcess(processId);
                        }
                    }
                    ChartViewer.this.chartManager.drill(true);
                }
                ChartViewer.this.generalUpdate();
            }

            public void chartDataMouseOver(UltraChartEvent e) {
            }

            public void chartDataMouseOut(UltraChartEvent e) {
            }
        });
    }

    private ComboBox buildDrawingTypeCombo(UiContainer parent) {
        ArrayList<ChartType> chartTypes = new ArrayList<ChartType>(CHART_TYPES);
        this.drawingTypeCombo = UiFactory.createMutableComboBox((UiContainer)parent, chartTypes);
        this.drawingTypeCombo.addItem((Object)BamMsg.TABLE);
        this.drawingTypeCombo.setSelectedIndex(0);
        this.drawingTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    ChartViewer.this.refresh();
                    Object object = ChartViewer.this.drawingTypeCombo.getSelectedItem();
                    if (object instanceof ChartType) {
                        ChartType type = (ChartType)object;
                        ((Chart)ChartViewer.this.chartManager.getChart()).setChartType(type);
                        ChartViewer.this.cardVisualizationPanelLayout.show((UiContainer)ChartViewer.this.chartVisualizationPanel, ChartViewer.CARD_CHART);
                        ChartViewer.this.refresh();
                    } else {
                        ChartViewer.this.repaintTable();
                    }
                }
            }
        });
        this.drawingTypeCombo.setToolTipText(BamMsg.CHOOSE_CHART_TYPE);
        this.drawingTypeCombo.setLabelProvider((LabelProvider)new ChartTypeLabelProvider(Image.create((Msg)BamMsg.COLUMN)));
        return this.drawingTypeCombo;
    }

    private void repaintTable() {
        this.chartManager.getTableModel().setInverColumnNames(false);
        this.cardVisualizationPanelLayout.show((UiContainer)this.chartVisualizationPanel, CARD_TABLE);
        this.table.repaint();
    }

    private ActivityDrillButton initActivityDrillButton(UiContainer parent) {
        this.activityDrillButton = new ActivityDrillButton(parent);
        return this.activityDrillButton;
    }

    private BaseAction buildZoomAction(Msg msg, final double factor) {
        return new BaseAction(msg){

            public void run() {
                View3DAppearance view = ChartViewer.this.chartManager.getChart().getTransform3D();
                view.setScale(view.getScale() * (float)factor);
                ChartViewer.this.repaint();
            }
        };
    }

    private void setCurrentIndicatorProvider() {
        IndicatorSelections prevProvider = this.currentIndicatorProvider;
        this.currentIndicatorProvider = this.chartManager.isResourceView() ? this.resourceIndicatorProvider : this.defaultIndicatorProvider;
        this.selectedIndicatorType = this.currentIndicatorProvider.getSelectedUnitType();
        this.chartManager.setIndicatorProvider(this.currentIndicatorProvider);
        if (prevProvider != this.currentIndicatorProvider) {
            this.refresh();
        }
    }

    private void updateDrillButtons() {
        this.activityDrillButton.updateButtons();
    }

    private final class ProcessMenuItem
    extends MenuItem {
        @NotNull
        private final String processId;

        public ProcessMenuItem(@NotNull UiContainer parent, String processId) {
            super(parent, ChartViewer.this.chartManager.getProcessLabelById(processId));
            this.processId = processId;
        }

        @NotNull
        String getProcessId() {
            return this.processId;
        }
    }

    private class ActivityDrillButton {
        private BaseAction down;
        private ToolBarItem downButton;
        private BaseAction up;

        public ActivityDrillButton(UiContainer parent) {
            this.init();
        }

        public void setDownButton(ToolBarItem downButton) {
            this.downButton = downButton;
        }

        public BaseAction getUp() {
            return this.up;
        }

        public BaseAction getDown() {
            return this.down;
        }

        public void updateButtons() {
            if (ChartViewer.this.chartManager.isFreeDimension(2) && ChartViewer.this.chartManager.isFreeDimension(3)) {
                this.up.setEnabled(false);
                this.down.setEnabled(false);
            } else if (ChartViewer.this.chartManager.getChartLevel() == 0 && !ChartViewer.this.chartManager.isFreeDimension(3)) {
                this.up.setEnabled(false);
                this.down.setEnabled(true);
            } else if (ChartViewer.this.chartManager.getChartLevel() == 1 && !ChartViewer.this.chartManager.isFreeDimension(2)) {
                this.up.setEnabled(true);
                this.down.setEnabled(false);
            } else {
                this.up.setEnabled(false);
                this.down.setEnabled(false);
            }
        }

        public void setEnabled(boolean isEnabled) {
            this.up.setEnabled(isEnabled);
            this.down.setEnabled(isEnabled);
            if (isEnabled) {
                this.updateButtons();
            }
        }

        private void init() {
            this.up = new BaseAction(BamMsg.DRILLUP){

                public void actionPerformed(ActionEvent e) {
                    ChartViewer.this.chartManager.drill(false);
                    ChartViewer.this.generalUpdate();
                }
            };
            this.down = new BaseAction(BamMsg.DRILLDOWN){

                public void actionPerformed(ActionEvent e) {
                    List<String> selectedProcesses = ChartViewer.this.chartManager.getSelectedProcesses();
                    if (selectedProcesses.size() == 1) {
                        ActivityDrillButton.this.drillDown(selectedProcesses.get(0));
                    } else {
                        PopupMenu popup = new PopupMenu(ActivityDrillButton.this.downButton == null ? null : ActivityDrillButton.this.downButton.getParent());
                        for (String processId : selectedProcesses) {
                            final ProcessMenuItem item = new ProcessMenuItem((UiContainer)popup, processId);
                            item.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    ActivityDrillButton.this.drillDown(item.getProcessId());
                                }
                            });
                            popup.add((MenuItem)item);
                        }
                        popup.show(e.getSource(), 0, e.getSource().getHeight());
                    }
                }
            };
            this.up.setEnabled(false);
            this.down.setEnabled(false);
        }

        private void drillDown(String processId) {
            ChartViewer.this.chartManager.setCurrentProcess(processId);
            ChartViewer.this.chartManager.drill(true);
            ChartViewer.this.generalUpdate();
        }
    }

    private static class ValueRenderer
    extends LabelProvider.Default {
        private ValueRenderer() {
        }

        public String getText(Object element) {
            String text = element.toString();
            if (element instanceof Double) {
                Double dValue = (Double)element;
                element = (double)((int)(dValue * 100.0 + 0.5)) / 100.0;
                text = element.toString();
            } else if (element instanceof Interval) {
                Interval iValue = (Interval)element;
                text = iValue.format(IntervalUnit.YEARS, IntervalUnit.SECONDS);
            }
            return text;
        }
    }

    private static class FlatColorProvider
    extends ColorProvider.Default {
        private FlatColorProvider() {
        }

        public Color getBackground(Object element) {
            return Color.FUEGO_LIGHT_BLUE;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }

    private static class DefaultTooltipAppearance
    extends TooltipAppearance {
        private DefaultTooltipAppearance() {
            this.setHighlightFillColor(Color.decode((String)this.getSelectionColor()));
        }

        public String getSelectionColor() {
            return "#60d760";
        }
    }

    public static class DefaultColorAppearance
    extends ColorAppearance {
        private static final String[] NEW_COLORS = new String[]{"#264f79", "#d14f26", "#7676a3", "#267979", "#fea121"};
        private static final String[] LIGHT_COLOR_PALETTE = new String[]{"#ffcccc", "#ccccff", "#ccffcc", "#ffffcc", "#ffe6cc", "#ffccff", "#ccffff", "#808080"};
        private static final String[] ORACLE_16 = new String[]{"#FFFFFF", "#C6C6C6", "#FF0000", "#F7F700", "#00FF00", "#00F7F7", "#0000FF", "#FF00FF", "#000000", "#848484", "#840000", "#848400", "#008400", "#008484", "#000084", "#840084"};
        private static final String[] ORACLE_49 = new String[]{"#FFFFFF", "#FFB5B5", "#FFDEB5", "#FFFFB5", "#B5FFB5", "#C6D6FF", "#FFB5FF", "#C6C6C6", "#FF8484", "#FFB563", "#FFFF73", "#73FF73", "#84ADFF", "#FF73FF", "#949494", "#FF5252", "#FF9C31", "#F7F700", "#52FF52", "#3173FF", "#FF00FF", "#737373", "#FF0000", "#E77300", "#C6C600", "#00E700", "#0000FF", "#C600C6", "#424242", "#C60000", "#A55200", "#949400", "#00A500", "#0000A5", "#940094", "#313131", "#730000", "#844200", "#737300", "#008400", "#000084", "#730073", "#000000", "#520000", "#633100", "#525200", "#005200", "#000052", "#520052"};

        public DefaultColorAppearance() {
            this.setModelStyle(4);
            this.setScaling(0);
            String[] usedPalette = this.getPalette();
            Color[] colors = new Color[usedPalette.length];
            for (int i = 0; i < usedPalette.length; ++i) {
                colors[i] = Color.decode((String)usedPalette[i]);
            }
            this.setCustomPalette(colors);
        }

        public String[] getPalette() {
            return NEW_COLORS;
        }
    }
}

