/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import oracle.bpm.bam.chartviewer.ChartInterface;
import oracle.bpm.bam.chartviewer.ChartTableModel;
import oracle.bpm.bam.chartviewer.FontHelper;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.AxisLabelAppearance;
import oracle.bpm.chart.resources.appearance.LegendAppearance;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;

class ChartConfiguration {
    private ChartInterface chart;

    public ChartConfiguration(ChartInterface chart) {
        this.generalSettings();
        this.chart = chart;
        chart.getColorAppearance().setAntialias(false);
    }

    public void setFormatString(String axisFormatString, String toolTipFormatString) {
        this.setLinearAxisFormat(axisFormatString);
        this.chart.setToolTip(toolTipFormatString);
    }

    public void setUpChart() {
        this.chart.getData().setUseRowLabelsColumn(true);
        this.chart.getColorAppearance().setColorByRow(false);
        LegendAppearance legendAppearance = this.chart.getLegend();
        legendAppearance.setVisible(true);
    }

    public void configChart(ChartType chartType, ChartTableModel tableModel, Msg topMsg, Msg bottomMsg, int currentAxis, int fontDelta) {
        this.updateSize(tableModel);
        this.setAxisLabelOrientation(0);
        this.setChartType(chartType);
        this.setColumnLabelFormat(currentAxis, fontDelta);
        this.chart.setTitleTopMsg(topMsg, fontDelta);
        this.chart.setTitleBottomMsg(bottomMsg, fontDelta);
        this.updateLegend(fontDelta);
        tableModel.rotate(chartType.isPie());
        tableModel.setInverColumnNames(chartType.isBar());
        this.setDataSource(tableModel);
    }

    private void updateLegend(int fontDelta) {
        LegendAppearance legendAppearance = this.chart.getLegend();
        legendAppearance.setFont(FontHelper.adjustFont(legendAppearance.getFont(), fontDelta));
    }

    private void setChartType(ChartType chartType) {
        this.chart.setType(chartType);
        if (chartType.isPie()) {
            this.chart.getPieChart().setRowIndex(-1);
            this.chart.getPieChart().setLabelsOnPie(true);
            this.chart.getPieChart().getLabels().setLeaderLinesVisible(true);
            this.chart.getPieChart().getLabels().setFormat(1);
        }
    }

    private void setAxisLabelOrientation(int xAxisLabelOrientation) {
        DefaultConstants.D_AXIS_X_LABEL_ORIENTATION = xAxisLabelOrientation;
    }

    private void setColumnLabelFormat(int currentAxis, int fontDelta) {
        AxisLabelAppearance labelAppeareanceX = null;
        AxisLabelAppearance labelAppeareanceY = null;
        AxisLabelAppearance labelAppeareanceZ = null;
        if (this.chart.getType() == ChartType.COLUMN_CHART || this.chart.getType() == ChartType.COLUMN_CHART_3D) {
            labelAppeareanceX = this.chart.getAxis().getX().getLabels();
            labelAppeareanceY = this.chart.getAxis().getY().getLabels();
        } else if (this.chart.getType() == ChartType.BAR_CHART || this.chart.getType() == ChartType.BAR_CHART_3D) {
            labelAppeareanceX = this.chart.getAxis().getY().getLabels();
            labelAppeareanceY = this.chart.getAxis().getX().getLabels();
        }
        labelAppeareanceZ = this.chart.getAxis().getZ().getLabels();
        if (labelAppeareanceX == null) {
            labelAppeareanceX = new AxisLabelAppearance();
        }
        if (labelAppeareanceY == null) {
            labelAppeareanceY = new AxisLabelAppearance();
        }
        if (labelAppeareanceZ == null) {
            labelAppeareanceZ = new AxisLabelAppearance();
        }
        labelAppeareanceX.setFont(FontHelper.adjustFont(labelAppeareanceX.getFont(), fontDelta));
        labelAppeareanceX.setItemFormat(0);
        labelAppeareanceX.setItemFormatString(" ");
        labelAppeareanceY.setFont(FontHelper.adjustFont(labelAppeareanceY.getFont(), fontDelta));
        labelAppeareanceZ.setFont(FontHelper.adjustFont(labelAppeareanceZ.getFont(), fontDelta));
        if (currentAxis == 0) {
            labelAppeareanceX.setSeriesOrientation(1);
            labelAppeareanceY.setSeriesOrientation(0);
        } else {
            labelAppeareanceX.setSeriesOrientation(0);
            labelAppeareanceY.setSeriesOrientation(1);
        }
        if (this.chart.getType() == ChartType.COLUMN_CHART || this.chart.getType() == ChartType.COLUMN_CHART_3D) {
            this.chart.getAxis().getX().setLabels(labelAppeareanceX);
            this.chart.getAxis().getY().setLabels(labelAppeareanceY);
        } else if (this.chart.getType() == ChartType.BAR_CHART || this.chart.getType() == ChartType.BAR_CHART_3D) {
            this.chart.getAxis().getY().setLabels(labelAppeareanceX);
            this.chart.getAxis().getX().setLabels(labelAppeareanceY);
        }
        this.chart.getAxis().getZ().setLabels(labelAppeareanceZ);
    }

    private void setDataSource(ChartTableModel tableModel) {
        this.chart.getData().setDataSource((Object)tableModel);
        this.chart.getData().includeColumns(0, tableModel.getColumnCount() - 1, true);
        this.chart.getData().includeRows(0, tableModel.getRowCount() - 1, true);
        this.chart.getData().initializeAppearance(null);
    }

    private void setLinearAxisFormat(String formatString) {
        if (formatString == null) {
            formatString = DefaultConstants.D_AXIS_LABEL_FORMAT_DATA;
        }
        this.chart.getAxis().setDefaultLinearAxisFormat(formatString);
    }

    private void generalSettings() {
        DefaultConstants.D_TITLE_LEFT_VISIBLE = false;
        DefaultConstants.D_TITLE_BOTTOM_VISIBLE = false;
        DefaultConstants.D_TITLE_RIGHT_VISIBLE = false;
        DefaultConstants.D_TITLE_TOP_VISIBLE = true;
        DefaultConstants.D_PIE_CHART_LABELS_ON_PIE = true;
    }

    private void updateSize(ChartTableModel tableModel) {
        int minRowWidth = 100;
        int rowWidth = tableModel.getRowCount() * tableModel.getColumnCount() * 10;
        Dimension dim = rowWidth > minRowWidth ? Dimension.valueOf((int)rowWidth, (int)this.chart.getSize().getHeight()) : Dimension.valueOf((int)minRowWidth, (int)this.chart.getSize().getHeight());
        UiComponent.get((Object)this.chart).setMinimumSize(dim);
    }
}

