/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.bam.chartviewer.ActivityInfo;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.tree.TreeNode;

public class ActivityTreeToolBar
extends Panel {
    private ActivityCheckTree activityCheckTree;

    public ActivityTreeToolBar(UiContainer parent) {
        super(parent);
        this.buildUI();
    }

    public void setTree(ActivityCheckTree activityCheckTree) {
        this.activityCheckTree = activityCheckTree;
    }

    private void buildUI() {
        this.setLayout((Layout)new FlowLayout(3));
        this.addRibbon(BamMsg.SHOW_ALL, TreeNode.Selection.ALL);
        this.addRibbon(BamMsg.SHOW_NONE, TreeNode.Selection.NONE);
        this.addRibbon(BamMsg.SHOW_EVENTS, new ActivityCheckTree.Filter<ActivityInfo>(){

            @Override
            public boolean accepts(ActivityInfo value) {
                return value.getBpmnType().isEvent();
            }
        });
        this.addRibbon(BamMsg.SHOW_USER_TASK, new ActivityCheckTree.Filter<ActivityInfo>(){

            @Override
            public boolean accepts(ActivityInfo value) {
                return value.getBpmnType() == BpmnType.USER_TASK;
            }
        });
        this.addRibbon(BamMsg.SHOW_SERVICE_TASK, new ActivityCheckTree.Filter<ActivityInfo>(){

            @Override
            public boolean accepts(ActivityInfo value) {
                return value.getBpmnType() == BpmnType.SERVICE_TASK;
            }
        });
    }

    private void addRibbon(Msg msg, final TreeNode.Selection selection) {
        this.addRibbon(this, new BaseAction(msg){

            public void actionPerformed(ActionEvent event) {
                ActivityTreeToolBar.this.activityCheckTree.setSelected(ActivityTreeToolBar.this.activityCheckTree.getRoot(), selection);
            }
        });
    }

    private void addRibbon(Msg msg, ActivityCheckTree.Filter<ActivityInfo> baseAction) {
        this.addRibbon(this, this.buildAction(msg, baseAction));
    }

    private void addRibbon(Panel ribbon, BaseAction baseAction) {
        Button toolbarButton = new Button((UiContainer)ribbon, baseAction, 1);
        ribbon.add((UiComponent)toolbarButton);
        toolbarButton.setFont(toolbarButton.getFont().smaller(2));
        toolbarButton.setMargin(new Margin(2, 2, 2, 2));
    }

    private BaseAction buildAction(Msg show, final ActivityCheckTree.Filter<ActivityInfo> filter) {
        return new BaseAction(show){

            public void actionPerformed(ActionEvent event) {
                ActivityTreeToolBar.this.activityCheckTree.addSelectedByFilter(filter);
            }
        };
    }
}

