/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bam.chartviewer.ActivityCheckTreeNode;
import oracle.bpm.bam.chartviewer.ActivityInfo;
import oracle.bpm.bam.chartviewer.LocalizedActivityCheckTreeNode;
import oracle.bpm.collections.Procedure;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.TreeNode;

public class ActivityCheckTree
extends CheckTree {
    private Map<String, Map<String, ActivityInfo>> allProcessesAndLocalizedActivities = null;
    private Map<String, List<String>> selectedActivities = null;

    private ActivityCheckTree(UiContainer parent, ActivityCheckTreeNode root, Map<String, Map<String, ActivityInfo>> activitiesByProcess) {
        super(parent);
        this.setRoot((TreeNode)root);
        this.setShowsRootHandles(true);
        this.allProcessesAndLocalizedActivities = activitiesByProcess;
    }

    public List<String> getSelectedActivities(String consolidatedProcessId) {
        StringList activities = this.getSelectedActivitiesByProcess().get(consolidatedProcessId);
        if (activities == null) {
            activities = StringList.create();
            this.getSelectedActivitiesByProcess().put(consolidatedProcessId, (List<String>)activities);
        }
        return activities;
    }

    public Map<String, List<String>> getSelectedActivitiesByProcess() {
        if (this.selectedActivities == null) {
            this.selectedActivities = new HashMap<String, List<String>>();
        }
        return this.selectedActivities;
    }

    public void setSelectedActivities(Map<String, List<String>> activitiesByProcess) {
        this.selectActivities(activitiesByProcess, new Procedure<LocalizedActivityCheckTreeNode>(){

            public boolean execute(LocalizedActivityCheckTreeNode value) {
                value.setSelected(TreeNode.Selection.ALL);
                return true;
            }
        }, new Procedure<LocalizedActivityCheckTreeNode>(){

            public boolean execute(LocalizedActivityCheckTreeNode value) {
                value.setSelected(TreeNode.Selection.NONE);
                return true;
            }
        });
    }

    public void addSelectedActivities(Map<String, List<String>> activitiesByProcess) {
        this.selectActivities(activitiesByProcess, new Procedure<LocalizedActivityCheckTreeNode>(){

            public boolean execute(LocalizedActivityCheckTreeNode value) {
                ActivityCheckTree.this.setSelected(value, TreeNode.Selection.ALL);
                return true;
            }
        }, null);
    }

    private void selectActivities(Map<String, List<String>> activitiesByProcess, Procedure<LocalizedActivityCheckTreeNode> containedProcedure, Procedure<LocalizedActivityCheckTreeNode> nonCotainedProcedure) {
        for (TreeNode treeNode : this.getRoot()) {
            ActivityCheckTreeNode processNode = (ActivityCheckTreeNode)treeNode;
            List<String> activities = activitiesByProcess.get(processNode.getUserObject());
            if (activities == null) continue;
            for (TreeNode node : treeNode) {
                LocalizedActivityCheckTreeNode activityNode = (LocalizedActivityCheckTreeNode)node;
                if (activities.contains(activityNode.getUserObject().getKey())) {
                    if (containedProcedure == null) continue;
                    containedProcedure.execute((Object)activityNode);
                    continue;
                }
                if (nonCotainedProcedure == null) continue;
                nonCotainedProcedure.execute((Object)activityNode);
            }
        }
        this.getRoot().expand();
    }

    public void addSelectedByFilter(Filter<ActivityInfo> filter) {
        HashMap<String, List<String>> activitiesByProcess = new HashMap<String, List<String>>();
        Set<String> processIds = this.allProcessesAndLocalizedActivities.keySet();
        for (String process : processIds) {
            Map<String, ActivityInfo> stringActivityInfoMap = this.allProcessesAndLocalizedActivities.get(process);
            Collection<ActivityInfo> activities = stringActivityInfoMap.values();
            ArrayList<String> list = new ArrayList<String>();
            for (ActivityInfo activityInfo : activities) {
                if (!filter.accepts(activityInfo)) continue;
                list.add(activityInfo.getActivityName());
            }
            activitiesByProcess.put(process, list);
        }
        this.addSelectedActivities(activitiesByProcess);
    }

    public void selectAllActivitiesByProcess() {
        Map<String, List<String>> selectedActivities = this.getSelectedActivitiesByProcess();
        selectedActivities.clear();
        for (Map.Entry<String, Map<String, ActivityInfo>> activitiesByProcess : this.allProcessesAndLocalizedActivities.entrySet()) {
            String processId = activitiesByProcess.getKey();
            ArrayList<String> activities = new ArrayList<String>(activitiesByProcess.getValue().keySet());
            selectedActivities.put(processId, activities);
        }
    }

    public void selectAllActivitiesByProcessFor(String consolidatedProcessId) {
        Map<String, List<String>> selectedActivities = this.getSelectedActivitiesByProcess();
        for (Map.Entry<String, Map<String, ActivityInfo>> entry : this.allProcessesAndLocalizedActivities.entrySet()) {
            if (!entry.getKey().equals(consolidatedProcessId)) continue;
            String processId = entry.getKey();
            ArrayList<String> activities = new ArrayList<String>(entry.getValue().keySet());
            selectedActivities.put(processId, activities);
        }
    }

    public static interface Filter<T> {
        public boolean accepts(T var1);
    }

    public static class LocalizedActivityCheckTree
    extends ActivityCheckTree {
        private LocalizedActivityCheckTree(UiContainer parent, ActivityCheckTreeNode root, Map<String, Map<String, ActivityInfo>> activitiesByProcess) {
            super(parent, root, activitiesByProcess);
        }

        public static ActivityCheckTree createLocalizedActivityCheckTree(UiContainer parent, Map<String, Map<String, ActivityInfo>> activitiesByProcess) {
            LocalizedActivityCheckTree tree = null;
            ActivityCheckTreeNode activityRoot = ActivityCheckTreeNode.createRootNode(null, tree);
            tree = LocalizedActivityCheckTree.createLocalizedActivityCheckTree(parent, activityRoot, activitiesByProcess);
            tree.setShowsRootHandles(true);
            CheckTreeNode rootNode = tree.getRoot();
            for (Map.Entry<String, Map<String, ActivityInfo>> entry : activitiesByProcess.entrySet()) {
                String consolidatedProcessId = entry.getKey();
                Map<String, ActivityInfo> localizedActivitiesMap = entry.getValue();
                if (localizedActivitiesMap.isEmpty()) continue;
                ActivityCheckTreeNode processNode = ActivityCheckTreeNode.createProcessNode(consolidatedProcessId, null, tree);
                rootNode.add((CheckTreeNode)processNode);
                for (Map.Entry<String, ActivityInfo> activityIdAndLabel : localizedActivitiesMap.entrySet()) {
                    LocalizedActivityCheckTreeNode activityNode = new LocalizedActivityCheckTreeNode(consolidatedProcessId, activityIdAndLabel, null, tree);
                    processNode.add(activityNode);
                }
            }
            rootNode.expand();
            return tree;
        }

        private static LocalizedActivityCheckTree createLocalizedActivityCheckTree(UiContainer parent, ActivityCheckTreeNode root, Map<String, Map<String, ActivityInfo>> activitiesByProcess) {
            return new LocalizedActivityCheckTree(parent, root, activitiesByProcess);
        }
    }
}

