/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes.dataassociations;

import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;

public enum DataAssignmentOperation {
    COPY("copy", ProjectModelMsg.DATA_ASSIGNMENT_OPERATION_COPY),
    COPY_LIST("copy_list", ProjectModelMsg.DATA_ASSIGNMENT_OPERATION_COPY_LIST),
    APPEND("append", ProjectModelMsg.DATA_ASSIGNMENT_OPERATION_APPEND),
    INSERT_AFTER("insert_after", ProjectModelMsg.DATA_ASSIGNMENT_OPERATION_INSERT_AFTER),
    INSERT_BEFORE("insert_before", ProjectModelMsg.DATA_ASSIGNMENT_OPERATION_INSERT_BEFORE);

    private Msg msg;
    private String id;

    public static DataAssignmentOperation getDefault() {
        return COPY;
    }

    private DataAssignmentOperation(String id, Msg msg) {
        this.id = id;
        this.msg = msg;
    }

    public Msg getMsg() {
        return this.msg;
    }

    public String getId() {
        return this.id;
    }

    public static DataAssignmentOperation fromId(String operationId) {
        DataAssignmentOperation result = null;
        for (DataAssignmentOperation operation : DataAssignmentOperation.values()) {
            if (!operation.getId().equalsIgnoreCase(operationId)) continue;
            result = operation;
            break;
        }
        return result;
    }
}

