/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes.activities;

import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.resources.Msg;

public class ParentScopeFeature
extends StringFeature {
    private FlowNode node;
    private Subprocess scope;
    private static final String PARENT_SCOPE = "parentScope";

    private ParentScopeFeature(FlowNode node, String featureName, Msg label, Msg description) {
        super(featureName, label, description, null);
        this.node = node;
    }

    public static ParentScopeFeature create(FlowNode node) {
        return new ParentScopeFeature(node, PARENT_SCOPE, null, null);
    }

    public FlowNode getActivity() {
        return this.node;
    }

    @Override
    public void setValue(String value) {
        Activity act;
        Subprocess activityScope = null;
        if (value != null && (act = this.getActivity().getProcess().findActivity(value)).isSubprocess()) {
            activityScope = act.asActivity(Subprocess.class);
        }
        this.setParentScope(activityScope);
    }

    public Subprocess getParentScope() {
        return this.scope;
    }

    public void setParentScope(Subprocess scope) {
        this.scope = scope;
        super.setValue(scope == null ? null : scope.getId());
    }

    @Override
    public boolean isPublic() {
        return false;
    }
}

